/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.provider.comm.IConnectRequestHandler;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.generic.ServerSOContainer;
import org.eclipse.ecf.provider.generic.TCPServerSOContainerGroup;

public class TCPServerSOContainer
extends ServerSOContainer
implements IConnectRequestHandler {
    public static final String DEFAULT_PROTOCOL = "ecftcp";
    public static final int DEFAULT_PORT = Integer.parseInt(System.getProperty("org.eclipse.ecf.provider.generic.port", "3282"));
    public static final int DEFAULT_KEEPALIVE = Integer.parseInt(System.getProperty("org.eclipse.ecf.provider.generic.keepalive", "30000"));
    public static final String DEFAULT_NAME = System.getProperty("org.eclipse.ecf.provider.generic.name", "/server");
    public static String DEFAULT_HOST = System.getProperty("org.eclipse.ecf.provider.generic.host", "localhost");
    public static final boolean DEFAULT_FALLBACK_PORT = Boolean.valueOf(System.getProperty("org.eclipse.ecf.provider.generic.port.fallback", "true"));
    protected int keepAlive;
    protected TCPServerSOContainerGroup group;
    protected boolean isSingle = false;

    static {
        Boolean useHostname = Boolean.valueOf(System.getProperty("org.eclipse.ecf.provider.generic.host.useHostName", "true"));
        if (useHostname.booleanValue()) {
            try {
                DEFAULT_HOST = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                DEFAULT_HOST = "localhost";
            }
        }
    }

    protected int getKeepAlive() {
        return this.keepAlive;
    }

    public static String getServerURL(String host, String name) {
        return "ecftcp://" + host + ":" + DEFAULT_PORT + name;
    }

    public static String getDefaultServerURL() {
        return TCPServerSOContainer.getServerURL("localhost", DEFAULT_NAME);
    }

    public TCPServerSOContainer(ISharedObjectContainerConfig config, int port, InetAddress bindAddress, String path, int keepAlive) throws IOException {
        super(config);
        this.isSingle = true;
        if (path == null) {
            throw new NullPointerException("path cannot be null");
        }
        this.group = new TCPServerSOContainerGroup(TCPServerSOContainerGroup.DEFAULT_GROUP_NAME, null, 50, port, bindAddress);
        this.group.add(path, this);
        this.group.putOnTheAir();
    }

    public TCPServerSOContainer(ISharedObjectContainerConfig config, InetAddress bindAddress, int keepAlive) throws IOException, URISyntaxException {
        super(config);
        this.isSingle = true;
        URI actualURI = this.parseAndValidateURI();
        int port = actualURI.getPort();
        String path = actualURI.getPath();
        if (path == null) {
            throw new NullPointerException("path cannot be null");
        }
        this.group = new TCPServerSOContainerGroup(TCPServerSOContainerGroup.DEFAULT_GROUP_NAME, null, port, 50, bindAddress);
        this.group.add(path, this);
        this.group.putOnTheAir();
    }

    public TCPServerSOContainer(ISharedObjectContainerConfig config, TCPServerSOContainerGroup grp, int keepAlive) throws IOException, URISyntaxException {
        super(config);
        this.keepAlive = keepAlive;
        URI actualURI = this.parseAndValidateURI();
        int urlPort = actualURI.getPort();
        String path = actualURI.getPath();
        if (grp == null) {
            this.isSingle = true;
            this.group = new TCPServerSOContainerGroup(urlPort);
        } else {
            this.group = grp;
        }
        this.group.add(path, this);
        if (grp == null) {
            this.group.putOnTheAir();
        }
    }

    private URI parseAndValidateURI() throws URISyntaxException {
        URI uri = new URI(this.getID().getName());
        uri.parseServerAuthority();
        return uri;
    }

    public TCPServerSOContainer(ISharedObjectContainerConfig config, TCPServerSOContainerGroup listener, String path, int keepAlive) {
        super(config);
        this.initialize(listener, path, keepAlive);
    }

    protected void initialize(TCPServerSOContainerGroup listener, String path, int ka) {
        this.keepAlive = ka;
        this.group = listener;
        this.group.add(path, this);
    }

    @Override
    public void dispose() {
        URI aURI = null;
        try {
            aURI = new URI(this.getID().getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.group.remove(aURI.getPath());
        if (this.isSingle) {
            this.group.takeOffTheAir();
        }
        super.dispose();
    }

    public TCPServerSOContainer(ISharedObjectContainerConfig config) throws IOException, URISyntaxException {
        this(config, (TCPServerSOContainerGroup)null, DEFAULT_KEEPALIVE);
    }

    public TCPServerSOContainer(ISharedObjectContainerConfig config, int keepAlive) throws IOException, URISyntaxException {
        this(config, (TCPServerSOContainerGroup)null, keepAlive);
    }

    @Override
    public Serializable handleConnectRequest(Socket socket, String target, Serializable data, ISynchAsynchConnection conn) {
        return this.acceptNewClient(socket, target, data, conn);
    }

    protected Serializable getConnectDataFromInput(Serializable input) throws Exception {
        return input;
    }
}

