/*
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */
package org.apache.hc.client5.http.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.ssl.TrustStrategy;

/**
 * A trust strategy that accepts self-signed certificates as trusted. Verification of all other
 * certificates is done by the trust manager configured in the SSL context.
 *
 * <h2>Security Warning</h2>
 * This acts like {@link TrustAllStrategy}, with the only restriction that the certificate chain
 * must have length 1. This means this trust strategy does not protect against man-in-the-middle
 * attacks. See the {@link TrustAllStrategy} for more information and more secure alternatives.
 *
 * @deprecated
 *      For self-signed certificates prefer specifying a keystore containing the certificate when
 *      calling the {@link org.apache.hc.core5.ssl.SSLContextBuilder} {@code loadTrustMaterial}
 *      methods.
 * @since 4.1
 */
@Deprecated
@Contract(threading = ThreadingBehavior.STATELESS)
public class TrustSelfSignedStrategy implements TrustStrategy {

    /**
     * Default instance of {@link TrustSelfSignedStrategy}
     */
    public static final TrustSelfSignedStrategy INSTANCE = new TrustSelfSignedStrategy();

    @Override
    public boolean isTrusted(
            final X509Certificate[] chain, final String authType) throws CertificateException {
        return chain.length == 1;
    }

}
