/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.sharedobject.util;

import java.util.Map;

public class PropertiesUtil {
    public static final <T> T getProperty(Class<T> type, Map<String, ?> properties, String name, T def) {
        if (properties == null) {
            return def;
        }
        if (name == null) {
            return def;
        }
        Object o = properties.get(name);
        if (o == null) {
            return def;
        }
        if (type.isInstance(o)) {
            return (T)o;
        }
        return def;
    }

    public static final String getPropertyString(Map<String, ?> properties, String name, String def) {
        return PropertiesUtil.getProperty(String.class, properties, name, def);
    }

    public static final String getPropertyString(Map<String, ?> properties, String name) {
        return PropertiesUtil.getPropertyString(properties, name, null);
    }

    public static final float getPropertyFloat(Map<String, ?> properties, String name, float def) {
        return PropertiesUtil.getProperty(Float.class, properties, name, Float.valueOf(def)).floatValue();
    }

    public static final float getPropertyFloat(Map<String, ?> properties, String name) {
        return PropertiesUtil.getPropertyFloat(properties, name, 0.0f);
    }

    public static final double getPropertyDouble(Map<String, ?> properties, String name, double def) {
        return PropertiesUtil.getProperty(Double.class, properties, name, def);
    }

    public static final double getPropertyDouble(Map<String, ?> properties, String name) {
        return PropertiesUtil.getPropertyDouble(properties, name, 0.0);
    }

    public static final int getPropertyInteger(Map<String, ?> properties, String name, int def) {
        return PropertiesUtil.getProperty(Integer.class, properties, name, def);
    }

    public static final int getPropertyInteger(Map<String, ?> properties, String name) {
        return PropertiesUtil.getPropertyInteger(properties, name, 0);
    }

    public static final long getPropertyLong(Map<String, ?> properties, String name, long def) {
        return PropertiesUtil.getProperty(Long.class, properties, name, def);
    }

    public static final long getPropertyLong(Map<String, ?> properties, String name) {
        return PropertiesUtil.getPropertyLong(properties, name, 0L);
    }

    public static final boolean getPropertyBoolean(Map<String, ?> properties, String name, boolean def) {
        return PropertiesUtil.getProperty(Boolean.class, properties, name, def);
    }

    public static final boolean getPropertyBoolean(Map<String, ?> properties, String name) {
        return PropertiesUtil.getPropertyBoolean(properties, name, false);
    }

    public static final byte[] getPropertyBytes(Map<String, ?> properties, String name, byte[] def) {
        if (properties == null) {
            return def;
        }
        if (name == null) {
            return def;
        }
        Object o = properties.get(name);
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        return def;
    }

    public static final byte[] getPropertyBytes(Map<String, ?> properties, String name) {
        return PropertiesUtil.getPropertyBytes(properties, name, null);
    }
}

