/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservices.tooling.bndtools.editors;

import org.eclipse.ecf.remoteservices.tooling.bndtools.editors.EditorColors;
import org.eclipse.ecf.remoteservices.tooling.bndtools.editors.Words;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class CodeScanner
extends RuleBasedScanner {
    private TextAttribute commentAttribute = new TextAttribute(EditorColors.getColor("color_comment"), null, 0);
    private TextAttribute docAttribute = new TextAttribute(EditorColors.getColor("color_doc"), null, 0);
    private TextAttribute keywordAttribute = new TextAttribute(EditorColors.getColor("color_keyword"), null, 1);
    private TextAttribute stringAttribute = new TextAttribute(EditorColors.getColor("color_string"), null, 0);
    private TextAttribute numberAttribute = new TextAttribute(EditorColors.getColor("color_number"), null, 0);
    private TextAttribute normalAttribute = new TextAttribute(EditorColors.getColor("color_normal"), null, 0);

    public CodeScanner() {
        this.createRules();
    }

    public TextAttribute getCommentAttribute() {
        return this.commentAttribute;
    }

    public TextAttribute getDocAttribute() {
        return this.docAttribute;
    }

    private void createRules() {
        Token keywordToken = new Token((Object)this.keywordAttribute);
        Token commentToken = new Token((Object)this.commentAttribute);
        Token docToken = new Token((Object)this.docAttribute);
        Token stringToken = new Token((Object)this.stringAttribute);
        Token numberToken = new Token((Object)this.numberAttribute);
        Token normalToken = new Token((Object)this.normalAttribute);
        this.setDefaultReturnToken((IToken)normalToken);
        this.setRules(new IRule[]{new EndOfLineRule("//", (IToken)commentToken), new KeywordRule(keywordToken), new MultiLineRule("/**", "*/", (IToken)docToken, '\u0000', false), new MultiLineRule("/*", "*/", (IToken)commentToken, '\u0000', false), new SingleLineRule("\"", "\"", (IToken)stringToken, '\\'), new SingleLineRule("/", "/", (IToken)stringToken, '\\'), new SingleLineRule("'", "'", (IToken)stringToken, '\\'), new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char c) {
                return Character.isWhitespace(c);
            }
        }), new WordRule((IWordDetector)new WordDetector(), (IToken)normalToken), new NumberRule((IToken)numberToken)});
    }

    private static class KeywordRule
    extends WordRule {
        public KeywordRule(Token token) {
            super((IWordDetector)new WordDetector());
            String[] stringArray = Words.KEYWORDS;
            int n = Words.KEYWORDS.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                this.addWord(word, (IToken)token);
                ++n2;
            }
        }
    }

    private static class WordDetector
    implements IWordDetector {
        private WordDetector() {
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }
    }
}

