/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice;

import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.events.IRemoteCallCompleteEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallStartEvent;

public abstract class AbstractRemoteCallListener
implements IRemoteCallListener {
    protected IRemoteCall remoteCall;
    protected IRemoteServiceReference remoteReference;

    @Override
    public void handleEvent(IRemoteCallEvent event) {
        if (event instanceof IRemoteCallStartEvent) {
            this.handleRemoteCallStartEvent((IRemoteCallStartEvent)event);
        } else if (event instanceof IRemoteCallCompleteEvent) {
            this.handleRemoteCallCompleteEvent((IRemoteCallCompleteEvent)event);
        }
    }

    protected IRemoteCall getRemoteCall() {
        return this.remoteCall;
    }

    protected IRemoteServiceReference getRemoteServiceReference() {
        return this.remoteReference;
    }

    protected void handleRemoteCallCompleteEvent(IRemoteCallCompleteEvent event) {
        if (event.hadException()) {
            this.handleRemoteCallException(event.getException());
        } else {
            this.handleRemoteCallComplete(event.getResponse());
        }
        this.remoteCall = null;
        this.remoteReference = null;
    }

    protected abstract void handleRemoteCallComplete(Object var1);

    protected abstract void handleRemoteCallException(Throwable var1);

    protected void handleRemoteCallStartEvent(IRemoteCallStartEvent event) {
        this.remoteCall = event.getCall();
        this.remoteReference = event.getReference();
    }
}

