/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.osgi.impl;

import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.osgi.impl.HttpClientBuilderConfigurator;
import org.apache.http.osgi.impl.HttpProxyConfigurationActivator;
import org.apache.http.osgi.services.HttpClientBuilderFactory;

final class OSGiHttpClientBuilderFactory
implements HttpClientBuilderFactory {
    private final HttpClientBuilderConfigurator configurator;
    private final HttpProxyConfigurationActivator.HttpClientTracker httpClientTracker;

    OSGiHttpClientBuilderFactory(HttpClientBuilderConfigurator configurator, HttpProxyConfigurationActivator.HttpClientTracker httpClientTracker) {
        this.configurator = configurator;
        this.httpClientTracker = httpClientTracker;
    }

    @Override
    public HttpClientBuilder newBuilder() {
        return this.configurator.configure(new HttpClientBuilder(){

            @Override
            public CloseableHttpClient build() {
                CloseableHttpClient client = super.build();
                OSGiHttpClientBuilderFactory.this.httpClientTracker.track(client);
                return client;
            }
        });
    }
}

