/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.core;

import java.net.URI;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.ServiceInfo;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryContainer;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryServiceID;
import org.eclipse.ecf.provider.zookeeper.core.internal.IService;
import org.eclipse.ecf.provider.zookeeper.core.internal.Localizer;
import org.eclipse.ecf.provider.zookeeper.core.internal.Notification;
import org.eclipse.ecf.provider.zookeeper.node.internal.INode;
import org.eclipse.ecf.provider.zookeeper.util.Geo;
import org.eclipse.ecf.provider.zookeeper.util.Logger;
import org.eclipse.ecf.provider.zookeeper.util.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverdService
extends ServiceInfo
implements IService,
INode {
    private static final long serialVersionUID = 3072424087109599612L;
    private String uuid;
    private URI location;
    private IServiceTypeID serviceTypeID;

    public DiscoverdService(String path, Map<String, Object> serviceData) {
        Assert.isNotNull(serviceData);
        this.uuid = path.split("_uri_")[0];
        this.location = (URI)serviceData.remove("discovery.service.location");
        this.priority = (Integer)serviceData.remove("discovery.service.priority");
        this.weight = (Integer)serviceData.remove("discovery.service.weight");
        this.serviceName = (String)serviceData.get("discovery.service.name");
        this.properties = (IServiceProperties)serviceData.remove("node.property.service.properties");
        String[] services = (String[])serviceData.remove("node.property.name.services");
        String na = (String)serviceData.remove("node.property.name.na");
        String[] protocols = (String[])serviceData.remove("node.property.name.protocols");
        String[] scopes = (String[])serviceData.remove("node.property.name.scope");
        this.serviceTypeID = ServiceIDFactory.getDefault().createServiceTypeID(ZooDiscoveryContainer.getSingleton().getConnectNamespace(), services, scopes, protocols, na);
        this.serviceID = new ZooDiscoveryServiceID(ZooDiscoveryContainer.getSingleton().getConnectNamespace(), this, this.serviceTypeID, this.location);
    }

    public void dispose() {
        Logger.log(4, PrettyPrinter.prompt(6, this), null);
        Localizer.getSingleton().localize(new Notification(this, 2));
    }

    public String getNodeId() {
        return this.uuid;
    }

    @Override
    public void regenerateNodeId() {
        this.uuid = UUID.randomUUID().toString();
    }

    public String getName() {
        return this.uuid;
    }

    public Namespace getNamespace() {
        return ZooDiscoveryContainer.getSingleton().getConnectNamespace();
    }

    public String toExternalForm() {
        return this.uuid;
    }

    public int compareTo(Object o) {
        Assert.isTrue((o != null && o instanceof DiscoverdService ? 1 : 0) != 0, (String)"incompatible types for compare");
        return this.getServiceID().getName().compareTo(((DiscoverdService)o).getServiceID().getName());
    }

    @Override
    public byte[] getPropertiesAsBytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPath() {
        return String.valueOf(this.getServiceID().getName()) + "_uri_" + this.getLocation();
    }

    @Override
    public String getAbsolutePath() {
        return "/zoodiscovery_root/" + this.getPath();
    }

    @Override
    public boolean isLocalNode() {
        return Geo.isLocal(this.getAbsolutePath());
    }

    @Override
    public IService getWrappedService() {
        return this;
    }
}

