/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.AbstractContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.DiscoveryContainerConfig;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IDiscoveryLocator;
import org.eclipse.ecf.discovery.IServiceEvent;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.discovery.IServiceTypeEvent;
import org.eclipse.ecf.discovery.IServiceTypeListener;
import org.eclipse.ecf.discovery.ServiceContainerEvent;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.internal.discovery.DiscoveryServiceListener;
import org.eclipse.ecf.internal.discovery.IServiceInfoServiceListener;
import org.eclipse.ecf.internal.discovery.ServiceTypeComparator;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.ThreadsExecutor;

public abstract class AbstractDiscoveryContainerAdapter
extends AbstractContainer
implements IDiscoveryLocator,
IDiscoveryAdvertiser {
    protected final Set allServiceListeners;
    private DiscoveryContainerConfig config;
    protected final Map serviceListeners;
    protected final String servicesNamespaceName;
    protected final Collection serviceTypeListeners;
    private DiscoveryServiceListener discoveryServiceListener;
    private DiscoveryServiceListener discoveryServiceTypeListener;
    private ServiceTypeComparator discoveryServiceListenerComparator;
    private final IServiceInfoServiceListener iServiceInfoServiceListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AbstractDiscoveryContainerAdapter(String aNamespaceName, DiscoveryContainerConfig aConfig) {
        this.servicesNamespaceName = aNamespaceName;
        Assert.isNotNull((Object)this.servicesNamespaceName);
        this.config = aConfig;
        Assert.isNotNull((Object)this.config);
        this.serviceTypeListeners = Collections.synchronizedSet(new HashSet());
        this.serviceListeners = Collections.synchronizedMap(new HashMap());
        this.allServiceListeners = Collections.synchronizedSet(new HashSet());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.discovery.IServiceListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.discoveryServiceListener = new DiscoveryServiceListener(this, clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ecf.discovery.IServiceTypeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.discoveryServiceTypeListener = new DiscoveryServiceListener(this, clazz2);
        this.discoveryServiceListenerComparator = new ServiceTypeComparator();
        this.iServiceInfoServiceListener = new IServiceInfoServiceListener(this);
    }

    public void addServiceListener(final IServiceListener aListener) {
        Assert.isNotNull((Object)aListener);
        if (aListener.triggerDiscovery()) {
            ThreadsExecutor executor = new ThreadsExecutor();
            executor.execute(new IProgressRunnable(){

                public Object run(IProgressMonitor arg0) throws Exception {
                    IServiceInfo[] services = AbstractDiscoveryContainerAdapter.this.getServices();
                    int i = 0;
                    while (i < services.length) {
                        IServiceInfo iServiceInfo = services[i];
                        aListener.serviceDiscovered(AbstractDiscoveryContainerAdapter.this.getServiceEvent(iServiceInfo, AbstractDiscoveryContainerAdapter.this.getConfig().getID()));
                        ++i;
                    }
                    AbstractDiscoveryContainerAdapter.this.allServiceListeners.add(aListener);
                    return null;
                }
            }, null);
        } else {
            this.allServiceListeners.add(aListener);
        }
    }

    protected IServiceEvent getServiceEvent(IServiceInfo iServiceInfo, ID id) {
        return new ServiceContainerEvent(iServiceInfo, id);
    }

    public void addServiceListener(final IServiceTypeID aType, final IServiceListener aListener) {
        Assert.isNotNull((Object)aListener);
        Assert.isNotNull((Object)aType);
        if (aListener.triggerDiscovery()) {
            ThreadsExecutor executor = new ThreadsExecutor();
            executor.execute(new IProgressRunnable(){

                public Object run(IProgressMonitor arg0) throws Exception {
                    IServiceInfo[] services = AbstractDiscoveryContainerAdapter.this.getServices(aType);
                    int i = 0;
                    while (i < services.length) {
                        IServiceInfo iServiceInfo = services[i];
                        aListener.serviceDiscovered(AbstractDiscoveryContainerAdapter.this.getServiceEvent(iServiceInfo, AbstractDiscoveryContainerAdapter.this.getConfig().getID()));
                        ++i;
                    }
                    AbstractDiscoveryContainerAdapter.this.addServiceListener0(aType, aListener);
                    return null;
                }
            }, null);
        } else {
            this.addServiceListener0(aType, aListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServiceListener0(IServiceTypeID aType, IServiceListener aListener) {
        Map map = this.serviceListeners;
        synchronized (map) {
            Set<IServiceListener> v = (Set<IServiceListener>)this.serviceListeners.get(aType);
            if (v == null) {
                v = Collections.synchronizedSet(new HashSet());
                this.serviceListeners.put(aType, v);
            }
            v.add(aListener);
        }
    }

    public void addServiceTypeListener(IServiceTypeListener aListener) {
        Assert.isNotNull((Object)aListener);
        this.serviceTypeListeners.add(aListener);
    }

    protected void clearListeners() {
        this.serviceListeners.clear();
        this.serviceTypeListeners.clear();
        this.allServiceListeners.clear();
    }

    public void dispose() {
        this.disconnect();
        this.clearListeners();
        this.config = null;
        this.discoveryServiceListener.dispose();
        this.discoveryServiceTypeListener.dispose();
        this.iServiceInfoServiceListener.dispose();
        super.dispose();
    }

    protected void fireServiceDiscovered(IServiceEvent aServiceEvent) {
        Assert.isNotNull((Object)aServiceEvent);
        Collection listeners = this.getListeners(aServiceEvent.getServiceInfo().getServiceID().getServiceTypeID());
        if (listeners != null) {
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                IServiceListener l = (IServiceListener)i.next();
                l.serviceDiscovered(aServiceEvent);
                Trace.trace((String)"org.eclipse.ecf.discovery", (String)"org.eclipse.ecf.discovery/debug/methods/tracing", this.getClass(), (String)"fireServiceDiscovered", (String)aServiceEvent.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireServiceTypeDiscovered(IServiceTypeEvent aServiceTypeEvent) {
        Assert.isNotNull((Object)aServiceTypeEvent);
        ArrayList notify = null;
        Collection collection = this.serviceTypeListeners;
        synchronized (collection) {
            notify = new ArrayList(this.serviceTypeListeners);
        }
        Iterator i = notify.iterator();
        while (i.hasNext()) {
            IServiceTypeListener l = (IServiceTypeListener)i.next();
            l.serviceTypeDiscovered(aServiceTypeEvent);
            Trace.trace((String)"org.eclipse.ecf.discovery", (String)"org.eclipse.ecf.discovery/debug/methods/tracing", this.getClass(), (String)"fireServiceTypeDiscovered", (String)aServiceTypeEvent.toString());
        }
    }

    protected void fireServiceUndiscovered(IServiceEvent aServiceEvent) {
        Assert.isNotNull((Object)aServiceEvent);
        Collection listeners = this.getListeners(aServiceEvent.getServiceInfo().getServiceID().getServiceTypeID());
        if (listeners != null) {
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                IServiceListener l = (IServiceListener)i.next();
                l.serviceUndiscovered(aServiceEvent);
                Trace.trace((String)"org.eclipse.ecf.discovery", (String)"org.eclipse.ecf.discovery/debug/methods/tracing", this.getClass(), (String)"fireServiceUndiscovered", (String)aServiceEvent.toString());
            }
        }
    }

    protected DiscoveryContainerConfig getConfig() {
        return this.config;
    }

    public Namespace getConnectNamespace() {
        return IDFactory.getDefault().getNamespaceByName(this.servicesNamespaceName);
    }

    public ID getID() {
        if (this.config != null) {
            return this.config.getID();
        }
        return null;
    }

    public abstract String getContainerName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection getListeners(IServiceTypeID aServiceType) {
        Assert.isNotNull((Object)aServiceType);
        HashSet listeners = new HashSet();
        Object object = this.serviceListeners;
        synchronized (object) {
            Iterator itr = this.serviceListeners.keySet().iterator();
            while (itr.hasNext()) {
                Collection collection;
                IServiceTypeID typeID = (IServiceTypeID)itr.next();
                int compare = this.discoveryServiceListenerComparator.compare(aServiceType, typeID);
                if (compare != 0 || (collection = (Collection)this.serviceListeners.get(typeID)) == null) continue;
                listeners.addAll(collection);
            }
        }
        object = this.allServiceListeners;
        synchronized (object) {
            listeners.addAll(this.allServiceListeners);
        }
        return Collections.unmodifiableCollection(listeners);
    }

    public Namespace getServicesNamespace() {
        return IDFactory.getDefault().getNamespaceByName(this.servicesNamespaceName);
    }

    public void removeServiceListener(IServiceListener aListener) {
        Assert.isNotNull((Object)aListener);
        this.allServiceListeners.remove(aListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(IServiceTypeID aType, IServiceListener aListener) {
        Assert.isNotNull((Object)aListener);
        Assert.isNotNull((Object)aType);
        Map map = this.serviceListeners;
        synchronized (map) {
            Collection v = (Collection)this.serviceListeners.get(aType);
            if (v != null) {
                v.remove(aListener);
            }
        }
    }

    public void removeServiceTypeListener(IServiceTypeListener aListener) {
        Assert.isNotNull((Object)aListener);
        this.serviceTypeListeners.remove(aListener);
    }

    public void unregisterAllServices() {
        throw new UnsupportedOperationException("Not yet implemeted");
    }

    public IServiceInfo[] purgeCache() {
        return new IServiceInfo[0];
    }

    public IFuture getAsyncServiceInfo(final IServiceID service) {
        ThreadsExecutor executor = new ThreadsExecutor();
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return AbstractDiscoveryContainerAdapter.this.getServiceInfo(service);
            }
        }, null);
    }

    public IFuture getAsyncServiceTypes() {
        ThreadsExecutor executor = new ThreadsExecutor();
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return AbstractDiscoveryContainerAdapter.this.getServiceTypes();
            }
        }, null);
    }

    public IFuture getAsyncServices() {
        ThreadsExecutor executor = new ThreadsExecutor();
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return AbstractDiscoveryContainerAdapter.this.getServices();
            }
        }, null);
    }

    public IFuture getAsyncServices(final IServiceTypeID type) {
        ThreadsExecutor executor = new ThreadsExecutor();
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return AbstractDiscoveryContainerAdapter.this.getServices(type);
            }
        }, null);
    }
}

