/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.ui.wizards;

import java.net.URI;
import org.eclipse.ecf.internal.ui.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractConnectWizardPage
extends WizardPage {
    Text connectText;
    private Text usernameText;
    private Text passwordText;
    private ModifyListener inputVerifier = new InputVerifier();
    private Button autoLoginBtn;
    private URI uri;

    protected AbstractConnectWizardPage(String pageName) {
        super(pageName);
        this.setTitle(this.getProviderTitle());
        this.setDescription(this.getProviderDescription());
        this.setPageComplete(false);
    }

    protected AbstractConnectWizardPage(String pageName, URI uri) {
        this(pageName);
        this.uri = uri;
    }

    public void createControl(Composite parent) {
        String exampleID;
        parent.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(4, 0x1000000, true, false);
        GridData span = new GridData(0x1000008, 0x1000000, true, false, 2, 1);
        Label label = new Label(parent, 16384);
        label.setText(Messages.AbstractConnectWizardPage_CONNECT_ID_LABEL);
        this.connectText = new Text(parent, 2052);
        this.connectText.setLayoutData((Object)data);
        this.connectText.addModifyListener(this.inputVerifier);
        String defaultConnectText = this.getDefaultConnectText();
        if (defaultConnectText != null && !defaultConnectText.equals("")) {
            this.connectText.setText(defaultConnectText);
        }
        if ((exampleID = this.getExampleID()) != null && !exampleID.equals("")) {
            label = new Label(parent, 131072);
            label.setText(this.getExampleID());
            label.setLayoutData((Object)span);
        }
        if (this.shouldRequestUsername()) {
            label = new Label(parent, 16384);
            label.setText(Messages.AbstractConnectWizardPage_USERNAME_LABEL);
            this.usernameText = new Text(parent, 2052);
            this.usernameText.setLayoutData((Object)data);
            this.usernameText.addModifyListener(this.inputVerifier);
        }
        if (this.shouldRequestUsername()) {
            label = new Label(parent, 16384);
            label.setText(Messages.AbstractConnectWizardPage_PASSWORD_LABEL);
            this.passwordText = new Text(parent, 2052);
            this.passwordText.setLayoutData((Object)data);
            this.passwordText.setEchoChar('*');
            this.passwordText.addModifyListener(this.inputVerifier);
        }
        this.autoLoginBtn = new Button(parent, 32);
        this.autoLoginBtn.setText(Messages.AbstractConnectWizardPage_LOGIN_AUTOMATICALLY_LABEL);
        this.autoLoginBtn.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false, 2, 1));
        if (this.uri != null) {
            this.connectText.setText(this.uri.toString());
            this.usernameText.setFocus();
        }
        this.setControl((Control)parent);
    }

    public abstract boolean shouldRequestUsername();

    public abstract boolean shouldRequestPassword();

    public abstract String getExampleID();

    protected String getDefaultConnectText() {
        return "";
    }

    protected String getProviderTitle() {
        return Messages.AbstractConnectWizardPage_PROVIDER_TITLE;
    }

    protected String getProviderDescription() {
        return null;
    }

    public String getConnectID() {
        return this.connectText.getText();
    }

    public String getUsername() {
        return this.usernameText.getText();
    }

    public String getPassword() {
        return this.passwordText.getText();
    }

    boolean shouldAutoLogin() {
        return this.autoLoginBtn.getSelection();
    }

    public void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    class InputVerifier
    implements ModifyListener {
        InputVerifier() {
        }

        public void modifyText(ModifyEvent e) {
            if (AbstractConnectWizardPage.this.connectText.getText().equals("")) {
                AbstractConnectWizardPage.this.updateStatus(Messages.AbstractConnectWizardPage_CONNECTID_ERROR_STATUS);
            } else {
                AbstractConnectWizardPage.this.updateStatus(null);
            }
        }
    }
}

