/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.examples.internal.eventadmin.app;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.ecf.examples.internal.eventadmin.app.AbstractEventAdminApplication;
import org.eclipse.ecf.examples.internal.eventadmin.app.TestEventHandler;
import org.eclipse.ecf.examples.internal.eventadmin.app.TestSender;
import org.eclipse.equinox.app.IApplication;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public class EventAdminManagerApplication
extends AbstractEventAdminApplication
implements IApplication {
    private static final String DEFAULT_CONTAINER_TYPE = "ecf.jms.activemq.tcp.manager";
    public static final String DEFAULT_CONTAINER_ID = "tcp://localhost:61616/exampleTopic";
    private TestSender testSender;
    private ServiceRegistration testEventHandlerRegistration;

    @Override
    protected Object run() {
        Properties props = new Properties();
        props.put("event.topics", "*");
        this.testEventHandlerRegistration = this.bundleContext.registerService(EventHandler.class.getName(), (Object)new TestEventHandler("Server"), (Dictionary)props);
        this.testSender = new TestSender((EventAdmin)this.eventAdminImpl, this.topics, this.container.getID().getName());
        new Thread(this.testSender).start();
        this.waitForDone();
        return IApplication.EXIT_OK;
    }

    @Override
    protected void shutdown() {
        if (this.testSender != null) {
            this.testSender.stop();
            this.testSender = null;
        }
        if (this.testEventHandlerRegistration != null) {
            this.testEventHandlerRegistration.unregister();
            this.testEventHandlerRegistration = null;
        }
        super.shutdown();
    }

    @Override
    protected String usageApplicationId() {
        return "org.eclipse.ecf.examples.eventadmin.app.EventAdminManager";
    }

    @Override
    protected String usageParameters() {
        StringBuffer buf = new StringBuffer("\n\t-containerType <default:ecf.jms.activemq.tcp.manager>");
        buf.append("\n\t-containerId <default:tcp://localhost:61616/exampleTopic>");
        buf.append("\n\t-topic <default:defaultTopic>");
        return buf.toString();
    }

    @Override
    protected void processArgs(String[] args) {
        this.containerType = DEFAULT_CONTAINER_TYPE;
        this.containerId = DEFAULT_CONTAINER_ID;
        this.targetId = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-containerType")) {
                this.containerType = args[i + 1];
                ++i;
            } else if (args[i].equals("-containerId")) {
                this.containerId = args[i + 1];
                ++i;
            } else if (args[i].equals("-topic")) {
                this.topics = new String[]{args[i + 1]};
                ++i;
            }
            ++i;
        }
    }
}

