/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.roster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.roster.IRoster;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.presence.roster.RosterItem;

public class Roster
extends RosterItem
implements IRoster {
    protected List rosteritems;
    protected IUser rosterUser;
    protected IPresenceContainerAdapter presenceContainer;

    public Roster(IPresenceContainerAdapter pc, IUser user) {
        super(null, user == null ? "<unknown>" : (user.getName() == null ? user.getID().getName() : user.getName()));
        this.presenceContainer = pc;
        this.rosterUser = user;
        this.rosteritems = Collections.synchronizedList(new ArrayList());
    }

    public Roster(IPresenceContainerAdapter presenceContainer) {
        this(presenceContainer, null);
    }

    @Override
    public Collection getItems() {
        return this.rosteritems;
    }

    @Override
    public String getName() {
        return this.getUser().getName();
    }

    @Override
    public IUser getUser() {
        return this.rosterUser;
    }

    public boolean addItem(IRosterItem item) {
        if (item == null) {
            return false;
        }
        return this.rosteritems.add(item);
    }

    public boolean removeItem(IRosterItem item) {
        if (item == null) {
            return false;
        }
        return this.rosteritems.remove(item);
    }

    public void setUser(IUser user) {
        this.rosterUser = user;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Roster[");
        buf.append("pc=").append(this.getPresenceContainerAdapter());
        buf.append(";user=").append(this.getUser());
        buf.append(";items=").append(this.getItems()).append("]");
        return buf.toString();
    }

    @Override
    public IPresenceContainerAdapter getPresenceContainerAdapter() {
        return this.presenceContainer;
    }
}

