/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.filter.ui;

import java.util.List;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionReal;
import org.eclipse.rmf.reqif10.search.filter.IFilter;
import org.eclipse.rmf.reqif10.search.filter.NumberFilter;
import org.eclipse.rmf.reqif10.search.filter.ui.FilterControl;
import org.eclipse.rmf.reqif10.search.filter.ui.FilterPanel;
import org.eclipse.rmf.reqif10.search.filter.ui.NumberControl;
import org.eclipse.swt.layout.GridData;

public class FilterControlNumber
extends FilterControl {
    private NumberControl[] control;

    public FilterControlNumber(FilterPanel parent, AttributeDefinition attribute) {
        super(parent, attribute);
    }

    public FilterControlNumber(FilterPanel parent, NumberFilter template) {
        super(parent, (IFilter)template);
    }

    @Override
    protected List<IFilter.Operator> getOperators() {
        return NumberFilter.SUPPORTED_OPERATORS.asList();
    }

    @Override
    protected void updateValueControls(boolean initialize) {
        if (this.getOperator() == IFilter.Operator.IS_SET || this.getOperator() == IFilter.Operator.IS_NOT_SET) {
            this.showControl(0, false);
            this.showControl(1, false);
        } else if (this.getOperator() == IFilter.Operator.BETWEEN) {
            this.showControl(0, true);
            this.showControl(1, true);
        } else {
            this.showControl(0, true);
            this.showControl(1, false);
        }
        if (initialize) {
            if (this.templateFilter.getFilterValue1() != null) {
                this.control[0].setValue((Number)this.templateFilter.getFilterValue1());
            }
            if (this.templateFilter.getFilterValue2() != null) {
                this.control[1].setValue((Number)this.templateFilter.getFilterValue2());
            }
        }
        this.layout();
    }

    private void showControl(int controlId, boolean show) {
        if (this.control == null) {
            this.control = new NumberControl[2];
        }
        if (show && this.control[controlId] == null) {
            this.control[controlId] = new NumberControl(this, this.attribute instanceof AttributeDefinitionReal);
            GridData layoutData = new GridData(4, 0x1000000, true, false);
            this.control[controlId].getControl().setLayoutData((Object)layoutData);
        }
        if (!show && this.control[controlId] != null) {
            this.control[controlId].getControl().dispose();
            this.control[controlId] = null;
        }
    }

    @Override
    public IFilter getFilter() {
        Number value1 = this.control[0] == null ? (Number)null : (Number)this.control[0].getNumber();
        Number value2 = this.control[1] == null ? (Number)null : (Number)this.control[1].getNumber();
        return new NumberFilter(this.getOperator(), value1, value2, (AttributeDefinition)this.attribute);
    }
}

