/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.remote.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.remote.ui.messages.RemoteMessages;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportConnectionNodeElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportTraceFilesElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportTraceGroupElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.TmfWorkspaceModifyOperation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ArchiveUtil;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.FileSystemObjectImportStructureProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.IFileSystemObject;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportConfirmation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportConflictHandler;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TraceFileSystemElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TraceValidateAndImportOperation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceCoreUtils;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class RemoteImportTracesOperation
extends TmfWorkspaceModifyOperation {
    private static final String TRACE_IMPORT = ".traceRemoteImport";
    private static final int BUFFER_IN_KB = 16;
    private static final int BYTES_PER_KB = 1024;
    private IStatus fStatus;
    private final Shell fShell;
    private final TmfTraceFolder fDestination;
    private final Object[] fTraceElements;
    private final ImportConflictHandler fConflictHandler;
    private final List<IResource> fImportedResources = new ArrayList<IResource>();

    public RemoteImportTracesOperation(Shell shell, TmfTraceFolder destination, Object[] elements, boolean overwriteAll) {
        this.fShell = shell;
        this.fDestination = destination;
        this.fTraceElements = Arrays.copyOf(elements, elements.length);
        this.fConflictHandler = overwriteAll ? new ImportConflictHandler(this.fShell, destination, ImportConfirmation.OVERWRITE_ALL) : new ImportConflictHandler(this.fShell, destination, ImportConfirmation.SKIP);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            this.doRun(monitor);
            this.setStatus(Status.OK_STATUS);
        }
        catch (InterruptedException | OperationCanceledException e) {
            this.setStatus(Status.CANCEL_STATUS);
            throw e;
        }
        catch (Exception e) {
            this.setStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.remote.ui", RemoteMessages.RemoteImportTracesOperation_ImportFailure, (Throwable)e));
            throw new InvocationTargetException(e);
        }
    }

    private void doRun(IProgressMonitor monitor) throws ExecutionException, CoreException, IOException, InterruptedException {
        IFolder destinationFolder = this.fDestination.getResource();
        if (!destinationFolder.exists()) {
            throw new ExecutionException(String.valueOf(RemoteMessages.RemoteImportTracesOperation_ImportDialogInvalidTracingProject) + " (" + "Traces" + ")");
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.fTraceElements.length * 4));
        subMonitor.beginTask(RemoteMessages.RemoteImportTracesOperation_DownloadTask, this.fTraceElements.length * 4);
        Object[] objectArray = this.fTraceElements;
        int n = this.fTraceElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object packageElement = objectArray[n2];
            if (packageElement instanceof TracePackageTraceElement) {
                TracePackageTraceElement traceElement = (TracePackageTraceElement)packageElement;
                TracePackageElement parentElement = traceElement.getParent();
                while (parentElement != null) {
                    if (parentElement instanceof RemoteImportTraceGroupElement) break;
                    parentElement = parentElement.getParent();
                }
                if (parentElement != null) {
                    RemoteImportTraceGroupElement traceGroup = (RemoteImportTraceGroupElement)parentElement;
                    String rootPath = traceGroup.getRootImportPath();
                    RemoteImportConnectionNodeElement nodeElement = (RemoteImportConnectionNodeElement)traceGroup.getParent();
                    String nodeName = nodeElement.getName();
                    IFolder nodeFolder = destinationFolder.getFolder(nodeName);
                    TracePackageElement[] children = traceElement.getChildren();
                    SubMonitor childMonitor = subMonitor.newChild(1);
                    TraceUtils.createFolder((IFolder)nodeFolder, (IProgressMonitor)childMonitor);
                    TracePackageElement[] tracePackageElementArray = children;
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TracePackageElement element = tracePackageElementArray[n4];
                        ModalContext.checkCanceled((IProgressMonitor)monitor);
                        if (element instanceof RemoteImportTraceFilesElement) {
                            RemoteImportTraceFilesElement traceFilesElement = (RemoteImportTraceFilesElement)element;
                            IFileStore remoteFile = traceFilesElement.getRemoteFile();
                            IPath sessionParentPath = TmfTraceCoreUtils.newSafePath((String)rootPath).removeLastSegments(1);
                            Path traceParentPath = TmfTraceCoreUtils.newSafePath((String)remoteFile.getParent().toURI().getPath());
                            Object relativeTracePath = Path.EMPTY;
                            if (sessionParentPath.isPrefixOf((IPath)traceParentPath)) {
                                relativeTracePath = traceParentPath.makeRelativeTo(sessionParentPath);
                            }
                            String[] segments = relativeTracePath.segments();
                            int i = 0;
                            while (i < segments.length) {
                                String segment = TmfTraceCoreUtils.validateName((String)TmfTraceCoreUtils.safePathToString((String)segments[i]));
                                relativeTracePath = i == 0 ? new Path(segment) : relativeTracePath.append(segment);
                                ++i;
                            }
                            IFolder traceFolder = nodeFolder.getFolder((IPath)new Path(relativeTracePath.toOSString()));
                            childMonitor = subMonitor.newChild(1);
                            TraceUtils.createFolder((IFolder)traceFolder, (IProgressMonitor)childMonitor);
                            childMonitor.done();
                            IResource traceRes = null;
                            IFileInfo info = remoteFile.fetchInfo();
                            traceRes = info.isDirectory() ? this.downloadDirectoryTrace(remoteFile, traceFolder, (IProgressMonitor)subMonitor.newChild(1)) : this.downloadFileTrace(remoteFile, traceFolder, (IProgressMonitor)subMonitor.newChild(1));
                            String traceName = traceElement.getText();
                            if (traceRes != null && traceRes.exists()) {
                                TraceTypeHelper traceTypeHelper = null;
                                String traceTypeStr = traceElement.getTraceType();
                                if (traceTypeStr != null) {
                                    traceTypeHelper = TmfTraceType.getTraceType((String)traceTypeStr);
                                }
                                if (traceTypeHelper == null) {
                                    try {
                                        childMonitor = subMonitor.newChild(1);
                                        childMonitor.setTaskName(NLS.bind((String)RemoteMessages.RemoteImportTracesOperation_DetectingTraceType, (Object)traceName));
                                        childMonitor.done();
                                        traceTypeHelper = TmfTraceTypeUIUtils.selectTraceType((String)traceRes.getLocation().toOSString(), null, null);
                                    }
                                    catch (TmfTraceImportException tmfTraceImportException) {
                                        // empty catch block
                                    }
                                }
                                if (traceTypeHelper != null) {
                                    TmfTraceTypeUIUtils.setTraceType((IResource)traceRes, (TraceTypeHelper)traceTypeHelper);
                                    this.fImportedResources.add(traceRes);
                                }
                                URI uri = remoteFile.toURI();
                                String sourceLocation = URIUtil.toUnencodedString((URI)uri);
                                traceRes.setPersistentProperty(TmfCommonConstants.SOURCE_LOCATION, sourceLocation);
                            }
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    private IResource downloadDirectoryTrace(IFileStore trace, IFolder traceFolder, IProgressMonitor monitor) throws CoreException, IOException, InterruptedException {
        IFileStore[] sources = trace.childStores(0, monitor);
        if (sources.length > 1) {
            String traceName = trace.getName();
            IFolder folder = traceFolder.getFolder(traceName = TmfTraceCoreUtils.validateName((String)traceName));
            String newName = this.fConflictHandler.checkAndHandleNameClash(folder.getFullPath(), monitor);
            if (newName == null) {
                return null;
            }
            folder = traceFolder.getFolder(newName);
            folder.create(true, true, null);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)sources.length);
            subMonitor.beginTask(RemoteMessages.RemoteImportTracesOperation_DownloadTask, sources.length);
            IFileStore[] iFileStoreArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore source = iFileStoreArray[n2];
                if (subMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                IPath destination = folder.getLocation().addTrailingSeparator().append(source.getName());
                IFileInfo info = source.fetchInfo();
                if (!info.isDirectory()) {
                    SubMonitor childMonitor = subMonitor.newChild(1);
                    childMonitor.setTaskName(String.valueOf(RemoteMessages.RemoteImportTracesOperation_DownloadTask) + ' ' + trace.getName() + '/' + source.getName());
                    Throwable throwable = null;
                    Object var17_18 = null;
                    try (InputStream in = source.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());){
                        this.copy(in, folder, destination, childMonitor, info.getLength());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                ++n2;
            }
            folder.refreshLocal(2, null);
            return folder;
        }
        return null;
    }

    private IResource downloadFileTrace(IFileStore trace, IFolder traceFolder, IProgressMonitor monitor) throws CoreException, IOException, InterruptedException {
        IFolder folder = traceFolder;
        String traceName = trace.getName();
        IResource resource = folder.findMember(traceName = TmfTraceCoreUtils.validateName((String)traceName));
        if (resource != null && resource.exists()) {
            String newName = this.fConflictHandler.checkAndHandleNameClash(resource.getFullPath(), monitor);
            if (newName == null) {
                return null;
            }
            traceName = newName;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        subMonitor.beginTask(RemoteMessages.RemoteImportTracesOperation_DownloadTask, 1);
        IPath destination = folder.getLocation().addTrailingSeparator().append(traceName);
        IFileInfo info = trace.fetchInfo();
        subMonitor.setTaskName(String.valueOf(RemoteMessages.RemoteImportTracesOperation_DownloadTask) + ' ' + trace.getName() + '/' + trace.getName());
        Throwable throwable = null;
        Object var11_12 = null;
        try (InputStream in = trace.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());){
            this.copy(in, folder, destination, subMonitor, info.getLength());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        folder.refreshLocal(2, null);
        return folder.findMember(traceName);
    }

    private void copy(InputStream in, IFolder destFolder, IPath destination, SubMonitor monitor, long length) throws IOException {
        block21: {
            IFolder intermediateTempFolder = null;
            IFile tempFile = null;
            File intermediateFile = null;
            try {
                try {
                    intermediateTempFolder = this.fDestination.getProject().getResource().getFolder(TRACE_IMPORT);
                    if (intermediateTempFolder.exists()) {
                        intermediateTempFolder.delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                    }
                    intermediateTempFolder.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                    tempFile = intermediateTempFolder.getFile(destination.lastSegment());
                    tempFile.create(null, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                    intermediateFile = tempFile.getLocation().toFile();
                    intermediateFile.createNewFile();
                    RemoteImportTracesOperation.copy(in, intermediateFile, length, monitor);
                    if (ArchiveUtil.isArchiveFile((File)intermediateFile)) {
                        IFolder folder;
                        FileSystemObjectImportStructureProvider importProvider = new FileSystemObjectImportStructureProvider((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null);
                        IFileSystemObject fileSystemObject = importProvider.getIFileSystemObject((Object)intermediateFile);
                        TraceFileSystemElement rootTraceFileElement = TraceFileSystemElement.createRootTraceFileElement((IFileSystemObject)fileSystemObject, (FileSystemObjectImportStructureProvider)importProvider);
                        ArrayList list = new ArrayList();
                        rootTraceFileElement.getAllChildren(list);
                        if (!destFolder.exists()) {
                            destFolder.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                        }
                        if (!(folder = destFolder.getFolder(destination.lastSegment())).exists()) {
                            folder.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                        }
                        TraceValidateAndImportOperation operation = new TraceValidateAndImportOperation(this.fShell, list, null, intermediateTempFolder.getLocation(), destFolder.getFullPath(), false, 10, this.fDestination, null, null);
                        operation.setConflictHandler(this.fConflictHandler);
                        operation.run((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                        monitor.done();
                        break block21;
                    }
                    Files.move(intermediateFile.toPath(), destination.toFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (InterruptedException | InvocationTargetException | CoreException e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                    if (intermediateFile != null && intermediateFile.exists()) {
                        intermediateFile.delete();
                    }
                    try {
                        if (tempFile != null && tempFile.exists()) {
                            tempFile.delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                        }
                        if (intermediateTempFolder != null && intermediateTempFolder.exists()) {
                            intermediateTempFolder.delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                        }
                    }
                    catch (CoreException e2) {
                        Activator.getDefault().logError(e2.getMessage(), e2);
                    }
                }
            }
            finally {
                if (intermediateFile != null && intermediateFile.exists()) {
                    intermediateFile.delete();
                }
                try {
                    if (tempFile != null && tempFile.exists()) {
                        tempFile.delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                    }
                    if (intermediateTempFolder != null && intermediateTempFolder.exists()) {
                        intermediateTempFolder.delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                    }
                }
                catch (CoreException e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                }
            }
        }
    }

    private static void copy(InputStream in, File intermediateFile, long length, SubMonitor monitor) throws IOException, FileNotFoundException {
        Throwable throwable = null;
        Object var6_6 = null;
        try (FileOutputStream out = new FileOutputStream(intermediateFile);){
            int n;
            monitor.setWorkRemaining((int)(length / 1024L));
            byte[] buf = new byte[16384];
            int counter = 0;
            while ((n = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, n);
                counter = counter % 1024 + n;
                monitor.worked(counter / 1024);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void setStatus(IStatus status) {
        this.fStatus = status;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public List<IResource> getImportedResources() {
        return this.fImportedResources;
    }
}

