/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters;

public class TimeQueryFilter {
    private final long[] fTimesRequested;

    public TimeQueryFilter(long start, long end, int n) {
        this.fTimesRequested = TimeQueryFilter.splitRangeIntoEqualParts(start, end, n);
    }

    public long[] getTimesRequested() {
        return this.fTimesRequested;
    }

    public long getStart() {
        return this.fTimesRequested[0];
    }

    public long getEnd() {
        return this.fTimesRequested[Integer.max(0, this.fTimesRequested.length - 1)];
    }

    private static final long[] splitRangeIntoEqualParts(long start, long end, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of entries must be greater than 0");
        }
        if (n == 1) {
            if (start == end) {
                long[] result = new long[]{start};
                return result;
            }
            throw new IllegalArgumentException("Number of entries requested is 1, but start and end are different. Impossible to create array.");
        }
        long delta = end - start;
        if (delta < 0L) {
            throw new IllegalArgumentException("End value must be greater or equal to start value");
        }
        double stepSize = (double)delta / ((double)n - 1.0);
        long[] result = new long[n];
        result[0] = start;
        double curTime = (double)start + stepSize;
        int i = 1;
        while (i < n) {
            result[i] = Math.round(curTime);
            curTime += stepSize;
            ++i;
        }
        result[result.length - 1] = end;
        return result;
    }
}

