/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.refactor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;

public class MoveResourceOperation
extends AbstractActionOperation {
    protected IResource source;
    protected IResource destination;

    public MoveResourceOperation(IResource source, IResource destination) {
        super("Operation_MoveLocal", SVNMessages.class);
        this.source = source;
        this.destination = destination;
    }

    public ISchedulingRule getSchedulingRule() {
        return MultiRule.combine((ISchedulingRule)(this.source instanceof IProject ? this.source : this.source.getParent()), (ISchedulingRule)(this.destination instanceof IProject ? this.destination : this.destination.getParent()));
    }

    public boolean isAllowed() {
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        String locationSourceUrl = storage.getRepositoryLocation(this.source).getRepositoryRootUrl();
        String locationDestinationUrl = storage.getRepositoryLocation(this.destination).getRepositoryRootUrl();
        return locationSourceUrl.equals(locationDestinationUrl);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        IRepositoryLocation location = storage.getRepositoryLocation(this.source);
        ISVNConnector proxy = location.acquireSVNProxy();
        String srcPath = FileUtility.getWorkingCopyPath(this.source);
        String dstPath = FileUtility.getWorkingCopyPath(this.destination);
        try {
            this.writeToConsole(0, "svn move \"" + FileUtility.normalizePath(srcPath) + "\" \"" + FileUtility.normalizePath(dstPath) + "\"" + ISVNConnector.Options.asCommandLine(0x10000004L) + " \n");
            proxy.moveLocal(new String[]{srcPath}, dstPath, 0x10000004L, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{this.source.getName(), this.destination.getParent().getFullPath().toString()});
    }
}

