/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core;

import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.svn.core.FileReplaceListener;
import org.eclipse.team.svn.core.ProjectCloseListener;
import org.eclipse.team.svn.core.ResourceChangeListener;
import org.eclipse.team.svn.core.SVNFolderListener;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.extension.crashrecovery.DefaultErrorHandlingFacility;
import org.eclipse.team.svn.core.extension.crashrecovery.IErrorHandlingFacility;
import org.eclipse.team.svn.core.extension.options.IOptionProvider;
import org.eclipse.team.svn.core.mapping.SVNActiveChangeSetCollector;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.synchronize.UpdateSubscriber;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.util.tracker.ServiceTracker;

public class SVNTeamPlugin
extends Plugin {
    public static final String NATURE_ID = "org.eclipse.team.svn.core.svnnature";
    public static final String CORE_SVNCLIENT_NAME = "svnconnector";
    private static volatile SVNTeamPlugin instance = null;
    private ProjectCloseListener pcListener;
    private ResourceChangeListener rcListener;
    private SVNFolderListener svnListener;
    private ServiceTracker tracker;
    private FileReplaceListener fileReplaceListener;
    private IErrorHandlingFacility errorHandlingFacility;
    private boolean isLocationsDirty;
    private ActiveChangeSetManager activeChangeSetManager;

    public SVNTeamPlugin() {
        instance = this;
        this.pcListener = new ProjectCloseListener();
        this.rcListener = new ResourceChangeListener();
        this.svnListener = new SVNFolderListener();
        this.fileReplaceListener = new FileReplaceListener();
        this.errorHandlingFacility = new DefaultErrorHandlingFacility();
    }

    public File getTemporaryFile(File parent, String fileName) {
        File retVal = parent == null ? this.getStateLocation().append(".tmp" + System.currentTimeMillis()).append(fileName).toFile() : new File(parent, fileName);
        retVal.deleteOnExit();
        parent = retVal.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
            parent.deleteOnExit();
        }
        return retVal;
    }

    public void setLocationsDirty(boolean isLocationsDirty) {
        this.isLocationsDirty = isLocationsDirty;
    }

    public boolean isLocationsDirty() {
        return this.isLocationsDirty;
    }

    public static SVNTeamPlugin instance() {
        return instance;
    }

    public IOptionProvider getOptionProvider() {
        return CoreExtensionsManager.instance().getOptionProvider();
    }

    public IErrorHandlingFacility getErrorHandlingFacility() {
        return this.errorHandlingFacility;
    }

    public void setOptionProvider(IOptionProvider optionProvider) {
        CoreExtensionsManager.instance().setOptionProvider(optionProvider == null ? IOptionProvider.DEFAULT : optionProvider);
        SVNRemoteStorage.instance().reconfigureLocations();
        ProgressMonitorUtility.doTaskScheduledDefault(new AbstractActionOperation("Remove Temporary Files", SVNMessages.class){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                SVNTeamPlugin.instance().getStateLocation().toFile().listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        String name = pathname.getName();
                        if (!name.equals(".svnRepositories") && !name.equals(".externalSVNRepositories")) {
                            FileUtility.deleteRecursive(pathname);
                        }
                        return false;
                    }
                });
            }
        });
    }

    public IEclipsePreferences getPreferences() {
        return new InstanceScope().getNode(this.getBundle().getSymbolicName());
    }

    public void savePreferences() {
        try {
            SVNTeamPlugin.instance().getPreferences().flush();
        }
        catch (BackingStoreException ex) {
            LoggedOperation.reportError(SVNMessages.getErrorString("Error_SavePreferences"), ex);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.tracker = new ServiceTracker(context, IProxyService.class.getName(), null);
        this.tracker.open();
        HashMap<String, Object> preferences = new HashMap<String, Object>();
        preferences.put("stateInfoLocation", this.getStateLocation());
        SVNFileStorage.instance().initialize(preferences);
        SVNRemoteStorage.instance().initialize(preferences);
        WorkspaceJob job = new WorkspaceJob(""){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                workspace.addResourceChangeListener((IResourceChangeListener)SVNTeamPlugin.this.rcListener, 1);
                workspace.addResourceChangeListener((IResourceChangeListener)SVNTeamPlugin.this.svnListener, 8);
                workspace.addResourceChangeListener((IResourceChangeListener)SVNTeamPlugin.this.pcListener, 6);
                workspace.addResourceChangeListener((IResourceChangeListener)SVNTeamPlugin.this.fileReplaceListener, 8);
                try {
                    SVNTeamPlugin.this.rcListener.handleInitialWorkspaceDelta();
                }
                catch (Throwable ex) {
                    LoggedOperation.reportError("Handle Initial Workspace Delta", ex);
                }
                IProject[] projects = workspace.getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    RepositoryProvider.getProvider((IProject)projects[i]);
                    ++i;
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        job.setUser(false);
        job.schedule();
    }

    public IProxyService getProxyService() {
        return (IProxyService)this.tracker.getService();
    }

    public void stop(BundleContext context) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.svnListener);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.rcListener);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.pcListener);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.fileReplaceListener);
        if (this.isLocationsDirty) {
            SVNRemoteStorage.instance().saveConfiguration();
            SVNFileStorage.instance().saveConfiguration();
        }
        SVNRemoteStorage.instance().dispose();
        SVNFileStorage.instance().dispose();
        this.tracker.close();
        File temporaryFilesStorage = SVNTeamPlugin.instance().getStateLocation().toFile();
        File[] files = temporaryFilesStorage.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().indexOf(".tmp") != -1;
            }
        });
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                FileUtility.deleteRecursive(files[i]);
                ++i;
            }
        }
        if (this.activeChangeSetManager != null) {
            this.activeChangeSetManager.dispose();
        }
        super.stop(context);
    }

    public synchronized ActiveChangeSetManager getModelChangeSetManager() {
        if (this.activeChangeSetManager == null) {
            this.activeChangeSetManager = new SVNActiveChangeSetCollector(UpdateSubscriber.instance());
        }
        return this.activeChangeSetManager;
    }
}

