/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.internal.channelmanager.steps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.tcf.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.core.events.ChannelEvent;
import org.eclipse.tcf.te.tcf.core.steps.AbstractPeerStep;

public class InitializeLoggingStep
extends AbstractPeerStep {
    public void validateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)fullQualifiedId);
        Assert.isNotNull((Object)monitor);
        IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (channel == null) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "Channel to target not available."));
        }
    }

    public void execute(IStepContext context, final IPropertiesContainer data, final IFullQualifiedId fullQualifiedId, IProgressMonitor monitor, final ICallback callback) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)fullQualifiedId);
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)callback);
        final IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        Assert.isNotNull((Object)channel);
        final String logname = StepperAttributeUtil.getStringProperty((String)"org.eclipse.tcf.te.tcf.locator.logname", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (channel.getState() == 1) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    String message;
                    ArrayList remoteServices = new ArrayList(channel.getRemoteServices());
                    Collections.sort(remoteServices);
                    String buffer = ((Object)remoteServices).toString();
                    buffer = buffer.replaceAll("\\[", "").replaceAll("\\]", "");
                    PropertiesContainer eventData = new PropertiesContainer();
                    eventData.setProperty("message", (Object)buffer.toString());
                    eventData.setProperty("logname", (Object)logname);
                    ChannelEvent event = new ChannelEvent((Object)InitializeLoggingStep.this, channel, "services", (IPropertiesContainer)eventData);
                    EventManager.getInstance().fireEvent((EventObject)event);
                    boolean forceNew = StepperAttributeUtil.getBooleanProperty((String)"channel.forceNew", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
                    boolean noValueAdd = StepperAttributeUtil.getBooleanProperty((String)"channel.noValueAdd", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
                    boolean noPathMap = StepperAttributeUtil.getBooleanProperty((String)"channel.noPathMap", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
                    String string = message = forceNew ? "Private" : "Shared";
                    if (noValueAdd) {
                        message = String.valueOf(message) + ", No Value Add";
                    }
                    if (noPathMap) {
                        message = String.valueOf(message) + ", Not Applying Path Map";
                    }
                    eventData = new PropertiesContainer();
                    eventData.setProperty("message", (Object)message);
                    eventData.setProperty("logname", (Object)logname);
                    event = new ChannelEvent((Object)InitializeLoggingStep.this, channel, "open", (IPropertiesContainer)eventData);
                    EventManager.getInstance().fireEvent((EventObject)event);
                    InitializeLoggingStep.this.callback(data, fullQualifiedId, callback, Status.OK_STATUS, null);
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeLater((Runnable)runnable);
            }
        } else {
            this.callback(data, fullQualifiedId, callback, Status.OK_STATUS, null);
        }
    }
}

