/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.names;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MapMaker;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.IPackageName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.names.VmPackageName;

public class VmTypeName
implements ITypeName {
    private static Map<String, VmTypeName> index = new MapMaker().weakValues().makeMap();
    private static final Pattern GENERICS_PATTERN = Pattern.compile("<[^<>]*>");
    public static final VmTypeName OBJECT = VmTypeName.get("Ljava/lang/Object");
    public static final VmTypeName JAVA_LANG_NULL_POINTER_EXCEPTION = VmTypeName.get("Ljava/lang/NullPointerException");
    public static final VmTypeName JAVA_LANG_STRING = VmTypeName.get("Ljava/lang/String");
    public static final VmTypeName JAVA_LANG_EXCEPTION_IN_INITIALIZER_ERROR = VmTypeName.get("Ljava/lang/ExceptionInInitializerError");
    public static final VmTypeName STRING = VmTypeName.get("Ljava/lang/String");
    public static final VmTypeName NULL = VmTypeName.get("Lnull");
    public static final VmTypeName BYTE = VmTypeName.get("B");
    public static final VmTypeName BOOLEAN = VmTypeName.get("Z");
    public static final VmTypeName CHAR = VmTypeName.get("C");
    public static final VmTypeName DOUBLE = VmTypeName.get("D");
    public static final VmTypeName FLOAT = VmTypeName.get("F");
    public static final VmTypeName INT = VmTypeName.get("I");
    public static final VmTypeName LONG = VmTypeName.get("J");
    public static final VmTypeName SHORT = VmTypeName.get("S");
    public static final VmTypeName VOID = VmTypeName.get("V");
    private String identifier;

    public static synchronized VmTypeName get(String typeName) {
        VmTypeName res = index.get(typeName = VmTypeName.removeGenerics(typeName));
        if (res == null) {
            res = new VmTypeName(typeName);
            index.put(typeName, res);
        }
        return res;
    }

    private static String removeGenerics(String typeName) {
        int oldLength;
        Matcher matcher;
        do {
            oldLength = typeName.length();
        } while ((typeName = (matcher = GENERICS_PATTERN.matcher(typeName)).replaceAll("")).length() < oldLength);
        return typeName;
    }

    @VisibleForTesting
    protected VmTypeName(String vmTypeName) {
        Checks.ensureIsNotNull(vmTypeName);
        Checks.ensureIsFalse(vmTypeName.length() == 0, "empty size for type name not permitted", new Object[0]);
        int i = 0;
        block4: while (i < vmTypeName.length()) {
            switch (vmTypeName.charAt(i)) {
                case '[': {
                    break;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'L': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    break block4;
                }
                default: {
                    Throws.throwUnreachable("Invalid type name: " + vmTypeName, new Object[0]);
                }
            }
            ++i;
        }
        for (int off = 0; off < vmTypeName.length(); ++off) {
            char c = vmTypeName.charAt(off);
            if (c == '-' || c == '[' || c == '/' || c == '<' || c == '>' || Character.isJavaIdentifierPart(c)) {
                continue;
            }
            Throws.throwIllegalArgumentException("Cannot parse '%s' as vm type name.", vmTypeName);
            break;
        }
        this.identifier = vmTypeName;
    }

    @Override
    public ITypeName getArrayBaseType() {
        Checks.ensureIsTrue(this.isArrayType(), "only array-types have a base type!", new Object[0]);
        int start = 0;
        while (this.identifier.charAt(++start) == '[') {
        }
        return VmTypeName.get(this.identifier.substring(start));
    }

    @Override
    public int getArrayDimensions() {
        int count = 0;
        int start = 0;
        while (this.identifier.charAt(start++) == '[') {
            ++count;
        }
        return count;
    }

    @Override
    public String getClassName() {
        int indexOf = this.identifier.lastIndexOf(47);
        if (indexOf < 0 && !this.isPrimitiveType()) {
            return this.identifier.substring(1);
        }
        return this.identifier.substring(indexOf + 1);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public IPackageName getPackage() {
        int lastSlash = this.identifier.lastIndexOf(47);
        if (lastSlash == -1 || this.identifier.charAt(0) == '[') {
            return VmPackageName.DEFAULT_PACKAGE;
        }
        return VmPackageName.get(this.identifier.substring(1, lastSlash));
    }

    @Override
    public boolean isAnonymousType() {
        return this.identifier.matches(".*\\$\\d+");
    }

    @Override
    public boolean isArrayType() {
        return this.identifier.charAt(0) == '[';
    }

    @Override
    public boolean isDeclaredType() {
        return this.identifier.charAt(0) == 'L';
    }

    @Override
    public boolean isNestedType() {
        return this.identifier.contains("$");
    }

    @Override
    public boolean isPrimitiveType() {
        return !this.isArrayType() && !this.isDeclaredType();
    }

    @Override
    public boolean isVoid() {
        return this == VOID;
    }

    @Override
    public int compareTo(ITypeName o) {
        return this.getIdentifier().compareTo(o.getIdentifier());
    }

    @Override
    public String toString() {
        return this.getIdentifier();
    }

    @Override
    public IMethodName getDeclaringMethod() {
        Checks.ensureIsTrue(this.isNestedType(), "only valid on nested types", new Object[0]);
        int lastPathSegmentSeparator = this.identifier.lastIndexOf(47);
        String path = this.identifier.substring(0, lastPathSegmentSeparator);
        int bracket = path.lastIndexOf(40);
        int methodSeparator = path.lastIndexOf(47, bracket);
        String newFQName = String.valueOf(path.substring(0, methodSeparator)) + "." + path.substring(methodSeparator + 1);
        return VmMethodName.get(newFQName);
    }

    @Override
    public ITypeName getDeclaringType() {
        Checks.ensureIsTrue(this.isNestedType(), "only valid on nested types", new Object[0]);
        int lastIndexOf = this.identifier.lastIndexOf(36);
        String declaringTypeName = this.identifier.substring(0, lastIndexOf);
        return VmTypeName.get(declaringTypeName);
    }
}

