/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;

public class DependencyExtractor {
    private final Set<ProjectCoordinate> dependencies = new HashSet<ProjectCoordinate>();
    private final ASTNode enclosingNode;
    private final IProjectCoordinateProvider pcProvider;
    private final Selection selection;

    public DependencyExtractor(ASTNode node, IProjectCoordinateProvider pcProvider) {
        this.enclosingNode = node;
        this.pcProvider = pcProvider;
        this.selection = Selection.createFromStartLength((int)node.getStartPosition(), (int)node.getLength());
    }

    public DependencyExtractor(CompilationUnit ast, ITextSelection textSelection, IProjectCoordinateProvider pcProvider) {
        this.enclosingNode = NodeFinder.perform((ASTNode)ast, (int)textSelection.getOffset(), (int)textSelection.getLength());
        this.pcProvider = pcProvider;
        this.selection = Selection.createFromStartLength((int)textSelection.getOffset(), (int)textSelection.getLength());
    }

    public Set<ProjectCoordinate> extractDependencies() {
        this.enclosingNode.accept(new ASTVisitor(){

            public boolean visit(SimpleName simpleName) {
                if (DependencyExtractor.this.selection.covers((ASTNode)simpleName)) {
                    IBinding binding = simpleName.resolveBinding();
                    if (binding == null) {
                        return super.visit(simpleName);
                    }
                    switch (binding.getKind()) {
                        case 2: {
                            this.processVariableBinding((ITypeBinding)binding);
                            break;
                        }
                        case 3: {
                            this.processVariableBinding((IVariableBinding)binding);
                        }
                    }
                }
                return super.visit(simpleName);
            }

            private void processVariableBinding(ITypeBinding binding) {
                if (binding == null) {
                    return;
                }
                ProjectCoordinate pc = (ProjectCoordinate)DependencyExtractor.this.pcProvider.resolve(binding).orNull();
                if (pc == null) {
                    return;
                }
                DependencyExtractor.this.dependencies.add(new ProjectCoordinate(pc.getGroupId(), pc.getArtifactId(), "0.0.0"));
            }

            private void processVariableBinding(IVariableBinding binding) {
                if (binding == null) {
                    return;
                }
                this.processVariableBinding(binding.getType());
            }
        });
        return this.dependencies;
    }
}

