/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.calls.rcp;

import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public class ProposalMatcher {
    private final String proposedName;
    private final ITypeName[] proposedParameterTypes;

    public ProposalMatcher(IMethodName proposedMethod) {
        this.proposedName = proposedMethod.getName();
        this.proposedParameterTypes = proposedMethod.getParameterTypes();
    }

    public boolean match(IMethodName candidate) {
        if (candidate == null) {
            return false;
        }
        String candidateName = candidate.getName();
        if (!candidateName.equals(this.proposedName)) {
            return false;
        }
        ITypeName[] candidateParameterTypes = candidate.getParameterTypes();
        if (this.proposedParameterTypes == null || candidateParameterTypes.length != this.proposedParameterTypes.length) {
            return false;
        }
        int i = candidateParameterTypes.length;
        while (i-- > 0) {
            if (candidateParameterTypes[i].equals(this.proposedParameterTypes[i])) continue;
            return false;
        }
        return true;
    }
}

