/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.markdown.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.markdown.internal.block.NestableBlock;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

public class CodeBlock
extends NestableBlock {
    private static final Pattern INDENTED_BLOCK = Pattern.compile("(?: {4}|\\t)((?: {4}|\\t)*)(.*)");
    private static final Pattern FENCED_BLOCK_START = Pattern.compile(" {0,3}(?:```+|~~~+)\\s*(.*)");
    private static final Pattern FENCED_BLOCK = Pattern.compile("((?: {4}|\\t)*)(.*)");
    private static final Pattern FENCED_BLOCK_END = Pattern.compile(" {0,3}(?:```+|~~~+)");
    private boolean fencedBlock = false;
    private int blockLineCount = 0;

    public boolean canStart(String line, int lineOffset) {
        if (FENCED_BLOCK_START.matcher(line.substring(lineOffset)).matches()) {
            this.fencedBlock = true;
            return true;
        }
        this.fencedBlock = false;
        return INDENTED_BLOCK.matcher(line.substring(lineOffset)).matches();
    }

    protected int processLineContent(String line, int offset) {
        Matcher matcher;
        if (this.blockLineCount == 0) {
            this.builder.beginBlock(DocumentBuilder.BlockType.CODE, new Attributes());
            if (this.fencedBlock) {
                ++this.blockLineCount;
                return -1;
            }
        }
        Matcher matcher2 = matcher = this.fencedBlock ? FENCED_BLOCK.matcher(line.substring(offset)) : INDENTED_BLOCK.matcher(line.substring(offset));
        if (this.fencedBlock ? FENCED_BLOCK_END.matcher(line.substring(offset)).matches() || !matcher.matches() : !matcher.matches()) {
            this.setClosed(true);
            return this.fencedBlock ? -1 : offset;
        }
        if (this.fencedBlock ? this.blockLineCount > 1 : this.blockLineCount > 0) {
            this.builder.characters("\n");
        }
        String indent = matcher.group(1);
        String content = matcher.group(2);
        if (indent != null) {
            this.builder.characters(indent.replace("\t", "    "));
        }
        this.builder.characters(content);
        ++this.blockLineCount;
        return -1;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

