/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;
import org.eclipse.lsp4e.operations.completion.LSIncompleteCompletionProposal;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.xbase.lib.Pair;

public class LSContentAssistProcessor
implements IContentAssistProcessor {
    private static final long TRIGGERS_TIMEOUT = 50L;
    private static final long COMPLETION_TIMEOUT = 1000L;
    private List<LanguageServiceAccessor.LSPDocumentInfo> infos;
    private char[] triggerChars;
    private char[] contextTriggerChars;
    private Pair<IDocument, Job> findInfoJob;
    private String errorMessage;
    private boolean isIncomplete = true;
    private Comparator<LSCompletionProposal> proposalConparoator = (o1, o2) -> {
        if (o1.getBestOffset() < o2.getBestOffset()) {
            return -1;
        }
        if (o1.getBestOffset() > o2.getBestOffset()) {
            return 1;
        }
        if (o1.getNumberOfModifsBeforeOffset() < o2.getNumberOfModifsBeforeOffset()) {
            return -1;
        }
        if (o1.getNumberOfModifsBeforeOffset() > o2.getNumberOfModifsBeforeOffset()) {
            return 1;
        }
        String c1 = o1.getSortText();
        String c2 = o2.getSortText();
        if (c1 == null) {
            return -1;
        }
        return c1.compareToIgnoreCase(c2);
    };

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        this.checkInfoAndJob(viewer.getDocument());
        if (this.infos == null) {
            try {
                ((Job)this.findInfoJob.getValue()).join(1000L, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        if (this.infos == null || this.infos.isEmpty()) {
            return new ICompletionProposal[0];
        }
        ArrayList<LSCompletionProposal> proposals = new ArrayList<LSCompletionProposal>();
        try {
            TextDocumentPositionParams param = LSPEclipseUtils.toTextDocumentPosistionParams(this.infos.get(0).getFileUri(), offset, viewer.getDocument());
            List<LSCompletionProposal> lsProposals = Collections.synchronizedList(new ArrayList());
            Stream<CompletableFuture> requests = this.infos.stream().map(info -> info.getLanguageClient().getTextDocumentService().completion(param).thenAccept(items -> {
                boolean bl = lsProposals.addAll(this.toProposals(offset, (Either<List<CompletionItem>, CompletionList>)items, (LanguageServiceAccessor.LSPDocumentInfo)info));
            }));
            requests.forEach(future -> {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException ex) {
                    LanguageServerPlugin.logError(ex);
                    this.errorMessage = ex.getMessage();
                }
            });
            if (!this.isIncomplete) {
                List<LSCompletionProposal> CompletionProposal2 = lsProposals;
                CompletionProposal2.sort(this.proposalConparoator);
                proposals.addAll(CompletionProposal2);
            } else {
                proposals.addAll(lsProposals);
            }
        }
        catch (Exception ex) {
            LanguageServerPlugin.logError(ex);
            this.errorMessage = ex.getMessage();
            proposals.add(0, (LSCompletionProposal)this.createErrorProposal(offset, ex));
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private CompletionProposal createErrorProposal(int offset, Exception ex) {
        return new CompletionProposal("", offset, 0, offset, null, Messages.completionError, null, ex.getMessage());
    }

    private void checkInfoAndJob(@NonNull IDocument refDocument) {
        if (this.infos != null && !this.infos.isEmpty() && refDocument.equals(this.infos.get(0).getDocument())) {
            if (this.findInfoJob != null) {
                ((Job)this.findInfoJob.getValue()).cancel();
                this.findInfoJob = null;
            }
            this.infos = null;
        }
        if (this.infos == null && this.findInfoJob == null) {
            this.createInfoJob(refDocument);
        }
    }

    private List<ICompletionProposal> toProposals(int offset, Either<List<CompletionItem>, CompletionList> completionList, LanguageServiceAccessor.LSPDocumentInfo info) {
        if (completionList == null) {
            return Collections.emptyList();
        }
        List items = Collections.emptyList();
        if (completionList.isLeft()) {
            items = (List)completionList.getLeft();
        } else if (completionList.isRight()) {
            this.isIncomplete = ((CompletionList)completionList.getRight()).isIncomplete();
            items = ((CompletionList)completionList.getRight()).getItems();
        }
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (CompletionItem item : items) {
            LSIncompleteCompletionProposal proposal;
            if (item == null) continue;
            if (this.isIncomplete) {
                proposal = new LSIncompleteCompletionProposal(item, offset, info);
                proposals.add(proposal);
                continue;
            }
            proposal = new LSCompletionProposal(item, offset, info);
            if (!((LSCompletionProposal)proposal).validate(info.getDocument(), offset, null)) continue;
            proposals.add(proposal);
        }
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        this.checkInfoAndJob(viewer.getDocument());
        if (this.infos == null) {
            try {
                ((Job)this.findInfoJob.getValue()).join(1000L, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        if (this.infos == null || this.infos.isEmpty()) {
            return new IContextInformation[0];
        }
        List contextInformations = Collections.synchronizedList(new ArrayList());
        try {
            TextDocumentPositionParams param = LSPEclipseUtils.toTextDocumentPosistionParams(this.infos.get(0).getFileUri(), offset, viewer.getDocument());
            Stream<CompletableFuture> requests = this.infos.stream().map(info -> info.getLanguageClient().getTextDocumentService().signatureHelp(param).thenAccept(signatureHelp -> {
                for (SignatureInformation information : signatureHelp.getSignatures()) {
                    StringBuilder signature = new StringBuilder(information.getLabel());
                    if (information.getDocumentation() != null && !information.getDocumentation().isEmpty()) {
                        signature.append('\n').append(information.getDocumentation());
                    }
                    contextInformations.add(new ContextInformation(information.getLabel(), signature.toString()));
                }
            }));
            requests.forEach(future -> {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException ex) {
                    LanguageServerPlugin.logError(ex);
                }
            });
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
        return contextInformations.toArray(new IContextInformation[0]);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        ITextEditor textEditor = LSPEclipseUtils.getActiveTextEditor();
        if (textEditor != null) {
            this.checkInfoAndJob(LSPEclipseUtils.getDocument(textEditor));
            try {
                ((Job)this.findInfoJob.getValue()).join(50L, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException | OperationCanceledException e) {
                LanguageServerPlugin.logError(e);
            }
            return this.triggerChars;
        }
        return this.triggerChars;
    }

    private Set<Character> collectCharacters(@Nullable List<String> triggerCharacters) {
        if (triggerCharacters == null || triggerCharacters.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Character> chars = new HashSet<Character>();
        for (String s : triggerCharacters) {
            if (s.length() != 1) continue;
            chars.add(Character.valueOf(s.charAt(0)));
        }
        return chars;
    }

    private void createInfoJob(final @NonNull IDocument document) {
        Job job = new Job("[Completion] Find Language Servers"){

            protected IStatus run(IProgressMonitor monitor) {
                LSContentAssistProcessor.this.infos = Collections.unmodifiableList(LanguageServiceAccessor.getLSPDocumentInfosFor(document, capabilities -> capabilities.getCompletionProvider() != null));
                HashSet triggerChars = new HashSet();
                HashSet contextTriggerChars = new HashSet();
                if (LSContentAssistProcessor.this.infos != null) {
                    LSContentAssistProcessor.this.infos.forEach(info -> {
                        ServerCapabilities currentCapabilites = info.getCapabilites();
                        if (currentCapabilites != null) {
                            if (currentCapabilites.getCompletionProvider() != null) {
                                triggerChars.addAll(LSContentAssistProcessor.this.collectCharacters(currentCapabilites.getCompletionProvider().getTriggerCharacters()));
                            }
                            if (currentCapabilites.getSignatureHelpProvider() != null) {
                                contextTriggerChars.addAll(LSContentAssistProcessor.this.collectCharacters(currentCapabilites.getSignatureHelpProvider().getTriggerCharacters()));
                            }
                        }
                    });
                }
                LSContentAssistProcessor.this.triggerChars = LSContentAssistProcessor.this.toArray(triggerChars);
                LSContentAssistProcessor.this.contextTriggerChars = LSContentAssistProcessor.this.toArray(contextTriggerChars);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.setUser(false);
        job.schedule();
        this.findInfoJob = new Pair((Object)document, (Object)job);
    }

    public char[] getContextInformationAutoActivationCharacters() {
        ITextEditor textEditor = LSPEclipseUtils.getActiveTextEditor();
        if (textEditor != null) {
            this.checkInfoAndJob(LSPEclipseUtils.getDocument(textEditor));
            try {
                ((Job)this.findInfoJob.getValue()).join(50L, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException | OperationCanceledException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return this.contextTriggerChars;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new ContextInformationValidator((IContentAssistProcessor)this);
    }

    private char[] toArray(Collection<Character> items) {
        char[] res = new char[items.size()];
        int i = 0;
        for (Character item : items) {
            res[i] = item.charValue();
            ++i;
        }
        return res;
    }
}

