/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.model.listener;

import java.lang.reflect.Method;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.listener.ReflectiveChangeListener;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;

class SingleMethodReflectiveChangeListener
extends ReflectiveChangeListener
implements StateChangeListener,
PropertyChangeListener {
    private final Method method;
    private final boolean methodIsZeroArgument;

    SingleMethodReflectiveChangeListener(Object target, Method method) {
        super(target);
        this.method = method;
        this.methodIsZeroArgument = method.getParameterTypes().length == 0;
    }

    @Override
    public void stateChanged(StateChangeEvent event) {
        if (this.methodIsZeroArgument) {
            ObjectTools.execute(this.target, this.method, ObjectTools.EMPTY_OBJECT_ARRAY);
        } else {
            ObjectTools.execute(this.target, this.method, new StateChangeEvent[]{event});
        }
    }

    @Override
    public void propertyChanged(PropertyChangeEvent event) {
        if (this.methodIsZeroArgument) {
            ObjectTools.execute(this.target, this.method, ObjectTools.EMPTY_OBJECT_ARRAY);
        } else {
            ObjectTools.execute(this.target, this.method, new PropertyChangeEvent[]{event});
        }
    }
}

