/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.AccessRulesDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ModuleEncapsulationDetail;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.RootCPListElement;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ProjectsWorkbookPage
extends BuildPathBasePage {
    private final int IDX_ADDPROJECT = 0;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;
    private final ListDialogField<CPListElement> fClassPathList;
    private IJavaProject fCurrJProject;
    private final TreeListDialogField<CPListElement> fProjectsList;
    private Control fSWTControl;
    private final IWorkbenchPreferenceContainer fPageContainer;

    public ProjectsWorkbookPage(ListDialogField<CPListElement> classPathList, IWorkbenchPreferenceContainer pageContainer) {
        this.fClassPathList = classPathList;
        this.fPageContainer = pageContainer;
        this.fSWTControl = null;
        String[] stringArray = new String[4];
        stringArray[0] = NewWizardMessages.ProjectsWorkbookPage_projects_add_button;
        stringArray[2] = NewWizardMessages.ProjectsWorkbookPage_projects_edit_button;
        stringArray[3] = NewWizardMessages.ProjectsWorkbookPage_projects_remove_button;
        String[] buttonLabels = stringArray;
        ProjectsAdapter adapter = new ProjectsAdapter();
        this.fProjectsList = new TreeListDialogField<CPListElement>(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fProjectsList.setDialogFieldListener(adapter);
        this.fProjectsList.setLabelText(NewWizardMessages.ProjectsWorkbookPage_projects_label);
        this.fProjectsList.enableButton(3, false);
        this.fProjectsList.enableButton(2, false);
        this.fProjectsList.setViewerComparator(new CPListElementSorter());
    }

    @Override
    public void init(IJavaProject jproject) {
        this.fCurrJProject = jproject;
        if (Display.getCurrent() != null) {
            this.updateProjectsList();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProjectsWorkbookPage.this.updateProjectsList();
                }
            });
        }
    }

    private void updateProjectsList() {
        if (JavaModelUtil.is9OrHigher((IJavaProject)this.fCurrJProject)) {
            this.updateProjectsListWithRootNode();
            return;
        }
        List<CPListElement> cpelements = this.fClassPathList.getElements();
        ArrayList<CPListElement> checkedProjects = new ArrayList<CPListElement>(cpelements.size());
        int i = cpelements.size() - 1;
        while (i >= 0) {
            CPListElement cpelem = cpelements.get(i);
            if (this.isEntryKind(cpelem.getEntryKind())) {
                checkedProjects.add(cpelem);
            }
            --i;
        }
        this.fProjectsList.setElements(checkedProjects);
    }

    boolean hasRootNodes() {
        if (this.fProjectsList == null) {
            return false;
        }
        if (this.fProjectsList.getSize() == 0) {
            return false;
        }
        return this.fProjectsList.getElement(0).isRootNodeForPath();
    }

    private void updateProjectsListWithRootNode() {
        RootCPListElement rootClasspath = new RootCPListElement(this.fCurrJProject, NewWizardMessages.PathRootWorkbookPage_classpath, false);
        RootCPListElement rootModulepath = new RootCPListElement(this.fCurrJProject, NewWizardMessages.PathRootWorkbookPage_modulepath, true);
        List<CPListElement> cpelements = this.fClassPathList.getElements();
        ArrayList<RootCPListElement> checkedProjects = new ArrayList<RootCPListElement>(cpelements.size());
        int i = cpelements.size() - 1;
        while (i >= 0) {
            CPListElement cpelem = cpelements.get(i);
            if (this.isEntryKind(cpelem.getEntryKind())) {
                Object mod = cpelem.getAttribute("module");
                if (mod == null) {
                    rootClasspath.addCPListElement(cpelem);
                } else {
                    rootModulepath.addCPListElement(cpelem);
                }
            }
            --i;
        }
        checkedProjects.add(rootModulepath);
        checkedProjects.add(rootClasspath);
        this.fProjectsList.setElements(checkedProjects);
        this.fProjectsList.enableButton(0, false);
    }

    @Override
    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fProjectsList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fProjectsList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fProjectsList.setButtonsMinWidth(buttonBarWidth);
        this.fSWTControl = composite;
        return composite;
    }

    private void updateClasspathList() {
        List<CPListElement> projelements = this.fProjectsList.getElements();
        ArrayList<CPListElement> flattenedProjElements = new ArrayList<CPListElement>();
        int i = 0;
        while (i < projelements.size()) {
            CPListElement ele = projelements.get(i);
            if (ele.isRootNodeForPath()) {
                ArrayList<Object> children = ((RootCPListElement)ele).getChildren();
                for (Object object : children) {
                    if (!(object instanceof CPListElement)) continue;
                    flattenedProjElements.add((CPListElement)object);
                }
            } else {
                flattenedProjElements.add(ele);
            }
            ++i;
        }
        boolean remove = false;
        List<CPListElement> cpelements = this.fClassPathList.getElements();
        int i2 = cpelements.size() - 1;
        while (i2 >= 0) {
            CPListElement cpe = cpelements.get(i2);
            if (this.isEntryKind(cpe.getEntryKind()) && !flattenedProjElements.remove(cpe)) {
                cpelements.remove(i2);
                remove = true;
            }
            --i2;
        }
        i2 = 0;
        while (i2 < flattenedProjElements.size()) {
            cpelements.add((CPListElement)flattenedProjElements.get(i2));
            ++i2;
        }
        if (remove || flattenedProjElements.size() > 0) {
            this.fClassPathList.setElements(cpelements);
        }
    }

    public List<Object> getSelection() {
        return this.fProjectsList.getSelectedElements();
    }

    @Override
    public void setSelection(List<?> selElements, boolean expand) {
        this.fProjectsList.selectElements((ISelection)new StructuredSelection(selElements));
        if (expand) {
            int i = 0;
            while (i < selElements.size()) {
                this.fProjectsList.expandElement(selElements.get(i), 1);
                ++i;
            }
        }
    }

    @Override
    public boolean isEntryKind(int kind) {
        return kind == 2;
    }

    private void projectPageCustomButtonPressed(DialogField field, int index) {
        Object[] entries = null;
        switch (index) {
            case 0: {
                entries = this.addProjectDialog();
                break;
            }
            case 2: {
                this.editEntry();
                return;
            }
            case 3: {
                this.removeEntry();
                return;
            }
        }
        if (entries != null) {
            int nElementsChosen = entries.length;
            List<CPListElement> cplist = this.fProjectsList.getElements();
            ArrayList<CPListElement> elementsToAdd = new ArrayList<CPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                CPListElement curr = entries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                }
                ++i;
            }
            if (!this.hasRootNodes()) {
                this.fProjectsList.addElements(elementsToAdd);
            } else {
                List<Object> selectedElements = this.fProjectsList.getSelectedElements();
                List<CPListElement> elements = this.fProjectsList.getElements();
                if (selectedElements.size() == 0) {
                    return;
                }
                this.fProjectsList.removeAllElements();
                int i2 = 0;
                while (i2 < selectedElements.size()) {
                    if (((CPListElement)selectedElements.get(i2)).isClassPathRootNode()) {
                        for (CPListElement cpListElement : elementsToAdd) {
                            cpListElement.setAttribute("module", null);
                        }
                    }
                    if (((CPListElement)selectedElements.get(i2)).isModulePathRootNode()) {
                        for (CPListElement cpListElement : elementsToAdd) {
                            Object attribute = cpListElement.getAttribute("module");
                            if (attribute != null) continue;
                            cpListElement.setAttribute("module", new ModuleEncapsulationDetail[0]);
                        }
                    }
                    ((RootCPListElement)selectedElements.get(i2)).addCPListElement(elementsToAdd);
                    ++i2;
                }
                this.fProjectsList.setElements(elements);
                this.fProjectsList.refresh();
                this.fProjectsList.getTreeViewer().expandToLevel(2);
            }
            if (index == 0 && !this.hasRootNodes()) {
                this.fProjectsList.refresh();
            }
            this.fProjectsList.postSetSelection((ISelection)new StructuredSelection(entries));
        }
    }

    private void removeEntry() {
        List<Object> selElements = this.fProjectsList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                if (attrib.isBuiltIn()) {
                    String key = attrib.getKey();
                    IAccessRule[] value = null;
                    if (key.equals("accessrules")) {
                        value = new IAccessRule[]{};
                    }
                    attrib.getParent().setAttribute(key, value);
                } else {
                    this.removeCustomAttribute(attrib);
                }
                selElements.remove(i);
            } else if (elem instanceof ModuleEncapsulationDetail) {
                this.removeEncapsulationDetail((ModuleEncapsulationDetail)elem);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fProjectsList.refresh();
            this.fClassPathList.dialogFieldChanged();
        } else if (this.hasRootNodes()) {
            List<CPListElement> elements = this.fProjectsList.getElements();
            for (CPListElement cpListElement : elements) {
                ((RootCPListElement)cpListElement).getChildren().removeAll(selElements);
            }
            this.fProjectsList.getTreeViewer().remove(selElements.toArray());
            this.fProjectsList.dialogFieldChanged();
        } else {
            this.fProjectsList.removeElements(selElements);
        }
    }

    private boolean canRemove(List<?> selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                if ("module".equals(attrib.getKey())) {
                    return false;
                }
                if (attrib.isNonModifiable()) {
                    return false;
                }
                if (attrib.isBuiltIn() ? ("accessrules".equals(attrib.getKey()) ? ((IAccessRule[])attrib.getValue()).length == 0 : attrib.getValue() == null) : !this.canRemoveCustomAttribute(attrib)) {
                    return false;
                }
            } else {
                if (elem instanceof ModuleEncapsulationDetail) {
                    return true;
                }
                if (elem instanceof CPListElement && ((CPListElement)elem).isRootNodeForPath()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean canEdit(List<?> selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof CPListElement) {
            return false;
        }
        if (elem instanceof CPListElementAttribute) {
            CPListElementAttribute attrib = (CPListElementAttribute)elem;
            if (attrib.isNonModifiable()) {
                return false;
            }
            if (!attrib.isBuiltIn()) {
                return this.canEditCustomAttribute(attrib);
            }
            if (this.hasRootNodes() && attrib.getKey().equals("module")) {
                return true;
            }
            return true;
        }
        return false;
    }

    private void editEntry() {
        List<Object> selElements = this.fProjectsList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (elem instanceof CPListElementAttribute) {
            this.editAttributeEntry((CPListElementAttribute)elem);
        }
    }

    private void editAttributeEntry(CPListElementAttribute elem) {
        String key = elem.getKey();
        boolean needRefresh = false;
        boolean wasModular = false;
        if (key.equals("accessrules")) {
            this.showAccessRestrictionDialog(elem.getParent());
        } else if (key.equals("module")) {
            wasModular = elem.getValue() != null;
            needRefresh = this.showModuleDialog(this.getShell(), elem);
        } else {
            needRefresh = this.editCustomAttribute(this.getShell(), elem);
        }
        if (needRefresh) {
            CPListElement selElement;
            boolean isModular;
            RootCPListElement.RootNodeChange changeDirection;
            if (key.equals("module") && this.hasRootNodes() && (changeDirection = RootCPListElement.RootNodeChange.fromOldAndNew(wasModular, isModular = (selElement = elem.getParent()).getAttribute("module") != null)) != RootCPListElement.RootNodeChange.NoChange) {
                this.moveCPElementAcrossNode(this.fProjectsList, selElement, changeDirection);
            }
            this.fProjectsList.refresh(elem);
            this.fClassPathList.dialogFieldChanged();
            this.fProjectsList.postSetSelection((ISelection)new StructuredSelection((Object)elem));
            if (key.equals("module") && this.hasRootNodes()) {
                this.fProjectsList.postSetSelection((ISelection)new StructuredSelection((Object)elem.getParent()));
            } else {
                this.fProjectsList.postSetSelection((ISelection)new StructuredSelection((Object)elem));
            }
        }
    }

    private void showAccessRestrictionDialog(CPListElement selElement) {
        AccessRulesDialog dialog = new AccessRulesDialog(this.getShell(), selElement, this.fCurrJProject, this.fPageContainer != null);
        int res = dialog.open();
        if (res == 0 || res == 10) {
            selElement.setAttribute("accessrules", dialog.getAccessRules());
            selElement.setAttribute("combineaccessrules", dialog.doCombineAccessRules());
            this.fProjectsList.refresh();
            this.fClassPathList.dialogFieldChanged();
            if (res == 10) {
                dialog.performPageSwitch(this.fPageContainer);
            }
        }
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    private CPListElement[] addProjectDialog() {
        try {
            Object[] selectArr = this.getNotYetRequiredProjects();
            new JavaElementComparator().sort(null, selectArr);
            ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), Arrays.asList(selectArr), (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new JavaUILabelProvider(), NewWizardMessages.ProjectsWorkbookPage_chooseProjects_message);
            dialog.setTitle(NewWizardMessages.ProjectsWorkbookPage_chooseProjects_title);
            dialog.setHelpAvailable(false);
            if (dialog.open() == 0) {
                Object[] result = dialog.getResult();
                CPListElement[] cpElements = new CPListElement[result.length];
                int i = 0;
                while (i < result.length) {
                    IJavaProject curr = (IJavaProject)result[i];
                    CPListElement cpListElement = new CPListElement(this.fCurrJProject, 2, curr.getPath(), curr.getResource());
                    cpListElement.setModuleAttributeIf9OrHigher(this.fCurrJProject);
                    cpElements[i] = cpListElement;
                    ++i;
                }
                return cpElements;
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return null;
    }

    private Object[] getNotYetRequiredProjects() throws JavaModelException {
        ArrayList<IJavaProject> selectable = new ArrayList<IJavaProject>();
        selectable.addAll(Arrays.asList(this.fCurrJProject.getJavaModel().getJavaProjects()));
        selectable.remove(this.fCurrJProject);
        List<CPListElement> elements = this.fProjectsList.getElements();
        int i = 0;
        while (i < elements.size()) {
            CPListElement curr = elements.get(i);
            if (curr.isRootNodeForPath()) {
                ArrayList<Object> children = ((RootCPListElement)curr).getChildren();
                for (Object object : children) {
                    if (!(object instanceof CPListElement)) continue;
                    CPListElement cpe = (CPListElement)object;
                    IJavaProject proj = (IJavaProject)JavaCore.create((IResource)cpe.getResource());
                    selectable.remove(proj);
                }
            }
            IJavaProject proj = (IJavaProject)JavaCore.create((IResource)curr.getResource());
            selectable.remove(proj);
            ++i;
        }
        Object[] selectArr = selectable.toArray();
        return selectArr;
    }

    protected void projectPageDoubleClicked(TreeListDialogField<CPListElement> field) {
        List<Object> selection = this.fProjectsList.getSelectedElements();
        if (this.canEdit(selection)) {
            this.editEntry();
        }
    }

    protected void projectPageKeyPressed(TreeListDialogField<CPListElement> field, KeyEvent event) {
        List<Object> selection;
        if (field == this.fProjectsList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void projectPageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject != null) {
            this.updateClasspathList();
        }
    }

    private void projectPageSelectionChanged(DialogField field) {
        boolean enabled;
        List<Object> selElements = this.fProjectsList.getSelectedElements();
        this.fProjectsList.enableButton(2, this.canEdit(selElements));
        this.fProjectsList.enableButton(3, this.canRemove(selElements));
        try {
            enabled = this.getNotYetRequiredProjects().length > 0;
        }
        catch (JavaModelException javaModelException) {
            enabled = false;
        }
        this.fProjectsList.enableButton(0, enabled);
        if (this.hasRootNodes()) {
            this.fProjectsList.enableButton(0, enabled && this.canAdd(selElements));
        }
    }

    private boolean canAdd(List<Object> selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof CPListElement) {
            return ((CPListElement)elem).isRootNodeForPath();
        }
        return !(elem instanceof CPListElementAttribute);
    }

    @Override
    public void setFocus() {
        this.fProjectsList.setFocus();
    }

    private class ProjectsAdapter
    extends BuildPathBasePage.CPListAdapter {
        private ProjectsAdapter() {
            super(ProjectsWorkbookPage.this);
        }

        @Override
        public void customButtonPressed(TreeListDialogField<CPListElement> field, int index) {
            ProjectsWorkbookPage.this.projectPageCustomButtonPressed(field, index);
        }

        @Override
        public void selectionChanged(TreeListDialogField<CPListElement> field) {
            ProjectsWorkbookPage.this.projectPageSelectionChanged(field);
        }

        @Override
        public void doubleClicked(TreeListDialogField<CPListElement> field) {
            ProjectsWorkbookPage.this.projectPageDoubleClicked(field);
        }

        @Override
        public void keyPressed(TreeListDialogField<CPListElement> field, KeyEvent event) {
            ProjectsWorkbookPage.this.projectPageKeyPressed(field, event);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            ProjectsWorkbookPage.this.projectPageDialogFieldChanged(field);
        }
    }
}

