/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemSeverityTranslator;
import org.eclipse.dltk.compiler.problem.ProblemCollector;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;

class AccumulatingProblemReporter
extends ProblemCollector {
    private final ISourceModule module;
    private final IProblemRequestor problemRequestor;

    public AccumulatingProblemReporter(ISourceModule module, IProblemRequestor problemRequestor) {
        this.module = module;
        this.problemRequestor = problemRequestor;
    }

    private IProblemSeverityTranslator getTranslator() {
        IScriptProject project = this.module.getScriptProject();
        if (!" ".equals(project.getElementName())) {
            IProblemFactory problemFactory = DLTKLanguageManager.getProblemFactory(this.module);
            return problemFactory.createSeverityTranslator(project);
        }
        return IProblemSeverityTranslator.IDENTITY;
    }

    public void reportToRequestor() {
        IProblemSeverityTranslator translator = this.getTranslator();
        this.problemRequestor.beginReporting();
        for (IProblem problem : this.problems) {
            ProblemSeverity severity = problem.getSeverity();
            if (severity != null) {
                ProblemSeverity newSeverity = translator.getSeverity(problem.getID(), severity);
                if (newSeverity == ProblemSeverity.IGNORE) continue;
                if (newSeverity != severity) {
                    problem.setSeverity(newSeverity);
                }
            }
            this.problemRequestor.acceptProblem(problem);
        }
        this.problemRequestor.endReporting();
    }
}

