/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.gcc.core.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.build.gcc.core.GCCToolChain;
import org.eclipse.cdt.build.gcc.core.internal.Activator;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.build.IToolChainProvider;

public class GCCPathToolChainProvider
implements IToolChainProvider {
    private static final String ID = "org.eclipse.cdt.build.gcc.core.gccPathProvider";
    private static final Pattern gppPattern = Pattern.compile("(.*-)?(g\\+\\+|clang\\+\\+)");
    private static final Pattern gccPattern = Pattern.compile("(.*-)?(gcc|clang)");
    private static final Pattern versionPattern = Pattern.compile(".*(gcc|LLVM) version .*");
    private static final Pattern targetPattern = Pattern.compile("Target: (.*)");

    public String getId() {
        return ID;
    }

    public void init(IToolChainManager manager) {
        HashSet<String> names = new HashSet<String>();
        String path = System.getenv("PATH");
        String[] stringArray = path.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block37: {
                String dirStr = stringArray[n2];
                File dir = new File(dirStr);
                if (!dir.isDirectory()) break block37;
                String[] stringArray2 = dir.list();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    block36: {
                        File altCmd;
                        String altFile;
                        String cmd;
                        String file = stringArray2[n4];
                        String prefix = null;
                        boolean hasAltCmd = false;
                        Matcher matcher = gccPattern.matcher(file);
                        if (matcher.matches()) {
                            prefix = matcher.group(1);
                            cmd = matcher.group(2);
                            altFile = String.valueOf(prefix) + (cmd.startsWith("g") ? "g++" : "clang++");
                            altCmd = new File(dir, altFile);
                            hasAltCmd = altCmd.exists() && altCmd.canExecute();
                        } else {
                            matcher = gppPattern.matcher(file);
                            if (matcher.matches()) {
                                prefix = matcher.group(1);
                                cmd = matcher.group(2);
                                altFile = String.valueOf(prefix) + (cmd.startsWith("g") ? "gcc" : "clang");
                                altCmd = new File(dir, altFile);
                                boolean bl = hasAltCmd = altCmd.exists() && altCmd.canExecute();
                            }
                        }
                        if (prefix == null || !hasAltCmd) break block36;
                        String command = String.valueOf(dirStr) + File.separatorChar + file;
                        try {
                            GCCToolChain toolChain;
                            block38: {
                                String name;
                                Process proc = new ProcessBuilder(command, "-v").redirectErrorStream(true).start();
                                String version = null;
                                String target = null;
                                Throwable throwable = null;
                                Object var21_23 = null;
                                try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                                    String line = reader.readLine();
                                    while (line != null) {
                                        Matcher versionMatcher = versionPattern.matcher(line);
                                        if (versionMatcher.matches()) {
                                            version = line.trim();
                                        } else {
                                            Matcher targetMatcher = targetPattern.matcher(line);
                                            if (targetMatcher.matches()) {
                                                target = targetMatcher.group(1);
                                            }
                                        }
                                        line = reader.readLine();
                                    }
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                                if (target == null || version == null || names.contains(name = String.valueOf(target) + " - " + version)) break block36;
                                names.add(name);
                                toolChain = new GCCToolChain(this, target, version, new Path[]{dir.toPath()}, prefix);
                                String[] tuple = target.split("-");
                                if (tuple.length <= 2) break block38;
                                if ("x86_64".equals(tuple[0])) {
                                    toolChain.setProperty("arch", tuple[0]);
                                } else {
                                    toolChain.setProperty("arch", "x86");
                                }
                                switch (tuple[1]) {
                                    case "w64": {
                                        toolChain.setProperty("os", "win32");
                                        break;
                                    }
                                    case "linux": {
                                        toolChain.setProperty("os", "linux");
                                        break;
                                    }
                                    case "apple": {
                                        toolChain.setProperty("os", "macosx");
                                    }
                                }
                            }
                            toolChain.setProperty("package", "system");
                            manager.addToolChain((IToolChain)toolChain);
                        }
                        catch (IOException e) {
                            Activator.log(e);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }
}

