/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.spotify.docker.client.messages.HostConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ContainerConfig {
    @JsonProperty(value="Hostname")
    private String hostname;
    @JsonProperty(value="Domainname")
    private String domainname;
    @JsonProperty(value="User")
    private String user;
    @JsonProperty(value="AttachStdin")
    private Boolean attachStdin;
    @JsonProperty(value="AttachStdout")
    private Boolean attachStdout;
    @JsonProperty(value="AttachStderr")
    private Boolean attachStderr;
    @JsonProperty(value="PortSpecs")
    private ImmutableList<String> portSpecs;
    @JsonProperty(value="ExposedPorts")
    private ImmutableSet<String> exposedPorts;
    @JsonProperty(value="Tty")
    private Boolean tty;
    @JsonProperty(value="OpenStdin")
    private Boolean openStdin;
    @JsonProperty(value="StdinOnce")
    private Boolean stdinOnce;
    @JsonProperty(value="Env")
    private ImmutableList<String> env;
    @JsonProperty(value="Cmd")
    private ImmutableList<String> cmd;
    @JsonProperty(value="Image")
    private String image;
    @JsonProperty(value="Volumes")
    private ImmutableMap<String, Map> volumes;
    @JsonProperty(value="WorkingDir")
    private String workingDir;
    @JsonProperty(value="Entrypoint")
    private ImmutableList<String> entrypoint;
    @JsonProperty(value="NetworkDisabled")
    private Boolean networkDisabled;
    @JsonProperty(value="OnBuild")
    private ImmutableList<String> onBuild;
    @JsonProperty(value="Labels")
    private ImmutableMap<String, String> labels;
    @JsonProperty(value="MacAddress")
    private String macAddress;
    @JsonProperty(value="HostConfig")
    private HostConfig hostConfig;
    @JsonProperty(value="StopSignal")
    private String stopSignal;

    private ContainerConfig() {
    }

    private ContainerConfig(Builder builder) {
        this.hostname = builder.hostname;
        this.domainname = builder.domainname;
        this.user = builder.user;
        this.attachStdin = builder.attachStdin;
        this.attachStdout = builder.attachStdout;
        this.attachStderr = builder.attachStderr;
        this.portSpecs = builder.portSpecs;
        this.exposedPorts = builder.exposedPorts;
        this.tty = builder.tty;
        this.openStdin = builder.openStdin;
        this.stdinOnce = builder.stdinOnce;
        this.env = builder.env;
        this.cmd = builder.cmd;
        this.image = builder.image;
        this.workingDir = builder.workingDir;
        this.entrypoint = builder.entrypoint;
        this.networkDisabled = builder.networkDisabled;
        this.onBuild = builder.onBuild;
        this.labels = builder.labels;
        this.macAddress = builder.macAddress;
        this.hostConfig = builder.hostConfig;
        this.stopSignal = builder.stopSignal;
        if (builder.volumes != null) {
            HashMap volumesToAdd = Maps.newHashMap();
            for (String builderVolume : builder.volumes) {
                volumesToAdd.put(builderVolume, Maps.newHashMap());
            }
            this.volumes = ImmutableMap.copyOf((Map)volumesToAdd);
        }
    }

    public String hostname() {
        return this.hostname;
    }

    public String domainname() {
        return this.domainname;
    }

    public String user() {
        return this.user;
    }

    public Boolean attachStdin() {
        return this.attachStdin;
    }

    public Boolean attachStdout() {
        return this.attachStdout;
    }

    public Boolean attachStderr() {
        return this.attachStderr;
    }

    public List<String> portSpecs() {
        return this.portSpecs;
    }

    public Set<String> exposedPorts() {
        return this.exposedPorts;
    }

    public Boolean tty() {
        return this.tty;
    }

    public Boolean openStdin() {
        return this.openStdin;
    }

    public Boolean stdinOnce() {
        return this.stdinOnce;
    }

    public List<String> env() {
        return this.env;
    }

    public List<String> cmd() {
        return this.cmd;
    }

    public String image() {
        return this.image;
    }

    public Set<String> volumes() {
        return this.volumes.keySet();
    }

    public String workingDir() {
        return this.workingDir;
    }

    public List<String> entrypoint() {
        return this.entrypoint;
    }

    public Boolean networkDisabled() {
        return this.networkDisabled;
    }

    public List<String> onBuild() {
        return this.onBuild;
    }

    public Map<String, String> labels() {
        return this.labels;
    }

    public String macAddress() {
        return this.macAddress;
    }

    public HostConfig hostConfig() {
        return this.hostConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerConfig that = (ContainerConfig)o;
        return Objects.equals(this.hostname, that.hostname) && Objects.equals(this.domainname, that.domainname) && Objects.equals(this.user, that.user) && Objects.equals(this.attachStdin, that.attachStdin) && Objects.equals(this.attachStdout, that.attachStdout) && Objects.equals(this.attachStderr, that.attachStderr) && Objects.equals(this.portSpecs, that.portSpecs) && Objects.equals(this.exposedPorts, that.exposedPorts) && Objects.equals(this.tty, that.tty) && Objects.equals(this.openStdin, that.openStdin) && Objects.equals(this.stdinOnce, that.stdinOnce) && Objects.equals(this.env, that.env) && Objects.equals(this.cmd, that.cmd) && Objects.equals(this.image, that.image) && Objects.equals(this.volumes, that.volumes) && Objects.equals(this.workingDir, that.workingDir) && Objects.equals(this.entrypoint, that.entrypoint) && Objects.equals(this.networkDisabled, that.networkDisabled) && Objects.equals(this.onBuild, that.onBuild) && Objects.equals(this.labels, that.labels) && Objects.equals(this.macAddress, that.macAddress) && Objects.equals(this.hostConfig, that.hostConfig) && Objects.equals(this.stopSignal, that.stopSignal);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hostname", (Object)this.hostname).add("domainname", (Object)this.domainname).add("username", (Object)this.user).add("attachStdin", (Object)this.attachStdin).add("attachStdout", (Object)this.attachStdout).add("attachStderr", (Object)this.attachStderr).add("portSpecs", this.portSpecs).add("exposedPorts", this.exposedPorts).add("tty", (Object)this.tty).add("openStdin", (Object)this.openStdin).add("stdinOnce", (Object)this.stdinOnce).add("env", this.env).add("cmd", this.cmd).add("image", (Object)this.image).add("volumes", this.volumes).add("workingDir", (Object)this.workingDir).add("entrypoint", this.entrypoint).add("networkDisabled", (Object)this.networkDisabled).add("onBuild", this.onBuild).add("labels", this.labels).add("macAddress", (Object)this.macAddress).add("hostConfig", (Object)this.hostConfig).add("stopSignal", (Object)this.stopSignal).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStopSignal() {
        return this.stopSignal;
    }

    public static class Builder {
        private String hostname;
        private String domainname;
        private String user;
        private Boolean attachStdin;
        private Boolean attachStdout;
        private Boolean attachStderr;
        private ImmutableList<String> portSpecs;
        private ImmutableSet<String> exposedPorts;
        private Boolean tty;
        private Boolean openStdin;
        private Boolean stdinOnce;
        private ImmutableList<String> env;
        private ImmutableList<String> cmd;
        private String image;
        private ImmutableSet<String> volumes;
        private String workingDir;
        private ImmutableList<String> entrypoint;
        private Boolean networkDisabled;
        private ImmutableList<String> onBuild;
        private ImmutableMap<String, String> labels;
        private String macAddress;
        private HostConfig hostConfig;
        private String stopSignal;

        private Builder() {
        }

        private Builder(ContainerConfig config) {
            this.hostname = config.hostname;
            this.domainname = config.domainname;
            this.user = config.user;
            this.attachStdin = config.attachStdin;
            this.attachStdout = config.attachStdout;
            this.attachStderr = config.attachStderr;
            this.portSpecs = config.portSpecs;
            this.exposedPorts = config.exposedPorts;
            this.tty = config.tty;
            this.openStdin = config.openStdin;
            this.stdinOnce = config.stdinOnce;
            this.env = config.env;
            this.cmd = config.cmd;
            this.image = config.image;
            this.volumes = config.volumes.keySet();
            this.workingDir = config.workingDir;
            this.entrypoint = config.entrypoint;
            this.networkDisabled = config.networkDisabled;
            this.onBuild = config.onBuild;
            this.labels = config.labels;
            this.macAddress = config.macAddress;
            this.hostConfig = config.hostConfig;
            this.stopSignal = config.stopSignal;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public String hostname() {
            return this.hostname;
        }

        public Builder domainname(String domainname) {
            this.domainname = domainname;
            return this;
        }

        public String domainname() {
            return this.domainname;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public String user() {
            return this.user;
        }

        public Builder attachStdin(Boolean attachStdin) {
            this.attachStdin = attachStdin;
            return this;
        }

        public Boolean attachStdin() {
            return this.attachStdin;
        }

        public Builder attachStdout(Boolean attachStdout) {
            this.attachStdout = attachStdout;
            return this;
        }

        public Boolean attachStdout() {
            return this.attachStdout;
        }

        public Builder attachStderr(Boolean attachStderr) {
            this.attachStderr = attachStderr;
            return this;
        }

        public Boolean attachStderr() {
            return this.attachStderr;
        }

        public Builder portSpecs(List<String> portSpecs) {
            if (portSpecs != null && !portSpecs.isEmpty()) {
                this.portSpecs = ImmutableList.copyOf(portSpecs);
            }
            return this;
        }

        public Builder portSpecs(String ... portSpecs) {
            if (portSpecs != null && portSpecs.length > 0) {
                this.portSpecs = ImmutableList.copyOf((Object[])portSpecs);
            }
            return this;
        }

        public List<String> portSpecs() {
            return this.portSpecs;
        }

        public Builder exposedPorts(Set<String> exposedPorts) {
            if (exposedPorts != null && !exposedPorts.isEmpty()) {
                this.exposedPorts = ImmutableSet.copyOf(exposedPorts);
            }
            return this;
        }

        public Builder exposedPorts(String ... exposedPorts) {
            if (exposedPorts != null && exposedPorts.length > 0) {
                this.exposedPorts = ImmutableSet.copyOf((Object[])exposedPorts);
            }
            return this;
        }

        public Set<String> exposedPorts() {
            return this.exposedPorts;
        }

        public Builder tty(Boolean tty) {
            this.tty = tty;
            return this;
        }

        public Boolean tty() {
            return this.tty;
        }

        public Builder openStdin(Boolean openStdin) {
            this.openStdin = openStdin;
            return this;
        }

        public Boolean openStdin() {
            return this.openStdin;
        }

        public Builder stdinOnce(Boolean stdinOnce) {
            this.stdinOnce = stdinOnce;
            return this;
        }

        public Boolean stdinOnce() {
            return this.stdinOnce;
        }

        public Builder env(List<String> env) {
            if (env != null && !env.isEmpty()) {
                this.env = ImmutableList.copyOf(env);
            }
            return this;
        }

        public Builder env(String ... env) {
            if (env != null && env.length > 0) {
                this.env = ImmutableList.copyOf((Object[])env);
            }
            return this;
        }

        public List<String> env() {
            return this.env;
        }

        public Builder cmd(List<String> cmd) {
            if (cmd != null && !cmd.isEmpty()) {
                this.cmd = ImmutableList.copyOf(cmd);
            }
            return this;
        }

        public Builder cmd(String ... cmd) {
            if (cmd != null && cmd.length > 0) {
                this.cmd = ImmutableList.copyOf((Object[])cmd);
            }
            return this;
        }

        public List<String> cmd() {
            return this.cmd;
        }

        public Builder image(String image) {
            this.image = image;
            return this;
        }

        public String image() {
            return this.image;
        }

        public Builder volumes(Set<String> volumes) {
            if (volumes != null && !volumes.isEmpty()) {
                this.volumes = ImmutableSet.copyOf(volumes);
            }
            return this;
        }

        public Builder volumes(String ... volumes) {
            if (volumes != null && volumes.length > 0) {
                this.volumes = ImmutableSet.copyOf((Object[])volumes);
            }
            return this;
        }

        public Set<String> volumes() {
            return this.volumes;
        }

        public Builder workingDir(String workingDir) {
            this.workingDir = workingDir;
            return this;
        }

        public String workingDir() {
            return this.workingDir;
        }

        public Builder entrypoint(List<String> entrypoint) {
            if (entrypoint != null && !entrypoint.isEmpty()) {
                this.entrypoint = ImmutableList.copyOf(entrypoint);
            }
            return this;
        }

        public Builder entrypoint(String ... entrypoint) {
            if (entrypoint != null && entrypoint.length > 0) {
                this.entrypoint = ImmutableList.copyOf((Object[])entrypoint);
            }
            return this;
        }

        public List<String> entrypoint() {
            return this.entrypoint;
        }

        public Builder networkDisabled(Boolean networkDisabled) {
            this.networkDisabled = networkDisabled;
            return this;
        }

        public Boolean networkDisabled() {
            return this.networkDisabled;
        }

        public Builder onBuild(List<String> onBuild) {
            if (onBuild != null && !onBuild.isEmpty()) {
                this.onBuild = ImmutableList.copyOf(onBuild);
            }
            return this;
        }

        public Builder onBuild(String ... onBuild) {
            if (onBuild != null && onBuild.length > 0) {
                this.onBuild = ImmutableList.copyOf((Object[])onBuild);
            }
            return this;
        }

        public List<String> onBuild() {
            return this.onBuild;
        }

        public Builder labels(Map<String, String> labels) {
            if (labels != null && !labels.isEmpty()) {
                this.labels = ImmutableMap.copyOf(labels);
            }
            return this;
        }

        public Map<String, String> labels() {
            return this.labels;
        }

        public Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public String macAddress() {
            return this.macAddress;
        }

        public Builder hostConfig(HostConfig hostConfig) {
            this.hostConfig = hostConfig;
            return this;
        }

        public HostConfig hostConfig() {
            return this.hostConfig;
        }

        public Builder stopSignal(String stopSignal) {
            this.stopSignal = stopSignal;
            return this;
        }

        public String stopSignal() {
            return this.stopSignal;
        }

        public ContainerConfig build() {
            return new ContainerConfig(this);
        }
    }
}

