/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.analyzer.config.impl;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.config.AnalyzerConfig;
import org.eclipse.wst.wsi.internal.core.analyzer.config.AssertionResultType;
import org.eclipse.wst.wsi.internal.core.analyzer.config.AssertionResultsOption;
import org.eclipse.wst.wsi.internal.core.analyzer.config.UDDIReference;
import org.eclipse.wst.wsi.internal.core.analyzer.config.WSDLElement;
import org.eclipse.wst.wsi.internal.core.analyzer.config.WSDLReference;
import org.eclipse.wst.wsi.internal.core.analyzer.config.impl.AnalyzerConfigReaderImpl;
import org.eclipse.wst.wsi.internal.core.analyzer.config.impl.AssertionResultsOptionImpl;
import org.eclipse.wst.wsi.internal.core.analyzer.config.impl.UDDIReferenceImpl;
import org.eclipse.wst.wsi.internal.core.analyzer.config.impl.WSDLElementImpl;
import org.eclipse.wst.wsi.internal.core.analyzer.config.impl.WSDLReferenceImpl;
import org.eclipse.wst.wsi.internal.core.common.AddStyleSheet;
import org.eclipse.wst.wsi.internal.core.common.impl.AddStyleSheetImpl;
import org.eclipse.wst.wsi.internal.core.util.MessageList;
import org.eclipse.wst.wsi.internal.core.util.Utils;

public class AnalyzerConfigImpl
implements AnalyzerConfig {
    protected MessageList messageList = null;
    protected String configURI = null;
    protected String description = null;
    protected boolean verbose = false;
    protected AssertionResultsOption assertionResultsOption = new AssertionResultsOptionImpl();
    protected String reportURI = "report.xml";
    protected boolean replaceReport = false;
    protected AddStyleSheet addStyleSheet;
    protected String testAssertionsDocumentURI = "http://www.ws-i.org/Testing/Tools/2004/12/AP10_BP11_SSBP10_TAD.xml";
    protected String logURI = null;
    protected String correlationType = "operation";
    protected WSDLReference wsdlReference = null;
    protected UDDIReference uddiReference = null;

    public AnalyzerConfigImpl() {
    }

    public AnalyzerConfigImpl(String description, boolean verbose, AssertionResultsOption assertionResultsOption, String reportURI, boolean replaceReport, AddStyleSheet addStyleSheet, String testAssertionsDocumentURI, String logURI, String correlationType, WSDLReference wsdlReference, UDDIReference uddiReference) {
        this.description = description;
        this.verbose = verbose;
        this.assertionResultsOption = assertionResultsOption;
        this.reportURI = reportURI;
        this.replaceReport = replaceReport;
        this.addStyleSheet = addStyleSheet;
        this.testAssertionsDocumentURI = testAssertionsDocumentURI;
        this.logURI = logURI;
        this.correlationType = correlationType;
        this.wsdlReference = wsdlReference;
        this.uddiReference = uddiReference;
    }

    @Override
    public void init(MessageList messageList) {
        this.messageList = messageList;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean getVerboseOption() {
        return this.verbose;
    }

    @Override
    public void setVerboseOption(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public AssertionResultsOption getAssertionResultsOption() {
        return this.assertionResultsOption;
    }

    @Override
    public void setAssertionResultsOption(AssertionResultsOption assertionResultsOption) {
        this.assertionResultsOption = assertionResultsOption;
    }

    @Override
    public String getReportLocation() {
        return this.reportURI;
    }

    @Override
    public void setReportLocation(String reportURI) {
        this.reportURI = reportURI;
    }

    @Override
    public boolean getReplaceReport() {
        return this.replaceReport;
    }

    @Override
    public void setReplaceReport(boolean replaceReport) {
        this.replaceReport = replaceReport;
    }

    @Override
    public AddStyleSheet getAddStyleSheet() {
        return this.addStyleSheet;
    }

    @Override
    public void setAddStyleSheet(AddStyleSheet addStyleSheet) {
        this.addStyleSheet = addStyleSheet;
    }

    @Override
    public String getTestAssertionsDocumentLocation() {
        return this.testAssertionsDocumentURI;
    }

    @Override
    public void setTestAssertionsDocumentLocation(String testAssertionsDocumentURI) {
        this.testAssertionsDocumentURI = testAssertionsDocumentURI;
    }

    @Override
    public String getLogLocation() {
        return this.logURI;
    }

    @Override
    public void setLogLocation(String logURI) {
        this.logURI = logURI;
    }

    @Override
    public boolean isLogSet() {
        return this.logURI != null;
    }

    @Override
    public String getCorrelationType() {
        return this.correlationType;
    }

    @Override
    public void setCorrelationType(String correlationType) {
        this.correlationType = correlationType;
    }

    @Override
    public boolean isWSDLReferenceSet() {
        return this.wsdlReference != null;
    }

    @Override
    public WSDLReference getWSDLReference() {
        return this.wsdlReference;
    }

    @Override
    public void setWSDLReference(WSDLReference wsdlReference) {
        this.wsdlReference = wsdlReference;
    }

    @Override
    public WSDLElement getWSDLElement() {
        return this.wsdlReference == null ? null : this.wsdlReference.getWSDLElement();
    }

    @Override
    public String getServiceLocation() {
        return this.wsdlReference == null ? null : this.wsdlReference.getServiceLocation();
    }

    @Override
    public String getWSDLLocation() {
        return this.wsdlReference == null ? null : this.wsdlReference.getWSDLLocation();
    }

    @Override
    public boolean isUDDIReferenceSet() {
        return this.uddiReference != null;
    }

    @Override
    public UDDIReference getUDDIReference() {
        return this.uddiReference;
    }

    @Override
    public void setUDDIReference(UDDIReference uddiReference) {
        this.uddiReference = uddiReference;
    }

    @Override
    public String getLocation() {
        return this.configURI;
    }

    @Override
    public void setLocation(String configURI) {
        this.configURI = configURI;
    }

    @Override
    public String toXMLString(String namespaceName) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String nsName = namespaceName;
        if (!nsName.equals("") && !nsName.endsWith(":")) {
            nsName = String.valueOf(nsName) + ":";
        }
        pw.println("    <" + nsName + "configuration" + ">");
        pw.print("      <" + nsName + "verbose" + ">");
        pw.print(this.getVerboseOption());
        pw.println("</" + nsName + "verbose" + ">");
        pw.print(this.assertionResultsOption.toXMLString(nsName));
        pw.print("        <" + nsName + "reportFile" + " ");
        pw.print("replace=\"" + this.getReplaceReport() + "\" ");
        pw.println("location=\"" + this.getReportLocation() + "\">");
        pw.print(this.getAddStyleSheet().toXMLString(namespaceName));
        pw.println("        </" + nsName + "reportFile" + ">");
        pw.print("        <" + nsName + "testAssertionsFile" + ">");
        pw.print(this.getTestAssertionsDocumentLocation());
        pw.println("</" + nsName + "testAssertionsFile" + ">");
        pw.print("        <" + nsName + "logFile");
        pw.print(" correlationType=\"" + this.correlationType + "\">");
        pw.print(this.getLogLocation());
        pw.println("</" + nsName + "logFile" + ">");
        if (this.wsdlReference != null) {
            pw.print(this.getWSDLReference().toXMLString(nsName));
        }
        if (this.uddiReference != null) {
            pw.print(this.getUDDIReference().toXMLString(nsName));
        }
        pw.println("    </" + nsName + "configuration" + ">");
        return sw.toString();
    }

    @Override
    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("  verbose .................... " + this.verbose);
        pw.print(this.assertionResultsOption.toString());
        pw.println("  Report File:");
        pw.println("    replace .................. " + this.replaceReport);
        pw.println("    location ................. " + this.reportURI);
        if (this.addStyleSheet != null) {
            pw.println("    Style Sheet:");
            if (this.addStyleSheet.getHref() != null) {
                pw.println("      href ................... " + this.addStyleSheet.getHref());
            }
            if (this.addStyleSheet.getType() != null) {
                pw.println("      type ................... " + this.addStyleSheet.getType());
            }
            if (this.addStyleSheet.getTitle() != null) {
                pw.println("      title .................. " + this.addStyleSheet.getTitle());
            }
            if (this.addStyleSheet.getMedia() != null) {
                pw.println("      media .................. " + this.addStyleSheet.getMedia());
            }
            if (this.addStyleSheet.getCharset() != null) {
                pw.println("      charset ................ " + this.addStyleSheet.getCharset());
            }
            if (this.addStyleSheet.getAlternate() != null) {
                pw.println("      alternate .............. " + this.addStyleSheet.getAlternate());
            }
        }
        pw.println("  testAssertionsFile ......... " + this.testAssertionsDocumentURI);
        if (this.logURI != null) {
            pw.println("  Message Log File:");
            pw.println("    location ................. " + this.logURI);
            pw.println("    correlationType .......... " + this.correlationType);
        }
        if (this.isWSDLReferenceSet()) {
            pw.print(this.wsdlReference.toString());
        }
        if (this.isUDDIReferenceSet()) {
            pw.print(this.uddiReference.toString());
        }
        if (this.description != null) {
            pw.println("  description ................ " + this.description);
        }
        return sw.toString();
    }

    private void setConfig(AnalyzerConfig analyzerConfig) {
        this.configURI = analyzerConfig.getLocation();
        this.description = analyzerConfig.getDescription();
        this.verbose = analyzerConfig.getVerboseOption();
        this.assertionResultsOption = analyzerConfig.getAssertionResultsOption();
        this.reportURI = analyzerConfig.getReportLocation();
        this.replaceReport = analyzerConfig.getReplaceReport();
        this.logURI = analyzerConfig.getLogLocation();
        this.correlationType = analyzerConfig.getCorrelationType();
        this.testAssertionsDocumentURI = analyzerConfig.getTestAssertionsDocumentLocation();
        this.addStyleSheet = analyzerConfig.getAddStyleSheet();
        this.wsdlReference = analyzerConfig.getWSDLReference();
        this.uddiReference = analyzerConfig.getUDDIReference();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void parseArgs(String[] args, boolean validate) throws WSIException {
        WSDLReference wsdlReference = null;
        UDDIReference uddiReference = null;
        AnalyzerConfigReaderImpl analyzerConfigReader = new AnalyzerConfigReaderImpl();
        analyzerConfigReader.init(this.messageList);
        AnalyzerConfig analyzerConfigFromArgs = null;
        AssertionResultsOption assertionResultsOption = null;
        if (args.length == 0) {
            throw new IllegalArgumentException(this.getMessage("usage01", "Usage: Analyzer -config <configFilename>"));
        }
        int argCount = 0;
        while (argCount < args.length) {
            if (args[argCount].equalsIgnoreCase("-config") || args[argCount].equals("-c")) {
                analyzerConfigFromArgs = analyzerConfigReader.readAnalyzerConfig(this.getOptionValue(args, ++argCount));
            }
            ++argCount;
        }
        if (analyzerConfigFromArgs == null) {
            analyzerConfigFromArgs = new AnalyzerConfigImpl();
            analyzerConfigFromArgs.init(this.messageList);
        }
        if ((assertionResultsOption = analyzerConfigFromArgs.getAssertionResultsOption()) == null) {
            assertionResultsOption = new AssertionResultsOptionImpl();
            analyzerConfigFromArgs.setAssertionResultsOption(assertionResultsOption);
        }
        argCount = 0;
        while (argCount < args.length) {
            if (args[argCount].equalsIgnoreCase("-config") || args[argCount].equals("-c")) {
                ++argCount;
            } else if (args[argCount].equalsIgnoreCase("-verbose") || args[argCount].equals("-v")) {
                analyzerConfigFromArgs.setVerboseOption(Boolean.valueOf(this.getOptionValue(args, ++argCount)));
            } else if (args[argCount].equalsIgnoreCase("-assertionResults") || args[argCount].equals("-a")) {
                assertionResultsOption.setAssertionResultType(AssertionResultType.newInstance(this.getOptionValue(args, ++argCount)));
            } else if (args[argCount].equalsIgnoreCase("-messageEntry") || args[argCount].equals("-M")) {
                assertionResultsOption.setShowMessageEntry(Boolean.valueOf(this.getOptionValue(args, ++argCount)));
            } else if (args[argCount].equalsIgnoreCase("-assertionDescription") || args[argCount].equals("-A")) {
                assertionResultsOption.setShowAssertionDescription(Boolean.valueOf(args[++argCount]));
            } else if (args[argCount].equalsIgnoreCase("-failureMessage") || args[argCount].equals("-F")) {
                assertionResultsOption.setShowFailureMessage(Boolean.valueOf(this.getOptionValue(args, ++argCount)));
            } else if (args[argCount].equalsIgnoreCase("-failureDetail") || args[argCount].equals("-D")) {
                assertionResultsOption.setShowFailureDetail(Boolean.valueOf(this.getOptionValue(args, ++argCount)));
            } else if (args[argCount].equalsIgnoreCase("-logFile") || args[argCount].equals("-l")) {
                analyzerConfigFromArgs.setLogLocation(this.getOptionValue(args, ++argCount));
            } else if (args[argCount].equalsIgnoreCase("-testAssertionFile") || args[argCount].equals("-t")) {
                analyzerConfigFromArgs.setTestAssertionsDocumentLocation(this.getOptionValue(args, ++argCount));
            } else if (args[argCount].equalsIgnoreCase("-reportFile") || args[argCount].equals("-r")) {
                analyzerConfigFromArgs.setReportLocation(this.getOptionValue(args, ++argCount));
            } else if (args[argCount].equalsIgnoreCase("-replace") || args[argCount].equals("-R")) {
                analyzerConfigFromArgs.setReplaceReport(Boolean.valueOf(this.getOptionValue(args, ++argCount)));
            } else if (args[argCount].equalsIgnoreCase("-correlationType") || args[argCount].equals("-C")) {
                analyzerConfigFromArgs.setCorrelationType(this.getOptionValue(args, ++argCount));
            } else if (args[argCount].equalsIgnoreCase("-wsdlElement") || args[argCount].equals("-W")) {
                String optionName = args[argCount];
                WSDLElementImpl wsdlElement = new WSDLElementImpl();
                wsdlElement.setName(this.getOptionValue(args, ++argCount, optionName));
                wsdlElement.setType(this.getOptionValue(args, ++argCount, optionName));
                wsdlElement.setNamespace(this.getOptionValue(args, ++argCount, optionName));
                if (!args[argCount].startsWith("-")) {
                    wsdlElement.setParentElementName(this.getOptionValue(args, ++argCount, optionName));
                }
                if (wsdlReference != null) {
                    wsdlReference.setWSDLElement(wsdlElement);
                } else {
                    if (uddiReference == null) throw new IllegalArgumentException(this.getMessage("config10", "The -wsdlElement option must appear after the -wsdlURI or -uddiKey options."));
                    uddiReference.setWSDLElement(wsdlElement);
                }
                analyzerConfigFromArgs.setWSDLReference(wsdlReference);
            } else if (args[argCount].equalsIgnoreCase("-serviceLocation") || args[argCount].equals("-S")) {
                ++argCount;
                if (wsdlReference != null) {
                    wsdlReference.setServiceLocation(this.getOptionValue(args, argCount));
                } else {
                    if (uddiReference == null) throw new IllegalArgumentException(this.getMessage("config11", "The -serviceLocation option must appear after the -wsdlURI or -uddiKey options."));
                    uddiReference.setServiceLocation(this.getOptionValue(args, argCount));
                }
            } else if (args[argCount].equalsIgnoreCase("-wsdlURI") || args[argCount].equals("-W")) {
                ++argCount;
                if (wsdlReference == null) {
                    wsdlReference = new WSDLReferenceImpl();
                }
                wsdlReference.setWSDLLocation(this.getOptionValue(args, argCount));
                analyzerConfigFromArgs.setWSDLReference(wsdlReference);
            } else if (args[argCount].equalsIgnoreCase("-uddiKeyType") || args[argCount].equals("-K")) {
                ++argCount;
                if (uddiReference == null) {
                    uddiReference = new UDDIReferenceImpl();
                }
                uddiReference.setKeyType(this.getOptionValue(args, argCount));
                analyzerConfigFromArgs.setUDDIReference(uddiReference);
            } else if (args[argCount].equalsIgnoreCase("-uddiKey") || args[argCount].equals("-k")) {
                ++argCount;
                if (uddiReference == null) {
                    uddiReference = new UDDIReferenceImpl();
                }
                uddiReference.setKey(this.getOptionValue(args, argCount));
                analyzerConfigFromArgs.setUDDIReference(uddiReference);
            } else {
                if (!args[argCount].equalsIgnoreCase("-inquiryURL") && !args[argCount].equals("-i")) throw new IllegalArgumentException(this.getMessage("config12", args[argCount], "The specified option is not supported:"));
                ++argCount;
                if (uddiReference == null) {
                    uddiReference = new UDDIReferenceImpl();
                }
                uddiReference.setInquiryURL(this.getOptionValue(args, argCount));
                analyzerConfigFromArgs.setUDDIReference(uddiReference);
            }
            ++argCount;
        }
        if (analyzerConfigFromArgs.getAddStyleSheet() == null) {
            AddStyleSheetImpl addStyleSheet = new AddStyleSheetImpl();
            addStyleSheet.setHref("../common/xsl/report.xsl");
            addStyleSheet.setType("text/xsl");
            addStyleSheet.setComment(true);
            analyzerConfigFromArgs.setAddStyleSheet(addStyleSheet);
        }
        this.setConfig(analyzerConfigFromArgs);
        if (!validate) return;
        this.checkConfigOptions();
    }

    private void checkConfigOptions() throws WSIException {
        if (this.isWSDLReferenceSet() && this.isUDDIReferenceSet()) {
            throw new IllegalArgumentException(this.getMessage("config04", "Can not specify both the WSDL reference and UDDI reference options"));
        }
        String fileLocation = this.getTestAssertionsDocumentLocation();
        if (fileLocation == null) {
            throw new IllegalArgumentException(this.getMessage("config16", "Test assertion document location must be specified."));
        }
        if (!Utils.fileExists(fileLocation)) {
            throw new IllegalArgumentException(this.getMessage("config14", fileLocation, "Could not find test assertion document.  Specified file location:"));
        }
        fileLocation = this.getLogLocation();
        if (fileLocation != null && !Utils.fileExists(fileLocation)) {
            throw new IllegalArgumentException(this.messageList.getMessage("config02", fileLocation, "Could not find log file:"));
        }
        if (this.getWSDLReference() != null && (fileLocation = this.getWSDLReference().getWSDLLocation()) != null && !Utils.fileExists(fileLocation)) {
            throw new IllegalArgumentException(this.messageList.getMessage("config03", fileLocation, "Could not find WSDL file:"));
        }
        File file = null;
        try {
            file = new File(this.getReportLocation());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(this.messageList.getMessage("config17", "Could not get report file location."));
        }
        if (file.exists() && !this.getReplaceReport()) {
            throw new IllegalArgumentException(this.messageList.getMessage("config15", "Report file already exists and replace option was not specified."));
        }
        if (!(this.correlationType == null || this.correlationType.equals("endpoint") || this.correlationType.equals("namespace") || this.correlationType.equals("operation"))) {
            throw new IllegalArgumentException(this.messageList.getMessage("config18", "Invalid correlation type specified."));
        }
    }

    private String getOptionValue(String[] args, int index) throws WSIException {
        return this.getOptionValue(args, index, args[index - 1]);
    }

    private String getOptionValue(String[] args, int index, String optionName) throws WSIException {
        if (index >= args.length) {
            throw new IllegalArgumentException(this.getMessage("config13", optionName, "Option did not contain a value.  Specified option:"));
        }
        if (args[index].startsWith("-")) {
            throw new IllegalArgumentException(this.getMessage("config13", optionName, "Option did not contain a value.  Specified option:"));
        }
        return args[index];
    }

    private String getMessage(String messageID, String defaultMessage) {
        return this.getMessage(messageID, null, defaultMessage);
    }

    private String getMessage(String messageID, String messageData, String defaultMessage) {
        String message = defaultMessage;
        if (this.messageList != null) {
            message = this.messageList.getMessage(messageID, messageData, defaultMessage);
        } else if (messageData != null) {
            message = String.valueOf(message) + " " + messageData + ".";
        }
        return message;
    }
}

