/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.support;

import java.lang.reflect.Constructor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.model.menu.MenuVisualData;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.swt.support.AbstractSupport;
import org.eclipse.wb.internal.swt.support.IToolkitSupport;
import org.osgi.framework.Bundle;

public class ToolkitSupport
extends AbstractSupport {
    private static IToolkitSupport m_impl_RCP;

    public static void markAsNeededImage(Control control) throws Exception {
        control.setData("WBP_NEED_IMAGE", (Object)Boolean.TRUE);
    }

    public static Image getShotImage(Control control) throws Exception {
        return (Image)control.getData("WBP_IMAGE");
    }

    public static void makeShots(Control control) throws Exception {
        ToolkitSupport.getImpl().makeShots(control);
        ToolkitSupport.makeShotsHierarchy(control);
    }

    private static void makeShotsHierarchy(Control control) throws Exception {
        if (control.getData("WBP_NEED_IMAGE") != null) {
            control.setData("WBP_IMAGE", (Object)ToolkitSupport.getImpl().getShotImage(control));
            if (control instanceof Composite) {
                Composite composite = (Composite)control;
                Control[] controlArray = composite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    ToolkitSupport.makeShotsHierarchy(child);
                    ++n2;
                }
            }
        }
    }

    public static void beginShot(Control control) throws Exception {
        ToolkitSupport.getImpl().beginShot(control);
    }

    public static void endShot(Control control) throws Exception {
        ToolkitSupport.getImpl().endShot(control);
    }

    public static MenuVisualData fetchMenuVisualData(Menu menu) throws Exception {
        return ToolkitSupport.getImpl().fetchMenuVisualData(menu);
    }

    public static int getDefaultMenuBarHeight() throws Exception {
        return ToolkitSupport.getImpl().getDefaultMenuBarHeight();
    }

    public static void showShell(Shell shell) throws Exception {
        ToolkitSupport.getImpl().showShell(shell);
    }

    public static String[] getFontFamilies(boolean scalable) throws Exception {
        return ToolkitSupport.getImpl().getFontFamilies(scalable);
    }

    public static Image getFontPreview(Font font) throws Exception {
        return ToolkitSupport.getImpl().getFontPreview(font);
    }

    private static IToolkitSupport getImpl() throws Exception {
        if (m_impl_RCP == null) {
            m_impl_RCP = ToolkitSupport.createImpl();
        }
        return m_impl_RCP;
    }

    private static IToolkitSupport createImpl() throws Exception {
        Bundle bundle = GlobalState.getToolkit().getBundle();
        Object implClassName = bundle.getSymbolicName() + ".support.ToolkitSupportImpl";
        implClassName = ((String)implClassName).replace(".wb.", ".wb.internal.");
        Class implClass = bundle.loadClass((String)implClassName);
        ClassLoader editorLoader = GlobalState.getClassLoader();
        Constructor constructor = implClass.getConstructor(ClassLoader.class);
        return (IToolkitSupport)constructor.newInstance(editorLoader);
    }
}

