/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.plugin.ImportObject;
import org.eclipse.pde.internal.core.text.AbstractEditingModel;
import org.eclipse.pde.internal.core.text.IDocumentKey;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleClasspathHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.BundleSymbolicNameHeader;
import org.eclipse.pde.internal.core.text.bundle.CompositeManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.ExecutionEnvironment;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PDEManifestElement;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleObject;
import org.eclipse.pde.internal.core.text.bundle.RequiredExecutionEnvironmentHeader;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.IFoldingStructureProvider;
import org.eclipse.pde.internal.ui.editor.KeyValueSourcePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.plugin.BundleFoldingStructureProvider;
import org.eclipse.pde.internal.ui.editor.plugin.BundleHyperlinkDetector;
import org.eclipse.pde.internal.ui.editor.text.ChangeAwareSourceViewerConfiguration;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.ManifestConfiguration;
import org.eclipse.pde.internal.ui.refactoring.PDERefactoringAction;
import org.eclipse.pde.internal.ui.refactoring.RefactoringActionFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.forms.editor.FormEditor;

public class BundleSourcePage
extends KeyValueSourcePage {
    private Object fTargetOutlineSelection;
    private int fCurrentHighlightRangeOffset;
    private static final int F_NOT_SET = -1;
    private PDERefactoringAction fRenameAction;

    private IPluginLibrary[] getBundleClasspathLibraries() {
        IPluginModelBase pluginModel = this.getPluginModel();
        return pluginModel != null ? pluginModel.getPluginBase().getLibraries() : new IPluginLibrary[]{};
    }

    private IPluginModelBase getPluginModel() {
        PDEFormEditor formEditor;
        IBaseModel iBaseModel;
        FormEditor formEditor2 = this.getEditor();
        if (formEditor2 instanceof PDEFormEditor && (iBaseModel = (formEditor = (PDEFormEditor)formEditor2).getAggregateModel()) instanceof IPluginModelBase) {
            IPluginModelBase pluginModel = (IPluginModelBase)iBaseModel;
            return pluginModel;
        }
        return null;
    }

    public BundleSourcePage(PDEFormEditor editor, String id, String title) {
        super(editor, id, title);
        this.resetTargetOutlineSelection();
        this.resetCurrentHighlightRangeOffset();
    }

    private void setCurrentHighlightRangeOffset(int offset) {
        this.fCurrentHighlightRangeOffset = offset;
    }

    private void resetCurrentHighlightRangeOffset() {
        this.fCurrentHighlightRangeOffset = -1;
    }

    private int getCurrentHighlightRangeOffset() {
        return this.fCurrentHighlightRangeOffset;
    }

    public void resetHighlightRange() {
        this.resetCurrentHighlightRangeOffset();
        super.resetHighlightRange();
    }

    private void resetTargetOutlineSelection() {
        this.fTargetOutlineSelection = null;
    }

    private void setTargetOutlineSelection(Object object) {
        this.fTargetOutlineSelection = object;
    }

    private Object getTargetOutlineSelection() {
        return this.fTargetOutlineSelection;
    }

    @Override
    public ILabelProvider createOutlineLabelProvider() {
        return new BundleLabelProvider();
    }

    @Override
    public ITreeContentProvider createOutlineContentProvider() {
        return new BundleOutlineContentProvider();
    }

    @Override
    public IDocumentRange getRangeElement(int offset, boolean searchChildren) {
        IBundleModel model = (IBundleModel)this.getInputContext().getModel();
        Map manifest = ((Bundle)model.getBundle()).getHeaders();
        this.resetTargetOutlineSelection();
        for (IManifestHeader node : manifest.values()) {
            IDocumentRange child_node;
            if (!this.isWithinCurrentRange(offset, (IDocumentRange)node)) continue;
            if (searchChildren && node instanceof CompositeManifestHeader && (child_node = this.getRangeElementChild(model, offset, (CompositeManifestHeader)node)) != null) {
                return child_node;
            }
            this.setTargetOutlineSelection(node);
            return node;
        }
        return null;
    }

    private boolean isWithinCurrentRange(int offset, IDocumentRange range) {
        return range != null && offset >= range.getOffset() && offset <= range.getOffset() + range.getLength();
    }

    private boolean isWithinPreviousRange(int offset, IDocumentRange current_range, IDocumentRange previous_range) {
        return current_range != null && previous_range != null && offset >= previous_range.getOffset() + previous_range.getLength() && offset <= current_range.getOffset();
    }

    private boolean isBeforePreviousRange(int offset, IDocumentRange previousRange) {
        return previousRange != null && offset < previousRange.getOffset();
    }

    private IDocumentRange getRangeElementChild(IBundleModel model, int offset, CompositeManifestHeader header) {
        if (header.isEmpty()) {
            return null;
        }
        PDEManifestElement[] elements = header.getElements();
        String headerName = this.getHeaderName(elements[0]);
        PDEManifestElement previousElement = null;
        PDEManifestElement currentElement = null;
        IDocumentRange previousRange = null;
        IDocumentRange currentRange = null;
        PDEManifestElement[] pDEManifestElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            PDEManifestElement element;
            currentElement = element = pDEManifestElementArray[n2];
            currentRange = BundleSourcePage.getSpecificRange(model, headerName, currentElement.getValue());
            if (this.isBeforePreviousRange(offset, previousRange)) {
                return null;
            }
            if (this.isWithinCurrentRange(offset, currentRange)) {
                this.setChildTargetOutlineSelection(headerName, currentElement);
                return currentRange;
            }
            if (this.isWithinPreviousRange(offset, currentRange, previousRange)) {
                this.setChildTargetOutlineSelection(headerName, previousElement);
                return previousRange;
            }
            previousRange = currentRange;
            previousElement = currentElement;
            ++n2;
        }
        if (this.isWithinLastElementParamRange(offset, currentRange, (IDocumentRange)header)) {
            this.setChildTargetOutlineSelection(headerName, currentElement);
            return currentRange;
        }
        return null;
    }

    private boolean isWithinLastElementParamRange(int offset, IDocumentRange currentRange, IDocumentRange headerRange) {
        return currentRange != null && offset >= currentRange.getOffset() + currentRange.getLength() && offset <= headerRange.getOffset() + headerRange.getLength();
    }

    private void setChildTargetOutlineSelection(String headerName, PDEManifestElement element) {
        if (headerName.equalsIgnoreCase("Bundle-ClassPath")) {
            this.setTargetOutlineSelection(this.getBundleClasspathOutlineSelection(element));
        } else {
            this.setTargetOutlineSelection(element);
        }
    }

    private Object getBundleClasspathOutlineSelection(PDEManifestElement manifestElement) {
        IPluginLibrary[] libraries;
        IPluginLibrary[] iPluginLibraryArray = libraries = this.getBundleClasspathLibraries();
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginLibrary library = iPluginLibraryArray[n2];
            if (manifestElement.getValue().equals(library.getName())) {
                return library;
            }
            ++n2;
        }
        return null;
    }

    private String getHeaderName(PDEManifestElement element) {
        if (element instanceof ExportPackageObject) {
            return "Export-Package";
        }
        if (element instanceof ImportPackageObject) {
            return "Import-Package";
        }
        if (element instanceof ExecutionEnvironment) {
            return "Bundle-RequiredExecutionEnvironment";
        }
        if (element instanceof RequireBundleObject) {
            return "Require-Bundle";
        }
        return "Bundle-ClassPath";
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] ids = super.collectContextMenuPreferencePages();
        String[] more = new String[ids.length + 1];
        more[0] = "org.eclipse.pde.ui.EditorPreferencePage";
        System.arraycopy(ids, 0, more, 1, ids.length);
        return more;
    }

    @Override
    public IDocumentRange findRange() {
        Object selection = this.getSelection();
        if (selection instanceof ImportObject) {
            ImportObject importObject = (ImportObject)selection;
            IPluginModelBase iPluginModelBase = importObject.getImport().getPluginModel();
            if (iPluginModelBase instanceof IBundlePluginModelBase) {
                IBundlePluginModelBase pluginModel = (IBundlePluginModelBase)iPluginModelBase;
                return BundleSourcePage.getSpecificRange(pluginModel.getBundleModel(), "Require-Bundle", importObject.getId());
            }
        } else {
            if (selection instanceof ImportPackageObject) {
                ImportPackageObject packageImport = (ImportPackageObject)selection;
                return BundleSourcePage.getSpecificRange(packageImport.getModel(), "Import-Package", packageImport.getValue());
            }
            if (selection instanceof ExportPackageObject) {
                ExportPackageObject packageExport = (ExportPackageObject)selection;
                return BundleSourcePage.getSpecificRange(packageExport.getModel(), "Export-Package", packageExport.getValue());
            }
            if (selection instanceof IPluginLibrary) {
                IPluginLibrary library = (IPluginLibrary)selection;
                IPluginModelBase iPluginModelBase = library.getPluginModel();
                if (iPluginModelBase instanceof IBundlePluginModelBase) {
                    IBundlePluginModelBase pluginModel = (IBundlePluginModelBase)iPluginModelBase;
                    return BundleSourcePage.getSpecificRange(pluginModel.getBundleModel(), "Bundle-ClassPath", library.getName());
                }
            } else {
                if (selection instanceof ExecutionEnvironment) {
                    ExecutionEnvironment ee = (ExecutionEnvironment)selection;
                    return BundleSourcePage.getSpecificRange(ee.getModel(), "Bundle-RequiredExecutionEnvironment", ee.getName());
                }
                if (selection instanceof RequireBundleObject) {
                    RequireBundleObject requiredBundle = (RequireBundleObject)selection;
                    return BundleSourcePage.getSpecificRange(requiredBundle.getModel(), "Require-Bundle", requiredBundle.getId());
                }
            }
        }
        return null;
    }

    public static IDocumentRange getSpecificRange(IBundleModel model, IManifestHeader header, String element) {
        if (header == null || !(model instanceof IEditingModel)) {
            return null;
        }
        final int[] range = new int[]{-1, -1};
        try {
            int start = header.getOffset() + header.getName().length();
            int length = header.getLength() - header.getName().length();
            String headerValue = ((IEditingModel)model).getDocument().get(start, length);
            int i = headerValue.indexOf(element);
            int last = headerValue.lastIndexOf(element);
            if (i > 0 && i != last) {
                char[] sChar = element.toCharArray();
                char[] headerChar = headerValue.toCharArray();
                while (i <= last) {
                    block10: {
                        if (headerChar[i] == sChar[0] || headerChar[i + sChar.length / 2] == sChar[sChar.length / 2] || headerChar[i + sChar.length - 1] == sChar[sChar.length - 1]) {
                            int index;
                            int j = 1;
                            while (j < sChar.length - 1) {
                                if (headerChar[i + j] == sChar[j]) {
                                    ++j;
                                    continue;
                                }
                                break block10;
                            }
                            char c = headerChar[i - 1];
                            if (!(!Character.isWhitespace(c) && c != ',' || (index = i + sChar.length) >= headerChar.length || (c = headerChar[index]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && c != '.') break;
                        }
                    }
                    ++i;
                }
            }
            if (i != -1) {
                range[0] = start + i;
                range[1] = element.length();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (range[0] == -1) {
            range[0] = header.getOffset();
            range[1] = header.getName().length();
        }
        return new IDocumentRange(){

            public int getOffset() {
                return range[0];
            }

            public int getLength() {
                return range[1];
            }
        };
    }

    public static IDocumentRange getSpecificRange(IBundleModel model, String headerName, String search) {
        IManifestHeader header = model.getBundle().getManifestHeader(headerName);
        return BundleSourcePage.getSpecificRange(model, header, search);
    }

    @Override
    protected boolean isSelectionListener() {
        return true;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (IHyperlinkDetector.class.equals(adapter)) {
            return adapter.cast(new BundleHyperlinkDetector(this));
        }
        return super.getAdapter(adapter);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateSelection(Object object) {
        this.setSelectedObject(object);
        if (object instanceof IDocumentKey) {
            IDocumentKey key = (IDocumentKey)object;
            this.setHighlightRange(key);
            this.setCurrentHighlightRangeOffset(key.getOffset());
            return;
        }
        IDocumentRange range = this.findRange();
        if (range == null) {
            return;
        }
        IBaseModel model = this.getInputContext().getModel();
        if (!(model instanceof AbstractEditingModel)) {
            return;
        }
        AbstractEditingModel abstractEditingModel = (AbstractEditingModel)model;
        if (range.getOffset() == -1 || this.isDirty()) {
            try {
                void editingModel;
                editingModel.adjustOffsets(editingModel.getDocument());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            range = this.findRange();
        }
        this.setCurrentHighlightRangeOffset(range.getOffset());
        this.setHighlightRange(range, true);
        this.setSelectedRange(range, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void handleSelectionChangedSourcePage(SelectionChangedEvent event) {
        void textSelection;
        super.handleSelectionChangedSourcePage(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty() || !(selection instanceof ITextSelection)) {
            return;
        }
        ITextSelection iTextSelection = (ITextSelection)selection;
        IBaseModel model = this.getInputContext().getModel();
        if (model instanceof AbstractEditingModel) {
            AbstractEditingModel editingModel = (AbstractEditingModel)model;
            if (this.isDirty()) {
                try {
                    editingModel.adjustOffsets(editingModel.getDocument());
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        this.synchronizeOutlinePage(textSelection.getOffset());
    }

    @Override
    protected void synchronizeOutlinePage(int offset) {
        int previous_offset = this.getCurrentHighlightRangeOffset();
        if (previous_offset == offset) {
            return;
        }
        IDocumentRange rangeElement = this.getRangeElement(offset, true);
        this.updateHighlightRange(rangeElement);
        this.updateOutlinePageSelection(this.getTargetOutlineSelection());
    }

    @Override
    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        IBaseModel base;
        super.editorContextMenuAboutToShow(menu);
        StyledText text = this.getViewer().getTextWidget();
        Point p = text.getSelection();
        IDocumentRange element = this.getRangeElement(p.x, false);
        if (!(element instanceof BundleSymbolicNameHeader) || !((BundleSymbolicNameHeader)element).getModel().isEditable()) {
            return;
        }
        if (this.fRenameAction == null && (base = ((PDEFormEditor)this.getEditor()).getAggregateModel()) instanceof IPluginModelBase) {
            this.fRenameAction = RefactoringActionFactory.createRefactorPluginIdAction(NLS.bind((String)PDEUIMessages.BundleSourcePage_renameActionText, (Object)"Bundle-SymbolicName"));
            this.fRenameAction.setSelection(base);
        }
        if (this.fRenameAction != null) {
            menu.insertAfter("org.eclipse.pde.ui.quickOutline", (IAction)this.fRenameAction);
        }
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.updateTextSelection();
        }
    }

    @Override
    protected IFoldingStructureProvider getFoldingStructureProvider(IEditingModel model) {
        return new BundleFoldingStructureProvider(this, model);
    }

    @Override
    protected ChangeAwareSourceViewerConfiguration createSourceViewerConfiguration(IColorManager colorManager) {
        return new ManifestConfiguration(colorManager, this);
    }

    private class BundleLabelProvider
    extends LabelProvider {
        private BundleLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof PackageObject) {
                PackageObject packageObject = (PackageObject)obj;
                return packageObject.getName();
            }
            if (obj instanceof ExecutionEnvironment) {
                ExecutionEnvironment ee = (ExecutionEnvironment)obj;
                return ee.getName();
            }
            if (obj instanceof RequireBundleObject) {
                RequireBundleObject requireBundle = (RequireBundleObject)obj;
                return this.getTextRequireBundle(requireBundle);
            }
            if (obj instanceof ManifestHeader) {
                ManifestHeader header = (ManifestHeader)obj;
                return header.getName();
            }
            return super.getText(obj);
        }

        private String getTextRequireBundle(RequireBundleObject bundle) {
            StringBuilder label = new StringBuilder();
            label.append(bundle.getId());
            String version = bundle.getVersion();
            if (version == null || version.length() == 0) {
                return label.toString();
            }
            label.append(' ');
            char firstChar = version.charAt(0);
            if (firstChar != '(' && firstChar != '[') {
                label.append('(');
            }
            label.append(version);
            char lastChar = version.charAt(version.length() - 1);
            if (lastChar != ')' && lastChar != ']') {
                label.append(')');
            }
            return label.toString();
        }

        public Image getImage(Object obj) {
            PDELabelProvider labelProvider = PDEPlugin.getDefault().getLabelProvider();
            if (obj instanceof PackageObject) {
                return labelProvider.get(PDEPluginImages.DESC_PACKAGE_OBJ);
            }
            if (obj instanceof ExecutionEnvironment) {
                return labelProvider.get(PDEPluginImages.DESC_JAVA_LIB_OBJ);
            }
            if (obj instanceof RequireBundleObject) {
                RequireBundleObject requireBundle = (RequireBundleObject)obj;
                int flags = 32;
                if (requireBundle.isReexported()) {
                    flags |= 4;
                }
                return labelProvider.get(PDEPluginImages.DESC_REQ_PLUGIN_OBJ, flags);
            }
            if (obj instanceof ManifestHeader) {
                return labelProvider.get(PDEPluginImages.DESC_BUILD_VAR_OBJ);
            }
            if (obj instanceof IPluginLibrary) {
                return labelProvider.get(PDEPluginImages.DESC_JAVA_LIB_OBJ);
            }
            return null;
        }
    }

    private class BundleOutlineContentProvider
    implements ITreeContentProvider {
        private BundleOutlineContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof ImportPackageHeader) {
                ImportPackageHeader importHeader = (ImportPackageHeader)parent;
                return importHeader.getPackages();
            }
            if (parent instanceof ExportPackageHeader) {
                ExportPackageHeader exportHeader = (ExportPackageHeader)parent;
                return exportHeader.getPackages();
            }
            if (parent instanceof RequiredExecutionEnvironmentHeader) {
                RequiredExecutionEnvironmentHeader breeHeader = (RequiredExecutionEnvironmentHeader)parent;
                return breeHeader.getElements();
            }
            if (parent instanceof RequireBundleHeader) {
                RequireBundleHeader requireBundleHeader = (RequireBundleHeader)parent;
                return requireBundleHeader.getRequiredBundles();
            }
            if (parent instanceof BundleClasspathHeader) {
                return BundleSourcePage.this.getBundleClasspathLibraries();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            return this.getChildren(parent).length > 0;
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof BundleModel) {
                BundleModel model = (BundleModel)parent;
                Map manifest = ((Bundle)model.getBundle()).getHeaders();
                return manifest.values().stream().filter(header -> header.getOffset() > -1).toArray();
            }
            return new Object[0];
        }
    }
}

