/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.jface.viewer.radiogroup;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.nebula.widgets.radiogroup.RadioGroup;
import org.eclipse.nebula.widgets.radiogroup.RadioItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;

public class RadioGroupViewer
extends AbstractListViewer {
    private final RadioGroup radioGroup;

    public RadioGroupViewer(Composite parent) {
        this(parent, 0);
    }

    public RadioGroupViewer(Composite parent, int style) {
        this(new RadioGroup(parent, style));
    }

    public RadioGroupViewer(RadioGroup group) {
        Assert.isNotNull((Object)((Object)group));
        this.radioGroup = group;
        this.hookControl((Control)group);
        Listener[] keyDownListeners = group.getListeners(1);
        if (keyDownListeners.length == 1) {
            group.removeListener(1, keyDownListeners[0]);
        }
    }

    public void add(Object element) {
        super.add(element);
    }

    public void add(Object ... elements) {
        super.add(elements);
    }

    public Control getControl() {
        return this.radioGroup;
    }

    public Object getElementAt(int index) {
        return super.getElementAt(index);
    }

    public RadioGroup getRadioGroup() {
        return this.radioGroup;
    }

    protected int indexForElement(Object element) {
        return super.indexForElement(element);
    }

    public void insert(Object element, int position) {
        super.insert(element, position);
    }

    protected void listAdd(String string, int index) {
        this.radioGroup.setLayoutDeferred(true);
        try {
            RadioItem item = new RadioItem(this.radioGroup, 0, index);
            item.setText(string);
        }
        finally {
            this.radioGroup.setLayoutDeferred(false);
        }
    }

    protected void listDeselectAll() {
        this.radioGroup.deselectAll();
    }

    protected int listGetItemCount() {
        return this.radioGroup.getItemCount();
    }

    protected int[] listGetSelectionIndices() {
        return new int[]{this.radioGroup.getSelectionIndex()};
    }

    protected int listGetTopIndex() {
        return super.listGetTopIndex();
    }

    protected void listRemove(int index) {
        this.radioGroup.remove(index);
    }

    protected void listRemoveAll() {
        this.radioGroup.removeAll();
    }

    protected void listSetItem(int index, String string) {
        RadioItem item = this.radioGroup.getItems()[index];
        item.setText(string);
    }

    protected void listSetItems(String[] labels) {
        this.radioGroup.removeAll();
        int i = 0;
        while (i < labels.length) {
            RadioItem item = new RadioItem(this.radioGroup, 0);
            item.setText(labels[i]);
            ++i;
        }
    }

    protected void listSetSelection(int[] ixs) {
        int idx = 0;
        while (idx < ixs.length) {
            this.radioGroup.select(ixs[idx]);
            ++idx;
        }
    }

    protected void listSetTopIndex(int index) {
        super.listSetTopIndex(index);
    }

    protected void listShowSelection() {
    }

    public void remove(Object element) {
        super.remove(element);
    }

    public void remove(Object ... elements) {
        super.remove(elements);
    }

    public void reveal(Object element) {
    }
}

