/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlModelAnalyser;
import org.eclipse.m2m.atl.engine.parser.AtlParser;

public class AtlCompletionHelper {
    public static final String[] PARSING_KEYWORDS = new String[]{"rule", "helper", "query"};
    public static final String[] HIGH_LEVEL_KEYWORDS = new String[]{"rule", "helper", "from", "to", "do", "using", "module", "library", "query"};
    private IDocument document;

    public AtlCompletionHelper(String text) {
        this.document = new Document(text);
    }

    public AtlModelAnalyser computeModelAnalyser(int offset, String prefix, String fileContext) throws BadLocationException {
        int begin;
        int[] lastParsingKeyWordLocation = this.getLastKeyWordLocation(offset - prefix.length(), PARSING_KEYWORDS);
        String lastParsingKeyWord = null;
        if (lastParsingKeyWordLocation[0] > -1) {
            int lineNumber = this.document.getLineOfOffset(lastParsingKeyWordLocation[0]);
            begin = this.document.getLineOffset(lineNumber);
            lastParsingKeyWord = this.document.get(lastParsingKeyWordLocation[0], lastParsingKeyWordLocation[1]);
        } else {
            begin = 0;
        }
        int end = offset;
        String text = this.document.get(begin, end - begin);
        if (text.substring(0, text.length() - prefix.length()).trim().endsWith("->")) {
            text = String.valueOf(text.substring(0, text.length() - prefix.length()).trim()) + "debug()." + prefix;
        }
        if (prefix.equals("")) {
            text = String.valueOf(text) + "a";
        } else if (prefix.startsWith("'")) {
            text = String.valueOf(text) + "'";
        }
        String lastKeyword = this.getLastKeyWord(offset - prefix.length());
        if ("do".equals(lastKeyword)) {
            text = String.valueOf(text) + ";";
        }
        if (lastParsingKeyWord == null) {
            return new AtlModelAnalyser(this, null, begin, fileContext);
        }
        EObject[] ret = AtlParser.getDefault().parseExpression(text, lastParsingKeyWord);
        return new AtlModelAnalyser(this, ret[0], begin, fileContext);
    }

    public String getText(EObject locatedElement, int baseOffset) throws BadLocationException {
        int[] offset = this.getElementOffsets(locatedElement, baseOffset);
        if (offset != null) {
            return this.document.get(offset[0], offset[1] - offset[0]);
        }
        return "";
    }

    public int[] getElementOffsets(EObject element, int baseOffset) throws BadLocationException {
        String location = AtlCompletionHelper.getLocation(element);
        if (location != null) {
            location = location.replaceAll("'", "");
            int linesToAdd = this.document.getLineOfOffset(baseOffset);
            int columnsToAdd = baseOffset - this.document.getLineOffset(this.document.getLineOfOffset(baseOffset));
            int debLine = new Integer(location.split("-")[0].split(":")[0]) + linesToAdd;
            int debColumn = new Integer(location.split("-")[0].split(":")[1]) + columnsToAdd;
            int endLine = new Integer(location.split("-")[1].split(":")[0]) + linesToAdd;
            int endColumn = new Integer(location.split("-")[1].split(":")[1]) + columnsToAdd;
            int debOffset = this.document.getLineOffset(debLine - 1) + debColumn - 1;
            int endOffset = this.document.getLineOffset(endLine - 1) + endColumn - 1;
            return new int[]{debOffset, endOffset};
        }
        return null;
    }

    public static String getLocation(EObject element) {
        EStructuralFeature feature = element.eClass().getEStructuralFeature("location");
        if (feature != null) {
            return (String)element.eGet(feature);
        }
        return null;
    }

    public String getLastKeyWord(int offset) throws BadLocationException {
        int[] location = this.getLastKeyWordLocation(offset, HIGH_LEVEL_KEYWORDS);
        if (location[0] > -1) {
            return this.document.get(location[0], location[1]);
        }
        return null;
    }

    public EObject getLocatedElement(EObject root, int offset, int modelOffset) throws BadLocationException {
        EObject res = null;
        if (root != null) {
            TreeIterator ti = root.eResource().getAllContents();
            int maxDebOffset = -1;
            while (ti.hasNext()) {
                EObject object = (EObject)ti.next();
                int[] elementOffsets = this.getElementOffsets(object, modelOffset);
                if (elementOffsets == null || elementOffsets[0] > offset || elementOffsets[1] < offset || elementOffsets[0] < maxDebOffset) continue;
                maxDebOffset = elementOffsets[0];
                res = object;
            }
        }
        return res;
    }

    private int[] getLastKeyWordLocation(int offset, String[] keywords) throws BadLocationException {
        int i = offset;
        if (this.document != null && i <= this.document.getLength()) {
            StringBuffer word = new StringBuffer();
            while (i > -1) {
                if (i == 0 || !AtlCompletionHelper.isAtlIdentifierPart(this.document.getChar(i - 1))) {
                    String[] stringArray = keywords;
                    int n = keywords.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String keyword = stringArray[n2];
                        if (word.toString().equals(keyword)) {
                            int lineNumber = this.document.getLineOfOffset(i);
                            int lineOffset = this.document.getLineOffset(lineNumber);
                            String line = this.document.get(lineOffset, i - lineOffset);
                            if (line.indexOf("--") > -1) {
                                i = this.document.get().lastIndexOf("--", i);
                                word = new StringBuffer();
                            } else {
                                return new int[]{i, keyword.length()};
                            }
                        }
                        ++n2;
                    }
                    word = new StringBuffer();
                } else {
                    word.insert(0, this.document.getChar(i - 1));
                }
                --i;
            }
        }
        int[] nArray = new int[2];
        nArray[0] = -1;
        return nArray;
    }

    public static boolean isAtlIdentifierPart(char ch) {
        return !Character.isWhitespace(ch) && ch != '.' && ch != '(' && ch != ')' && ch != '{' && ch != '}' && ch != '.' && ch != ';' && ch != ',' && ch != ':' && ch != '|' && ch != '+' && ch != '-' && ch != '<' && ch != '=' && ch != '>' && ch != '*' && ch != '/';
    }
}

