/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.model.internal.validation.AValidateKeyClass;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IMessagePrefixEjb11Constants;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRuleList;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class ValidateCMPKey
extends AValidateKeyClass
implements IMessagePrefixEjb11Constants {
    private boolean hasAConstructor = false;
    private boolean hasDefaultConstructor = false;
    private Set _beanFieldNames = new HashSet();
    private static final String MSSGID = ".eb";
    private static final String EXT = ".eb.ejb11";
    private static final String BEXT = ".eb.i.ejb11";
    private static final String MEXT = ".eb.m.ejb11";
    private static final Object ID = IValidationRuleList.EJB11_CMP_KEYCLASS;
    private static final Object[] DEPENDS_ON = new Object[]{IValidationRuleList.EJB11_CMP_BEANCLASS};
    private static final Map MESSAGE_IDS = new HashMap();

    static {
        MESSAGE_IDS.put("CHKJ2001", new String[]{"CHKJ2001.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2019", new String[]{"CHKJ2019.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2020", new String[]{"CHKJ2020.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2021", new String[]{"CHKJ2021.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2205", new String[]{"CHKJ2205.eb.i.ejb11", "CHKJ2205.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2206", new String[]{"CHKJ2206.eb.i.ejb11", "CHKJ2206.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2041", new String[]{"CHKJ2041"});
        MESSAGE_IDS.put("CHKJ2433", new String[]{"CHKJ2433"});
        MESSAGE_IDS.put("CHKJ2829", new String[]{"CHKJ2829.ejb11"});
        MESSAGE_IDS.put("CHKJ2907", new String[]{"CHKJ2907"});
    }

    @Override
    public void reset() {
        super.reset();
        this._beanFieldNames.clear();
    }

    @Override
    public final Map getMessageIds() {
        return MESSAGE_IDS;
    }

    @Override
    public final Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    @Override
    public Object getTarget(Object parent, Object clazz) {
        if (parent == null) {
            return null;
        }
        ContainerManagedEntity cmp = (ContainerManagedEntity)parent;
        if (ValidationRuleUtility.isPrimitivePrimaryKey(cmp)) {
            return null;
        }
        return cmp.getPrimaryKey();
    }

    @Override
    public final Object getId() {
        return ID;
    }

    protected void buildFieldNameList(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) {
        vc.terminateIfCancelled();
        ContainerManagedEntity cmp = (ContainerManagedEntity)bean;
        if (cmp == null) {
            return;
        }
        if (!ValidationRuleUtility.isPrimitivePrimaryKey(cmp)) {
            EList attributes = cmp.getPersistentAttributes();
            CMPAttribute attribute2 = null;
            for (CMPAttribute attribute2 : attributes) {
                try {
                    ValidationRuleUtility.isValidType(attribute2.getType());
                    this._beanFieldNames.add(attribute2.getName());
                }
                catch (InvalidInputException e) {
                    this.reflectionWarning(vc, bean, clazz, attribute2.getField(), e);
                }
            }
        }
    }

    @Override
    public void primValidate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field) throws InvalidInputException {
        if (!ValidationRuleUtility.isPublic(field)) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2205", 2, bean, clazz, field, (IValidationRule)this);
            vc.addMessage(message);
        }
        ContainerManagedEntity cmp = (ContainerManagedEntity)bean;
        if (!this._beanFieldNames.contains(field.getName())) {
            JavaClass ejbClass = cmp.getEjbClass();
            ValidationRuleUtility.isValidType((JavaHelpers)ejbClass);
            String[] msgParm = new String[]{cmp.getName(), cmp.getEjbClass().getName()};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2206", 2, bean, clazz, field, msgParm, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    @Override
    public void primValidate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method ejbMethod) throws InvalidInputException {
    }

    @Override
    protected void primValidateExistence(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method ejbMethod) throws InvalidInputException {
        if (ejbMethod.isConstructor()) {
            this.hasAConstructor = true;
            if (ValidationRuleUtility.isPublic(ejbMethod) && ejbMethod.listParametersWithoutReturn().length == 0) {
                this.hasDefaultConstructor = true;
            }
        }
    }

    @Override
    public void validateClass(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        EList primKeyFields;
        super.validateClass(vc, bean, clazz);
        vc.terminateIfCancelled();
        if (!clazz.isPublic()) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2020", 1, bean, clazz, new String[]{clazz.getQualifiedName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.buildFieldNameList(vc, bean, clazz);
        ContainerManagedEntity cmp = (ContainerManagedEntity)bean;
        if (!(ValidationRuleUtility.usesUnknownPrimaryKey(cmp) || (primKeyFields = cmp.getKeyAttributes()) != null && primKeyFields.size() != 0)) {
            JavaClass primaryKey = cmp.getPrimaryKey();
            String beanName = cmp.getName() == null ? "null" : cmp.getName();
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2829", 1, bean, primaryKey, new String[]{primaryKey.getName(), beanName}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    @Override
    public void validateMethodExists(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        super.validateMethodExists(vc, bean, clazz);
        if (!this.hasDefaultConstructor && this.hasAConstructor) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2021", 1, bean, clazz, new String[]{clazz.getQualifiedName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    @Override
    public void preValidate(IEJBValidationContext vc, Object targetParent, Object target) throws ValidationCancelledException, ValidationException {
        super.preValidate(vc, targetParent, target);
        this.hasAConstructor = false;
        this.hasDefaultConstructor = false;
    }
}

