/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.workbench.utility;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.plugin.JavaEMFNature;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jem.util.emf.workbench.nature.EMFNature;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;

public class JemProjectUtilities
extends ProjectUtilities {
    public static final String JEM_EMF_NatureID = "org.eclipse.jem.workbench.JavaEMFNature";

    private JemProjectUtilities() {
    }

    public static EMFNature getJEM_EMF_Nature(IProject project, boolean addNature) throws CoreException {
        return addNature ? JavaEMFNature.createRuntime(project) : JavaEMFNature.getRuntime(project);
    }

    public static JavaClass getJavaClass(IFile aFile) {
        if (aFile == null) {
            return null;
        }
        IProject project = aFile.getProject();
        List folders = JemProjectUtilities.getSourceContainers(project);
        folders.addAll(JemProjectUtilities.getLibraryContainers(project));
        IContainer folder = null;
        IPath filePath = aFile.getProjectRelativePath();
        int i = 0;
        while (i < folders.size()) {
            folder = (IContainer)folders.get(i);
            IPath folderPath = folder.getProjectRelativePath();
            int segments = filePath.matchingFirstSegments(folderPath);
            if (segments > 0) {
                IPath javaPath = filePath.removeFirstSegments(segments);
                javaPath = javaPath.removeFileExtension();
                String qualifiedName = javaPath.toString().replace('/', '.');
                return (JavaClass)JavaRefFactory.eINSTANCE.reflectType(qualifiedName, WorkbenchResourceHelperBase.getResourceSet((IProject)project));
            }
            ++i;
        }
        return null;
    }

    public static List getSourceContainers(IProject p) {
        try {
            ArrayList<Object> sourceContainers = new ArrayList<Object>();
            List sourcePaths = JemProjectUtilities.getSourcePaths(p);
            if (sourcePaths != null && !sourcePaths.isEmpty()) {
                int i = 0;
                while (i < sourcePaths.size()) {
                    IPath path = (IPath)sourcePaths.get(i);
                    if (path.isEmpty()) {
                        sourceContainers.add(p);
                    } else {
                        sourceContainers.add(p.getFolder(path));
                    }
                    ++i;
                }
            }
            return sourceContainers;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.EMPTY_LIST;
        }
    }

    protected static List getSourcePaths(IProject p) {
        IJavaProject javaProj = JemProjectUtilities.getJavaProject(p);
        if (javaProj == null) {
            return null;
        }
        IClasspathEntry[] cp = null;
        try {
            cp = javaProj.getRawClasspath();
        }
        catch (JavaModelException ex) {
            JEMUtilPlugin.getLogger().logError((Throwable)ex);
            return null;
        }
        ArrayList<IPath> sourcePaths = new ArrayList<IPath>();
        int i = 0;
        while (i < cp.length) {
            if (cp[i].getEntryKind() == 3) {
                sourcePaths.add(cp[i].getPath().removeFirstSegments(1));
            }
            ++i;
        }
        return sourcePaths;
    }

    public static List getLibraryContainers(IProject p) {
        try {
            ArrayList<Object> libraryContainers = new ArrayList<Object>();
            List libraryPaths = JemProjectUtilities.getlibraryPaths(p);
            if (libraryPaths != null && !libraryPaths.isEmpty()) {
                int i = 0;
                while (i < libraryPaths.size()) {
                    IPath path = (IPath)libraryPaths.get(i);
                    if (path.isEmpty()) {
                        libraryContainers.add(p);
                    } else {
                        libraryContainers.add(p.getFolder(path));
                    }
                    ++i;
                }
            }
            return libraryContainers;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.EMPTY_LIST;
        }
    }

    protected static List getlibraryPaths(IProject p) {
        IJavaProject javaProj = JemProjectUtilities.getJavaProject(p);
        if (javaProj == null) {
            return null;
        }
        IClasspathEntry[] cp = null;
        try {
            cp = javaProj.getRawClasspath();
        }
        catch (JavaModelException ex) {
            JEMUtilPlugin.getLogger().logError((Throwable)ex);
            return null;
        }
        ArrayList<IPath> libraryPaths = new ArrayList<IPath>();
        int i = 0;
        while (i < cp.length) {
            if (cp[i].getEntryKind() == 1) {
                libraryPaths.add(cp[i].getPath().removeFirstSegments(1));
            }
            ++i;
        }
        return libraryPaths;
    }

    public static IJavaProject getJavaProject(IProject p) {
        if (p != null) {
            try {
                if (p.hasNature("org.eclipse.jdt.core.javanature")) {
                    return JavaCore.create((IProject)p);
                }
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    public static void updateClasspath(IJavaProject javaProject) throws JavaModelException {
        if (javaProject != null) {
            javaProject.setRawClasspath(javaProject.getRawClasspath(), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static IPath getJavaProjectOutputLocation(IProject p) {
        IJavaProject javaProj;
        block4: {
            try {
                javaProj = JemProjectUtilities.getJavaProject(p);
                if (javaProj != null) break block4;
                return null;
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        if (!javaProj.isOpen()) {
            javaProj.open(null);
        }
        return javaProj.readOutputLocation();
    }

    public static IContainer getJavaProjectOutputContainer(IProject p) {
        IPath path = JemProjectUtilities.getJavaProjectOutputLocation(p);
        if (path == null) {
            return null;
        }
        if (path.segmentCount() == 1) {
            return p;
        }
        return p.getFolder(path.removeFirstSegments(1));
    }

    public static IPath getJavaProjectOutputAbsoluteLocation(IProject p) {
        IContainer container = JemProjectUtilities.getJavaProjectOutputContainer(p);
        if (container != null) {
            return container.getLocation();
        }
        return null;
    }

    public static IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    public static List getSourcePackageFragmentRoots(IJavaProject javaProj) throws JavaModelException {
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        IPackageFragmentRoot[] roots = javaProj.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (root.getKind() == 1) {
                result.add(root);
            }
            ++i;
        }
        return result;
    }

    public static void removeFromJavaClassPath(IProject p, IResource res) throws JavaModelException {
        IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)res.getFullPath(), null, null);
        JemProjectUtilities.removeFromJavaClassPath(p, entry);
    }

    public static void removeFromJavaClassPath(IProject p, IPath path) throws JavaModelException {
        IFile f = p.getFile(path);
        JemProjectUtilities.removeFromJavaClassPath(p, (IResource)f);
    }

    public static void removeFromJavaClassPath(IProject p, IClasspathEntry entry) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)p);
        if (javaProject != null && javaProject.exists()) {
            IClasspathEntry[] classpath = javaProject.getRawClasspath();
            javaProject.setRawClasspath(JemProjectUtilities.primRemoveFromJavaClassPath(classpath, entry), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void removeFromJavaClassPath(IProject p, List entries) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)p);
        if (javaProject != null && javaProject.exists()) {
            IClasspathEntry[] classpath = javaProject.getRawClasspath();
            javaProject.setRawClasspath(JemProjectUtilities.primRemoveFromJavaClassPath(classpath, entries), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected static IClasspathEntry[] primRemoveFromJavaClassPath(IClasspathEntry[] classpath, IClasspathEntry entry) throws JavaModelException {
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        boolean didRemove = false;
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry cpEntry = classpath[i];
            if (!entry.getPath().equals((Object)classpath[i].getPath())) {
                result.add(cpEntry);
            } else {
                didRemove = true;
            }
            ++i;
        }
        if (!didRemove) {
            return classpath;
        }
        return result.toArray(new IClasspathEntry[result.size()]);
    }

    protected static IClasspathEntry[] primRemoveFromJavaClassPath(IClasspathEntry[] classpath, List entries) throws JavaModelException {
        List<IClasspathEntry> arrayList = Arrays.asList(classpath);
        ArrayList<IClasspathEntry> removeable = new ArrayList<IClasspathEntry>(arrayList);
        boolean didRemove = false;
        int size = entries.size();
        int i = 0;
        while (i < size) {
            IClasspathEntry entry = (IClasspathEntry)entries.get(i);
            int j = 0;
            while (j < classpath.length) {
                IClasspathEntry cpEntry = classpath[j];
                if (entry.getPath().equals((Object)classpath[j].getPath()) && removeable.remove(cpEntry)) {
                    didRemove = true;
                }
                ++j;
            }
            ++i;
        }
        if (!didRemove) {
            return classpath;
        }
        return removeable.toArray(new IClasspathEntry[removeable.size()]);
    }

    public static URL[] getClasspathAsURLArray(IJavaProject javaProject) {
        if (javaProject == null) {
            return null;
        }
        HashSet visited = new HashSet();
        ArrayList urls = new ArrayList(20);
        JemProjectUtilities.collectClasspathURLs(javaProject, urls, visited, true);
        URL[] result = new URL[urls.size()];
        urls.toArray(result);
        return result;
    }

    private static void collectClasspathURLs(IJavaProject javaProject, List urls, Set visited, boolean isFirstProject) {
        if (visited.contains(javaProject)) {
            return;
        }
        visited.add(javaProject);
        IPath outPath = JemProjectUtilities.getJavaProjectOutputAbsoluteLocation(javaProject.getProject());
        outPath = outPath.addTrailingSeparator();
        URL out = ProjectUtilities.createFileURL((IPath)outPath);
        urls.add(out);
        IClasspathEntry[] entries = null;
        try {
            entries = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            switch (entry.getEntryKind()) {
                case 1: 
                case 4: 
                case 5: {
                    JemProjectUtilities.collectClasspathEntryURL(entry, urls);
                    break;
                }
                case 2: {
                    if (!isFirstProject && !entry.isExported()) break;
                    JemProjectUtilities.collectClasspathURLs(JemProjectUtilities.getJavaProject(entry), urls, visited, false);
                }
            }
            ++i;
        }
    }

    private static void collectClasspathEntryURL(IClasspathEntry entry, List urls) {
        URL url;
        IPath path = entry.getPath();
        if (path.getDevice() == null) {
            if (path.segmentCount() == 1) {
                path = ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment()).getLocation();
            } else {
                IFile jarFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                if (jarFile.exists()) {
                    path = jarFile.getLocation();
                }
            }
        }
        if ((url = ProjectUtilities.createFileURL((IPath)path)) != null) {
            urls.add(url);
        }
    }

    private static IJavaProject getJavaProject(IClasspathEntry entry) {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().segment(0));
        if (proj != null) {
            return JemProjectUtilities.getJavaProject(proj);
        }
        return null;
    }

    public static boolean isBinaryProject(IProject aProject) {
        IJavaProject javaProj = JemProjectUtilities.getJavaProject(aProject);
        if (javaProj == null) {
            return false;
        }
        IClasspathEntry[] entries = null;
        entries = javaProj.readRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 3) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void appendJavaClassPath(IProject p, List appendClasspathEntries) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)p);
        if (javaProject != null && javaProject.exists()) {
            IClasspathEntry[] classpath = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> newPathList = new ArrayList<IClasspathEntry>(classpath.length);
            int i = 0;
            while (i < classpath.length) {
                IClasspathEntry entry = classpath[i];
                if (appendClasspathEntries.indexOf(entry) < 0) {
                    newPathList.add(entry);
                }
                ++i;
            }
            newPathList.addAll(appendClasspathEntries);
            IClasspathEntry[] newClasspath = newPathList.toArray(new IClasspathEntry[newPathList.size()]);
            javaProject.setRawClasspath(newClasspath, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void appendJavaClassPath(IProject p, IClasspathEntry newEntry) throws JavaModelException {
        IJavaProject javaProject = JemProjectUtilities.getJavaProject(p);
        if (javaProject == null) {
            return;
        }
        IClasspathEntry[] classpath = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> newPathList = new ArrayList<IClasspathEntry>(classpath.length);
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            if (Platform.getOS().equals("win32")) {
                if (entry.getPath().toString().equalsIgnoreCase(newEntry.getPath().toString())) return;
                newPathList.add(entry);
            } else {
                if (entry.getPath().equals((Object)newEntry.getPath())) return;
                newPathList.add(entry);
            }
            ++i;
        }
        newPathList.add(newEntry);
        IClasspathEntry[] newClasspath = newPathList.toArray(new IClasspathEntry[newPathList.size()]);
        javaProject.setRawClasspath(newClasspath, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IPath getSourcePathOrFirst(IProject p, String defaultSourceName) {
        IJavaProject javaProj = JemProjectUtilities.getJavaProject(p);
        if (javaProj == null) {
            return null;
        }
        IClasspathEntry[] cp = null;
        try {
            cp = javaProj.getRawClasspath();
        }
        catch (JavaModelException ex) {
            JEMUtilPlugin.getLogger().logError((Throwable)ex);
            return null;
        }
        IClasspathEntry firstSource = null;
        IPath defaultSourcePath = null;
        if (defaultSourceName != null) {
            defaultSourcePath = ProjectUtilities.createPath((IProject)p, (String)defaultSourceName);
        }
        int i = 0;
        while (i < cp.length) {
            if (cp[i].getEntryKind() == 3) {
                if (firstSource == null) {
                    firstSource = cp[i];
                    if (defaultSourcePath == null) break;
                }
                if (cp[i].getPath().equals((Object)defaultSourcePath)) {
                    return defaultSourcePath.removeFirstSegments(1);
                }
            }
            ++i;
        }
        if (firstSource == null) {
            return null;
        }
        if (firstSource.getPath().segment(0).equals(p.getName())) {
            return firstSource.getPath().removeFirstSegments(1);
        }
        return null;
    }

    public static void forceClasspathReload(IProject project) throws JavaModelException {
        IPath output;
        IClasspathEntry[] entries;
        IJavaProject javaProj = JemProjectUtilities.getJavaProject(project);
        if (javaProj != null && (entries = javaProj.readRawClasspath()) != null && (output = javaProj.readOutputLocation()) != null) {
            javaProj.setRawClasspath(entries, output, null);
        }
    }

    public static List getLocalJARPathsFromClasspath(IProject proj) {
        IJavaProject javaProj = JemProjectUtilities.getJavaProject(proj);
        if (javaProj == null) {
            return null;
        }
        IPath projectPath = proj.getFullPath();
        ArrayList<IPath> result = new ArrayList<IPath>();
        IClasspathEntry[] entries = javaProj.readRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IPath path;
            int segments;
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 1 && (segments = (path = entry.getPath()).matchingFirstSegments(projectPath)) > 0) {
                result.add(path.removeFirstSegments(segments));
            }
            ++i;
        }
        return result;
    }

    public static IContainer getSourceFolderOrFirst(IProject p, String defaultSourceName) {
        IPath sourcePath;
        block4: {
            try {
                sourcePath = JemProjectUtilities.getSourcePathOrFirst(p, defaultSourceName);
                if (sourcePath != null) break block4;
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        if (sourcePath.isEmpty()) {
            return p;
        }
        return p.getFolder(sourcePath);
    }

    public static List getSourceFolders(IProject p) {
        try {
            ArrayList<IFolder> sourceFolders = new ArrayList<IFolder>();
            List sourcePaths = JemProjectUtilities.getSourcePaths(p);
            if (sourcePaths != null && !sourcePaths.isEmpty()) {
                int i = 0;
                while (i < sourcePaths.size()) {
                    IPath path = (IPath)sourcePaths.get(i);
                    if (!path.isEmpty()) {
                        sourceFolders.add(p.getFolder(path));
                    }
                    ++i;
                }
            }
            return sourceFolders;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.EMPTY_LIST;
        }
    }
}

