/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.common.ResourceSearchScope;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.StringMatcher;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.SaveDialogBoundsSettingsDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.E;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractIconDialogWithHardcodedScope
extends SaveDialogBoundsSettingsDialog {
    private TableViewer viewer;
    private final IProject project;
    private final Map<IFile, Image> icons = Collections.synchronizedMap(new HashMap());
    private ResourceSearchScope searchScope = ResourceSearchScope.PROJECT;
    protected Messages Messages;
    private Text textSearch;
    private String value;
    private final IEclipseContext context;

    public AbstractIconDialogWithHardcodedScope(Shell parentShell, IEclipseContext context) {
        super(parentShell);
        this.context = context;
        this.project = (IProject)context.get(IProject.class);
        this.Messages = (Messages)context.get(Messages.class);
    }

    protected IEclipseContext getContext() {
        return this.context;
    }

    protected abstract String getShellTitle();

    protected abstract String getDialogTitle();

    protected abstract String getDialogMessage();

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        this.getShell().setText(this.getShellTitle());
        this.setTitle(this.getDialogTitle());
        this.setMessage(this.getDialogMessage());
        String bundleFilter = (String)this.context.get("bundle");
        if (E.notEmpty(bundleFilter)) {
            this.setMessage("Filtering by bundle " + bundleFilter);
        }
        Composite container = new Composite(comp, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(2, false));
        Composite compOptions = new Composite(container, 0);
        compOptions.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        compOptions.setLayout((Layout)new RowLayout());
        if (E.isEmpty(bundleFilter)) {
            Button btnProject = new Button(compOptions, 16);
            btnProject.setText(this.Messages.AbstractIconDialogWithHardcodedScope_Project);
            btnProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractIconDialogWithHardcodedScope.this.searchScope = ResourceSearchScope.PROJECT;
                    AbstractIconDialogWithHardcodedScope.this.textSearch.notifyListeners(24, new Event());
                }
            });
            btnProject.setSelection(true);
            Button btnWorkspace = new Button(compOptions, 16);
            btnWorkspace.setText(this.Messages.AbstractIconDialogWithHardcodedScope_Workspace);
            btnWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractIconDialogWithHardcodedScope.this.searchScope = ResourceSearchScope.WORKSPACE;
                    AbstractIconDialogWithHardcodedScope.this.textSearch.notifyListeners(24, new Event());
                }
            });
            btnWorkspace.setSelection(this.searchScope == ResourceSearchScope.WORKSPACE);
            btnProject.setSelection(this.searchScope == ResourceSearchScope.PROJECT);
        } else {
            this.searchScope = ResourceSearchScope.WORKSPACE;
        }
        Label l = new Label(container, 0);
        l.setText(this.Messages.AbstractIconDialog_IconName);
        this.textSearch = new Text(container, 2688);
        this.textSearch.setLayoutData((Object)new GridData(768));
        new Label(container, 0);
        this.viewer = new TableViewer(container, 67584);
        GridData gd = new GridData(1808);
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                String bundle;
                IFile file = (IFile)cell.getElement();
                StyledString styledString = new StyledString(file.getProjectRelativePath().toString(), null);
                Image img = AbstractIconDialogWithHardcodedScope.this.icons.get(file);
                if (img == null) {
                    try {
                        Throwable throwable = null;
                        Object var6_8 = null;
                        try (InputStream in = file.getContents();){
                            img = new Image((Device)cell.getControl().getDisplay(), in);
                            AbstractIconDialogWithHardcodedScope.this.icons.put(file, img);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException | CoreException e) {
                        e.printStackTrace();
                    }
                }
                if ((bundle = AbstractIconDialogWithHardcodedScope.this.getBundle(file)) != null) {
                    styledString.append(" - " + bundle, StyledString.DECORATIONS_STYLER);
                }
                cell.setImage(img);
                cell.setText(styledString.getString());
                cell.setStyleRanges(styledString.getStyleRanges());
            }
        });
        final WritableList list = new WritableList();
        this.viewer.setInput((Object)list);
        this.viewer.addDoubleClickListener(event -> this.okPressed());
        this.textSearch.addModifyListener(new ModifyListener(){
            private IconMatchCallback callback;
            private final Timer timer = new Timer(true);
            private TimerTask task;

            public void modifyText(ModifyEvent e) {
                if (this.callback != null) {
                    this.callback.cancel = true;
                }
                if (this.task != null) {
                    this.task.cancel();
                }
                list.clear();
                AbstractIconDialogWithHardcodedScope.this.clearImages();
                this.callback = new IconMatchCallback((IObservableList<IFile>)list);
                this.task = new SearchThread(this.callback, AbstractIconDialogWithHardcodedScope.this.textSearch.getText(), AbstractIconDialogWithHardcodedScope.this.project, AbstractIconDialogWithHardcodedScope.this.context, AbstractIconDialogWithHardcodedScope.this.searchScope);
                this.timer.schedule(this.task, 500L);
            }
        });
        this.getShell().addDisposeListener(e -> this.clearImages());
        this.textSearch.notifyListeners(24, new Event());
        return comp;
    }

    private void clearImages() {
        for (Image img : this.icons.values()) {
            img.dispose();
        }
        this.icons.clear();
    }

    protected void okPressed() {
        this.value = null;
        IStructuredSelection s = (IStructuredSelection)this.viewer.getSelection();
        if (!s.isEmpty()) {
            IFile file = (IFile)s.getFirstElement();
            String bundle = this.getBundle(file);
            this.value = "platform:/plugin/" + bundle + "/" + file.getProjectRelativePath().toString();
        }
        super.okPressed();
    }

    /*
     * Exception decompiling
     */
    private String getBundle(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 11[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getValue() {
        return this.value;
    }

    private static class IconMatchCallback {
        private volatile boolean cancel;
        private final IObservableList<IFile> list;

        private IconMatchCallback(IObservableList<IFile> list) {
            this.list = list;
        }

        public void match(IFile file) {
            if (!this.cancel) {
                this.list.getRealm().exec(() -> {
                    boolean bl = this.list.add((Object)file);
                });
            }
        }
    }

    private static class SearchThread
    extends TimerTask {
        private final IconMatchCallback callback;
        private final IProject project;
        private final StringMatcher matcherGif;
        private final StringMatcher matcherJpg;
        private final StringMatcher matcherPng;
        private final IEclipseContext context;
        private final ResourceSearchScope searchScope;

        public SearchThread(IconMatchCallback callback, String pattern, IProject project, IEclipseContext context, ResourceSearchScope searchScope) {
            this.context = context;
            this.matcherGif = new StringMatcher("*" + pattern + "*.gif", true, false);
            this.matcherJpg = new StringMatcher("*" + pattern + "*.jpg", true, false);
            this.matcherPng = new StringMatcher("*" + pattern + "*.png", true, false);
            this.callback = callback;
            this.project = project;
            this.searchScope = searchScope;
        }

        @Override
        public void run() {
            List<IProject> projects = switch (this.searchScope) {
                case ResourceSearchScope.WORKSPACE -> Arrays.asList(this.project.getWorkspace().getRoot().getProjects());
                default -> Arrays.asList(this.project);
            };
            try {
                for (IProject project : projects) {
                    IFile iFile = project.getFile("/META-INF/MANIFEST.MF");
                    if (!iFile.exists()) continue;
                    String bundle = (String)this.context.get("bundle");
                    if (E.notEmpty(bundle)) {
                        try {
                            Throwable throwable = null;
                            Object var7_10 = null;
                            try (InputStream inputStream = iFile.getContents();){
                                Properties props = new Properties();
                                props.load(inputStream);
                                String name = props.getProperty("Bundle-SymbolicName");
                                String[] parts = name.split(";");
                                if (!parts[0].equals(bundle)) {
                                    continue;
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    project.accept(resource -> {
                        String path;
                        if (this.callback.cancel) {
                            return false;
                        }
                        if (resource.getType() == 2 || resource.getType() == 4) {
                            return true;
                        }
                        if (resource.getType() == 1 && !resource.isLinked() && (this.matcherGif.match(path = resource.getProjectRelativePath().toString()) || this.matcherPng.match(path) || this.matcherJpg.match(path))) {
                            this.callback.match((IFile)resource);
                        }
                        return false;
                    });
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

