/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.util;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.BaseQuery;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionVariable;
import org.eclipse.datatools.connectivity.oda.spec.ValueExpression;
import org.eclipse.datatools.connectivity.oda.spec.manifest.VariableRestrictions;
import org.eclipse.datatools.connectivity.oda.spec.result.AggregateExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.CustomAggregate;
import org.eclipse.datatools.connectivity.oda.spec.result.FilterExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.ResultProjection;
import org.eclipse.datatools.connectivity.oda.spec.result.ResultSetSpecification;
import org.eclipse.datatools.connectivity.oda.spec.result.SortSpecification;
import org.eclipse.datatools.connectivity.oda.spec.result.filter.AtomicExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.filter.CompositeExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.filter.CustomExpression;
import org.eclipse.datatools.connectivity.oda.spec.valueexpr.CustomFunction;

public class ValidatorUtil {
    private static final String AT_SYMBOL = "@";

    public static void validateCustomExprType(CustomExpression customExpr, Class<?> expectedExprClass) throws OdaException {
        if (expectedExprClass.isInstance(customExpr)) {
            return;
        }
        throw ValidatorUtil.newFilterExprException(Messages.bind((String)Messages.querySpec_UNEXPECTED_CUSTOM_EXPR_TYPE, (Object)customExpr.getName(), (Object)expectedExprClass.getName()), customExpr);
    }

    public static void validateCustomExprType(CustomAggregate customExpr, Class<?> expectedExprClass) throws OdaException {
        if (expectedExprClass.isInstance(customExpr)) {
            return;
        }
        throw ValidatorUtil.newAggregateException(Messages.bind((String)Messages.querySpec_UNEXPECTED_AGGR_EXPR_TYPE, (Object)customExpr.getName(), (Object)expectedExprClass.getName()), customExpr);
    }

    public static void validateCustomExprType(CustomFunction customExpr, Class<?> expectedExprClass) throws OdaException {
        if (expectedExprClass.isInstance(customExpr)) {
            return;
        }
        throw ValidatorUtil.newValueExprException(Messages.bind((String)Messages.querySpec_UNEXPECTED_FUNC_EXPR_TYPE, (Object)customExpr.getName(), (Object)expectedExprClass.getName()), customExpr);
    }

    public static void validateAllCustomExprType(FilterExpression expr, Class<?> expectedExprClass) throws OdaException {
        if (expr instanceof CustomExpression) {
            ValidatorUtil.validateCustomExprType((CustomExpression)expr, expectedExprClass);
            return;
        }
        if (expr instanceof CompositeExpression) {
            CompositeExpression parentExpr = (CompositeExpression)expr;
            FilterExpression[] childrenExpr = parentExpr.getChildren();
            int i = 0;
            while (i < childrenExpr.length) {
                ValidatorUtil.validateAllCustomExprType(childrenExpr[i], expectedExprClass);
                ++i;
            }
            return;
        }
    }

    public static void validateCustomExprExtension(CustomExpression customExpr, String expectedExtensionId) throws OdaException {
        if (!expectedExtensionId.equals(customExpr.getDeclaringExtensionId())) {
            throw ValidatorUtil.newFilterExprException(Messages.bind((String)Messages.querySpec_UNEXPECTED_CUSTOM_EXPR_EXTENSION, (Object)customExpr.getName()), customExpr);
        }
    }

    public static void validateCustomExprExtension(CustomAggregate customAggrExpr, String expectedExtensionId) throws OdaException {
        if (!expectedExtensionId.equals(customAggrExpr.getDeclaringExtensionId())) {
            throw ValidatorUtil.newAggregateException(Messages.bind((String)Messages.querySpec_UNEXPECTED_AGGR_EXPR_EXTENSION, (Object)customAggrExpr.getName()), customAggrExpr);
        }
    }

    public static void validateCustomExprExtension(CustomFunction customFuncExpr, String expectedExtensionId) throws OdaException {
        if (!expectedExtensionId.equals(customFuncExpr.getDeclaringExtensionId())) {
            throw ValidatorUtil.newValueExprException(Messages.bind((String)Messages.querySpec_UNEXPECTED_FUNC_EXPR_EXTENSION, (Object)customFuncExpr.getName()), customFuncExpr);
        }
    }

    public static void validateHasExprVariable(AtomicExpression expr) throws OdaException {
        if (expr.getVariable() == null) {
            throw ValidatorUtil.newFilterExprException(Messages.bind((String)Messages.querySpec_MISSING_EXPR_VARIABLE, (Object)expr.getName()), expr);
        }
    }

    public static void validateSupportedVariableTypes(AtomicExpression expr, ExpressionVariable.VariableType[] supportedVarTypes) throws OdaException {
        ExpressionVariable exprVar = expr.getVariable();
        int i = 0;
        while (i < supportedVarTypes.length) {
            if (exprVar.getType() == supportedVarTypes[i]) {
                return;
            }
            ++i;
        }
        throw ValidatorUtil.newFilterExprException(Messages.bind((String)Messages.querySpec_UNEXPECTED_EXPR_VARIABLE_TYPE, (Object)exprVar), expr);
    }

    public static void validateSupportedVariableTypes(CustomAggregate expr, ExpressionVariable.VariableType[] supportedVarTypes) throws OdaException {
        if (expr.getVariables().isEmpty()) {
            return;
        }
        for (ExpressionVariable exprVar : expr.getVariables()) {
            boolean isSupported = false;
            int i = 0;
            while (i < supportedVarTypes.length) {
                if (exprVar.getType() == supportedVarTypes[i]) {
                    isSupported = true;
                    break;
                }
                ++i;
            }
            if (isSupported) continue;
            throw ValidatorUtil.newAggregateException(Messages.bind((String)Messages.querySpec_UNEXPECTED_EXPR_VARIABLE_TYPE, (Object)exprVar), expr);
        }
    }

    public static void validateSupportedVariableDataTypes(ExpressionVariable exprVar, VariableRestrictions varRestrictions, String odaDataSourceId, String dataSetType) throws OdaException {
        ValidatorUtil.validateSupportedVariableDataTypes(exprVar.getValueExpression(), varRestrictions, odaDataSourceId, dataSetType);
    }

    public static void validateSupportedVariableDataTypes(ValueExpression valueExpr, VariableRestrictions varRestrictions, String odaDataSourceId, String dataSetType) throws OdaException {
        if (valueExpr.getVariableType() == ExpressionVariable.VariableType.INSTANCE_OF) {
            return;
        }
        Integer odaDataType = valueExpr.getOdaDataType();
        if (odaDataType == null || odaDataType == ValueExpression.UNKNOWN_ODA_DATA_TYPE) {
            return;
        }
        int[] restrictedOdaDataTypes = null;
        boolean hasRestrictedOdaDataTypes = false;
        boolean hasRestrictedInstanceTypes = false;
        switch (valueExpr.getVariableType()) {
            case RESULT_SET_COLUMN: {
                restrictedOdaDataTypes = varRestrictions.getResultColumnRestrictedOdaDataTypes();
                if (restrictedOdaDataTypes.length <= 0) break;
                hasRestrictedOdaDataTypes = true;
                break;
            }
            case QUERY_EXPRESSION: {
                restrictedOdaDataTypes = varRestrictions.getQueryExpressionRestrictedOdaDataTypes();
                if (restrictedOdaDataTypes.length <= 0) break;
                hasRestrictedOdaDataTypes = true;
                break;
            }
        }
        if (!hasRestrictedOdaDataTypes && !hasRestrictedInstanceTypes) {
            return;
        }
        boolean meetsRestriction = false;
        if (hasRestrictedOdaDataTypes) {
            int i = 0;
            while (i < restrictedOdaDataTypes.length) {
                if (restrictedOdaDataTypes[i] == odaDataType) {
                    meetsRestriction = true;
                    break;
                }
                ++i;
            }
            if (!meetsRestriction) {
                throw new OdaException(Messages.bind((String)Messages.querySpec_NONSUPPORTED_VAR_DATA_TYPE, (Object)odaDataType, (Object)valueExpr.getName()));
            }
        }
    }

    public static void validateHasNoNullOrderingSpec(SortSpecification sortSpec) throws OdaException {
        if (sortSpec == null || sortSpec.getSortKeyCount() == 0) {
            return;
        }
        int numSortKeys = sortSpec.getSortKeyCount();
        int i = 1;
        while (i <= numSortKeys) {
            int nullOrderingType = sortSpec.getNullOrdering(i);
            if (nullOrderingType != 0) {
                throw ValidatorUtil.newSortSpecException(Messages.querySpec_NONSUPPORTED_NULL_ORDERING, sortSpec);
            }
            ++i;
        }
    }

    private static OdaException newOdaException(String message, String causeIdentifier, OdaException chainedEx) {
        if (causeIdentifier == null) {
            return chainedEx != null ? chainedEx : new OdaException(message);
        }
        OdaException rootEx = ValidatorUtil.newOdaException(message, causeIdentifier);
        ValidatorUtil.addException(rootEx, chainedEx);
        return rootEx;
    }

    public static OdaException newOdaException(String message, String causeIdentifier) {
        OdaException odaEx = new OdaException(message);
        odaEx.initCause(new IllegalArgumentException(causeIdentifier));
        return odaEx;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isCauseOfException(OdaException odaEx, String causeIdentifier) {
        if (causeIdentifier != null) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            cause = odaEx.getCause();
            if (cause instanceof IllegalArgumentException && causeIdentifier.equals(cause.getMessage())) {
                return true;
            }
            if (cause instanceof OdaException && ValidatorUtil.isCauseOfException((OdaException)cause, causeIdentifier)) {
                return true;
            }
            odaEx = odaEx.getNextException();
lbl9:
            // 2 sources

            ** while (odaEx != null)
        }
lbl10:
        // 1 sources

        return false;
    }

    public static OdaException addException(OdaException rootEx, OdaException newEx) {
        if (rootEx == null) {
            return newEx;
        }
        if (newEx != null) {
            rootEx.setNextException(newEx);
        }
        return rootEx;
    }

    public static OdaException newFilterExprException(FilterExpression invalidFilterExpr, OdaException driverEx) {
        return ValidatorUtil.newFilterExprException(Messages.querySpec_INVALID_FILTER_EXPR, invalidFilterExpr, driverEx);
    }

    public static OdaException newFilterExprException(String message, FilterExpression invalidFilterExpr) {
        return ValidatorUtil.newFilterExprException(message, invalidFilterExpr, null);
    }

    private static OdaException newFilterExprException(String message, FilterExpression invalidFilterExpr, OdaException chainedEx) {
        if (chainedEx != null && ValidatorUtil.isInvalidFilterExpression(invalidFilterExpr, chainedEx)) {
            return chainedEx;
        }
        return ValidatorUtil.newOdaException(message, ValidatorUtil.getInstanceId(invalidFilterExpr), chainedEx);
    }

    public static boolean isInvalidFilterExpression(FilterExpression filterExpr, OdaException rootEx) {
        if (filterExpr == null) {
            return true;
        }
        return ValidatorUtil.isCauseOfException(rootEx, ValidatorUtil.getInstanceId(filterExpr));
    }

    public static OdaException newAggregateException(AggregateExpression invalidAggrExpr, OdaException driverEx) {
        return ValidatorUtil.newAggregateException(Messages.querySpec_INVALID_AGGR_EXPR, invalidAggrExpr, driverEx);
    }

    public static OdaException newAggregateException(String message, AggregateExpression invalidAggrExpr) {
        return ValidatorUtil.newAggregateException(message, invalidAggrExpr, null);
    }

    private static OdaException newAggregateException(String message, AggregateExpression invalidAggrExpr, OdaException chainedEx) {
        if (chainedEx != null && ValidatorUtil.isInvalidAggregateExpression(invalidAggrExpr, chainedEx)) {
            return chainedEx;
        }
        return ValidatorUtil.newOdaException(message, ValidatorUtil.getInstanceId(invalidAggrExpr), chainedEx);
    }

    public static boolean isInvalidAggregateExpression(AggregateExpression aggrExpr, OdaException rootEx) {
        if (aggrExpr == null) {
            return true;
        }
        return ValidatorUtil.isCauseOfException(rootEx, ValidatorUtil.getInstanceId(aggrExpr));
    }

    public static OdaException newValueExprException(ValueExpression invalidValueExpr, OdaException driverEx) {
        return ValidatorUtil.newValueExprException(Messages.querySpec_INVALID_VALUE_EXPR, invalidValueExpr, driverEx);
    }

    public static OdaException newValueExprException(String message, ValueExpression invalidValueExpr) {
        return ValidatorUtil.newValueExprException(message, invalidValueExpr, null);
    }

    private static OdaException newValueExprException(String message, ValueExpression invalidValueExpr, OdaException chainedEx) {
        if (chainedEx != null && ValidatorUtil.isInvalidValueExpression(invalidValueExpr, chainedEx)) {
            return chainedEx;
        }
        return ValidatorUtil.newOdaException(message, ValidatorUtil.getInstanceId(invalidValueExpr), chainedEx);
    }

    public static boolean isInvalidValueExpression(ValueExpression valueExpr, OdaException rootEx) {
        if (valueExpr == null) {
            return true;
        }
        return ValidatorUtil.isCauseOfException(rootEx, ValidatorUtil.getInstanceId(valueExpr));
    }

    public static OdaException newResultProjectionException(ResultProjection resultProj, OdaException driverEx) {
        return ValidatorUtil.newResultProjectionException(Messages.querySpec_INVALID_RESULT_PROJ, resultProj, driverEx);
    }

    public static OdaException newResultProjectionException(String message, ResultProjection resultProj) {
        return ValidatorUtil.newResultProjectionException(message, resultProj, null);
    }

    private static OdaException newResultProjectionException(String message, ResultProjection resultProj, OdaException chainedEx) {
        if (chainedEx != null && ValidatorUtil.isInvalidResultProjection(resultProj, chainedEx)) {
            return chainedEx;
        }
        return ValidatorUtil.newOdaException(message, ValidatorUtil.getInstanceId(resultProj), chainedEx);
    }

    public static boolean isInvalidResultProjection(ResultProjection resultProj, OdaException rootEx) {
        if (resultProj == null) {
            return true;
        }
        return ValidatorUtil.isCauseOfException(rootEx, ValidatorUtil.getInstanceId(resultProj));
    }

    public static OdaException newSortKeyException(int sortKeySequenceOrder, OdaException driverEx) {
        return ValidatorUtil.newSortKeyException(Messages.querySpec_INVALID_SORT_KEY, sortKeySequenceOrder, driverEx);
    }

    public static OdaException newSortKeyException(String message, int sortKeySequenceOrder) {
        return ValidatorUtil.newSortKeyException(message, sortKeySequenceOrder, null);
    }

    private static OdaException newSortKeyException(String message, int sortKeySequenceOrder, OdaException chainedEx) {
        if (chainedEx != null && ValidatorUtil.isInvalidSortKey(sortKeySequenceOrder, chainedEx)) {
            return chainedEx;
        }
        return ValidatorUtil.newOdaException(message, String.valueOf(sortKeySequenceOrder), chainedEx);
    }

    public static boolean isInvalidSortKey(int sortKeySequenceOrder, OdaException rootEx) {
        if (sortKeySequenceOrder == 0) {
            return true;
        }
        String sortKeyId = String.valueOf(sortKeySequenceOrder);
        return ValidatorUtil.isCauseOfException(rootEx, sortKeyId);
    }

    public static OdaException newSortSpecException(SortSpecification sortSpec, OdaException driverEx) {
        return ValidatorUtil.newSortSpecException(Messages.querySpec_INVALID_SORT_SPEC, sortSpec, driverEx);
    }

    public static OdaException newSortSpecException(String message, SortSpecification sortSpec) {
        return ValidatorUtil.newSortSpecException(message, sortSpec, null);
    }

    private static OdaException newSortSpecException(String message, SortSpecification sortSpec, OdaException chainedEx) {
        if (chainedEx != null && ValidatorUtil.isInvalidSortSpec(sortSpec, chainedEx)) {
            return chainedEx;
        }
        return ValidatorUtil.newOdaException(message, ValidatorUtil.getInstanceId(sortSpec), chainedEx);
    }

    public static boolean isInvalidSortSpec(SortSpecification sortSpec, OdaException rootEx) {
        if (sortSpec == null) {
            return true;
        }
        return ValidatorUtil.isCauseOfException(rootEx, ValidatorUtil.getInstanceId(sortSpec));
    }

    public static OdaException newResultSetSpecException(String message, ResultSetSpecification resultSetSpec, OdaException chainedEx) {
        if (chainedEx != null && ValidatorUtil.isInvalidResultSetSpec(resultSetSpec, chainedEx)) {
            return chainedEx;
        }
        return ValidatorUtil.newOdaException(message, ValidatorUtil.getInstanceId(resultSetSpec), chainedEx);
    }

    public static boolean isInvalidResultSetSpec(ResultSetSpecification resultSetSpec, OdaException rootEx) {
        if (resultSetSpec == null) {
            return true;
        }
        return ValidatorUtil.isCauseOfException(rootEx, ValidatorUtil.getInstanceId(resultSetSpec));
    }

    public static OdaException newBaseQueryException(BaseQuery invalidBaseQuery, OdaException driverEx) {
        return ValidatorUtil.newBaseQueryException(Messages.querySpec_INVALID_BASE_QUERY, invalidBaseQuery, driverEx);
    }

    public static OdaException newBaseQueryException(String message, BaseQuery invalidBaseQuery) {
        return ValidatorUtil.newBaseQueryException(message, invalidBaseQuery, null);
    }

    private static OdaException newBaseQueryException(String message, BaseQuery invalidBaseQuery, OdaException chainedEx) {
        if (chainedEx != null && ValidatorUtil.isInvalidBaseQuery(invalidBaseQuery, chainedEx)) {
            return chainedEx;
        }
        return ValidatorUtil.newOdaException(message, ValidatorUtil.getInstanceId(invalidBaseQuery), chainedEx);
    }

    public static boolean isInvalidBaseQuery(BaseQuery baseQuery, OdaException rootEx) {
        if (baseQuery == null) {
            return true;
        }
        return ValidatorUtil.isCauseOfException(rootEx, ValidatorUtil.getInstanceId(baseQuery));
    }

    private static String getInstanceId(FilterExpression filterExpr) {
        if (filterExpr == null) {
            return null;
        }
        return String.valueOf(filterExpr.getQualifiedId()) + AT_SYMBOL + Integer.toHexString(filterExpr.hashCode());
    }

    private static String getInstanceId(AggregateExpression aggrExpr) {
        if (aggrExpr == null) {
            return null;
        }
        return String.valueOf(aggrExpr.getName()) + AT_SYMBOL + Integer.toHexString(aggrExpr.hashCode());
    }

    private static String getInstanceId(ValueExpression valueExpr) {
        if (valueExpr == null) {
            return null;
        }
        return String.valueOf(valueExpr.getName()) + AT_SYMBOL + Integer.toHexString(valueExpr.hashCode());
    }

    private static String getInstanceId(ResultProjection resultProj) {
        if (resultProj == null) {
            return null;
        }
        return String.valueOf(resultProj.getClass().getSimpleName()) + AT_SYMBOL + Integer.toHexString(resultProj.hashCode());
    }

    private static String getInstanceId(SortSpecification sortSpec) {
        if (sortSpec == null) {
            return null;
        }
        return String.valueOf(sortSpec.getClass().getSimpleName()) + AT_SYMBOL + Integer.toHexString(sortSpec.hashCode());
    }

    private static String getInstanceId(ResultSetSpecification resultSetSpec) {
        if (resultSetSpec == null) {
            return null;
        }
        return String.valueOf(resultSetSpec.getClass().getSimpleName()) + AT_SYMBOL + Integer.toHexString(resultSetSpec.hashCode());
    }

    private static String getInstanceId(BaseQuery baseQuery) {
        if (baseQuery == null) {
            return null;
        }
        return String.valueOf(baseQuery.getName()) + AT_SYMBOL + Integer.toHexString(baseQuery.hashCode());
    }
}

