/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ClassSourceGenerator;
import org.burningwave.core.classes.SourceGenerator;
import org.burningwave.core.classes.TypeDeclarationSourceGenerator;
import org.burningwave.core.io.FileSystemItem;

public class UnitSourceGenerator
extends SourceGenerator.Abst {
    private static final long serialVersionUID = -954913599817628229L;
    private String packageName;
    private Collection<String> imports;
    private Collection<ClassSourceGenerator> classes;

    private UnitSourceGenerator(String packageName) {
        this.packageName = packageName;
    }

    public static UnitSourceGenerator create(String packageName) {
        return new UnitSourceGenerator(packageName);
    }

    public UnitSourceGenerator addImport(String ... imports) {
        Optional.ofNullable(this.imports).orElseGet(() -> {
            this.imports = new ArrayList<String>();
            return this.imports;
        });
        for (String imprt : imports) {
            this.imports.add(this.normalize(imprt));
        }
        return this;
    }

    public UnitSourceGenerator addStaticImport(Class<?> cls, String ... innerElements) {
        for (String innerElement : innerElements) {
            this.addStaticImport(this.normalize(cls.getName()) + "." + innerElement);
        }
        return this;
    }

    public UnitSourceGenerator addStaticImport(String ... imports) {
        Optional.ofNullable(this.imports).orElseGet(() -> {
            this.imports = new ArrayList<String>();
            return this.imports;
        });
        for (String imprt : imports) {
            this.imports.add("static " + this.normalize(imprt));
        }
        return this;
    }

    public UnitSourceGenerator addImport(Class<?> ... classes) {
        for (Class<?> cls : classes) {
            if (Modifier.isPublic(cls.getModifiers())) {
                this.addImport(this.normalize(cls.getName()));
                continue;
            }
            StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not import {} because its modifier is not public", cls.getName());
        }
        return this;
    }

    public UnitSourceGenerator addClass(ClassSourceGenerator ... clazzes) {
        Optional.ofNullable(this.classes).orElseGet(() -> {
            this.classes = new ArrayList<ClassSourceGenerator>();
            return this.classes;
        });
        for (ClassSourceGenerator cls : clazzes) {
            this.classes.add(cls);
        }
        return this;
    }

    private Set<String> getImports() {
        ArrayList imports = new ArrayList();
        Optional.ofNullable(this.imports).ifPresent(imprts -> imprts.forEach(imprt -> imports.add("import " + this.normalize(imprt.replace("$", ".")) + ";")));
        this.getTypeDeclarations().forEach(typeDeclaration -> {
            Boolean isPublic = typeDeclaration.isPublic();
            String className = typeDeclaration.getName();
            if (isPublic == null || isPublic.booleanValue()) {
                boolean useFullyQualifiedName = typeDeclaration.useFullyQualifiedName();
                if (!useFullyQualifiedName) {
                    Optional.ofNullable(className).ifPresent(clsName -> imports.add("import " + this.normalize(clsName.replace("$", ".")) + ";"));
                }
            } else {
                StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not import {} because its modifier is not public", className);
            }
        });
        Collections.sort(imports);
        return new LinkedHashSet<String>(imports);
    }

    Collection<TypeDeclarationSourceGenerator> getTypeDeclarations() {
        ArrayList<TypeDeclarationSourceGenerator> types = new ArrayList<TypeDeclarationSourceGenerator>();
        Optional.ofNullable(this.classes).ifPresent(clazzes -> clazzes.forEach(cls -> types.addAll(cls.getTypeDeclarations())));
        return types;
    }

    Map<String, ClassSourceGenerator> getAllClasses() {
        HashMap<String, ClassSourceGenerator> allClasses = new HashMap<String, ClassSourceGenerator>();
        Optional.ofNullable(this.classes).ifPresent(classes -> classes.forEach(cls -> {
            allClasses.put(this.packageName + "." + cls.getTypeDeclaration().getSimpleName(), (ClassSourceGenerator)cls);
            cls.getAllInnerClasses().entrySet().forEach(innerClass -> allClasses.put(this.packageName + "." + (String)innerClass.getKey(), (ClassSourceGenerator)innerClass.getValue()));
        }));
        return allClasses;
    }

    UnitSourceGenerator setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    String getPackageName() {
        return this.packageName;
    }

    ClassSourceGenerator getClass(String className) {
        return this.getAllClasses().get(className);
    }

    private String normalize(String imprt) {
        if (imprt.contains("[")) {
            imprt = imprt.replace("[L", "").replace("[", "").replace("]", "").replace(";", "");
        }
        return imprt;
    }

    @Override
    public String make() {
        return this.getOrEmpty(Arrays.asList("package " + this.packageName + ";", "\n", this.getImports(), "\n", this.getOrEmpty(this.classes, "\n\n")), "\n");
    }

    public FileSystemItem storeToClassPath(String classPathFolder) {
        classPathFolder = StaticComponentContainer.Paths.clean(classPathFolder);
        String classRelativePath = this.packageName != null ? this.packageName.replace(".", "/") : "";
        String fileName = null;
        for (ClassSourceGenerator cSG : this.classes) {
            if (fileName != null && (cSG.getModifier() == null || !Modifier.isPublic(cSG.getModifier()))) continue;
            fileName = cSG.getSimpleName() + ".java";
            if (cSG.getModifier() == null || !Modifier.isPublic(cSG.getModifier())) continue;
            break;
        }
        classRelativePath = fileName != null ? classRelativePath + "/" + fileName : classRelativePath + "/" + UUID.randomUUID().toString() + ".java";
        return StaticComponentContainer.Streams.store(classPathFolder + "/" + classRelativePath, this.make().getBytes());
    }
}

