/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.ImplicitObjectAssociation;
import org.eclipse.wb.internal.core.model.generation.statement.PureFlatStatementGenerator;
import org.eclipse.wb.internal.core.model.variable.AbstractNoNameVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;

public abstract class AbstractImplicitVariableSupport
extends AbstractNoNameVariableSupport {
    public AbstractImplicitVariableSupport(JavaInfo javaInfo) {
        super(javaInfo);
    }

    @Override
    public boolean hasExpression(NodeTarget target) {
        return true;
    }

    @Override
    public final String getReferenceExpression(NodeTarget target) throws Exception {
        VariableSupport localVariable = this.ensureLocalVariable();
        this.updateTarget_ifWasAfterParentStatement(target);
        return localVariable.getReferenceExpression(target);
    }

    @Override
    public final String getAccessExpression(NodeTarget target) throws Exception {
        return this.getReferenceExpression(target) + ".";
    }

    @Override
    public final StatementTarget getStatementTarget() throws Exception {
        return this.ensureLocalVariable().getStatementTarget();
    }

    protected abstract JavaInfo getParent();

    private VariableSupport ensureLocalVariable() throws Exception {
        JavaInfo parent = this.getParent();
        LocalUniqueVariableSupport variableSupport = new LocalUniqueVariableSupport(this.m_javaInfo);
        this.m_javaInfo.setVariableSupport(variableSupport);
        StatementTarget target = parent.getVariableSupport().getStatementTarget();
        ImplicitObjectAssociation association = new ImplicitObjectAssociation(parent);
        PureFlatStatementGenerator.INSTANCE.add(this.m_javaInfo, target, association);
        return variableSupport;
    }

    private void updateTarget_ifWasAfterParentStatement(NodeTarget target) throws Exception {
        StatementTarget statementTarget = target.getStatementTarget();
        if (statementTarget != null) {
            Statement oldStatement = this.updateTarget_getParentStatement();
            if (statementTarget.isAfter() && statementTarget.getStatement() == oldStatement) {
                Statement newStatement = this.updateTarget_getNewVariableStatement();
                statementTarget.setStatement(newStatement);
            }
        }
    }

    private Statement updateTarget_getParentStatement() throws Exception {
        return this.getParent().getVariableSupport().getStatementTarget().getStatement();
    }

    private Statement updateTarget_getNewVariableStatement() {
        Expression variableExpression = ((LocalUniqueVariableSupport)this.m_javaInfo.getVariableSupport()).m_variable;
        return AstNodeUtils.getEnclosingStatement((ASTNode)variableExpression);
    }
}

