/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.remote.internal;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.terminal.connector.ISettingsStore;
import org.eclipse.terminal.connector.ITerminalControl;
import org.eclipse.terminal.connector.NullSettingsStore;
import org.eclipse.terminal.connector.TerminalState;
import org.eclipse.terminal.connector.provider.AbstractTerminalConnector;
import org.eclipse.tm.terminal.connector.remote.IRemoteSettings;
import org.eclipse.tm.terminal.connector.remote.internal.RemoteConnectionManager;
import org.eclipse.tm.terminal.connector.remote.internal.RemoteSettings;

public class RemoteConnector
extends AbstractTerminalConnector {
    private OutputStream fOutputStream;
    private InputStream fInputStream;
    private RemoteConnectionManager fConnection;
    private int fWidth;
    private int fHeight;
    private final RemoteSettings fSettings;

    public RemoteConnector() {
        this(new RemoteSettings());
    }

    public RemoteConnector(RemoteSettings settings) {
        this.fSettings = settings;
    }

    public void connect(ITerminalControl control) {
        super.connect(control);
        this.fControl.setState(TerminalState.CONNECTING);
        this.fConnection = new RemoteConnectionManager(this, control);
        this.fConnection.schedule();
    }

    public synchronized void doDisconnect() {
        this.fConnection.cancel();
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public String getSettingsSummary() {
        return this.fSettings.getSummary();
    }

    public IRemoteSettings getRemoteSettings() {
        return this.fSettings;
    }

    public OutputStream getTerminalToRemoteStream() {
        return this.fOutputStream;
    }

    public void load(ISettingsStore store) {
        this.fSettings.load(store);
    }

    public void setDefaultSettings() {
        this.fSettings.load((ISettingsStore)new NullSettingsStore());
    }

    public void save(ISettingsStore store) {
        this.fSettings.save(store);
    }

    public void setInputStream(InputStream inputStream) {
        this.fInputStream = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.fOutputStream = outputStream;
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.fConnection != null && (newWidth != this.fWidth || newHeight != this.fHeight)) {
            this.fConnection.setTerminalSize(newWidth, newHeight, 8 * newWidth, 8 * newHeight);
            this.fWidth = newWidth;
            this.fHeight = newHeight;
        }
    }
}

