/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DecorationEditPolicy;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.part.IDiagramDialectGraphicalViewer;

public class EditStatusUpdater
implements NotificationListener {
    private IDiagramElementEditPart host;

    public EditStatusUpdater(IDiagramElementEditPart self) {
        this.host = self;
    }

    public void notifyChanged(Notification message) {
        switch (message.getEventType()) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                IDiagramDialectGraphicalViewer viewer;
                Object newValue = message.getNewValue();
                if (!(newValue instanceof EObject) || (viewer = EditStatusUpdater.getViewer(this.host)) == null) break;
                EditStatusUpdater.enableRelatedAndChildren(viewer, (EObject)newValue);
                break;
            }
            case 4: 
            case 6: {
                if (!EditStatusUpdater.isADelete(message)) break;
                Object oldValue = message.getOldValue();
                IDiagramDialectGraphicalViewer viewer = EditStatusUpdater.getViewer(this.host);
                if (viewer == null) break;
                EditStatusUpdater.disableRelatedAndChildren(viewer, (EObject)oldValue);
                break;
            }
        }
    }

    private static IDiagramDialectGraphicalViewer getViewer(IDiagramElementEditPart editPart) {
        EditPartViewer viewer;
        RootEditPart rootPart;
        if (editPart.isActive() && (rootPart = editPart.getRoot()) != null && (viewer = rootPart.getViewer()) instanceof IDiagramDialectGraphicalViewer) {
            return (IDiagramDialectGraphicalViewer)viewer;
        }
        return null;
    }

    private static void disableRelatedAndChildren(IDiagramDialectGraphicalViewer viewer, EObject removedSemanticElement) {
        EditStatusUpdater.changeEnabilityForRelatedAndChildren(viewer, removedSemanticElement, false);
    }

    private static void enableRelatedAndChildren(IDiagramDialectGraphicalViewer viewer, EObject addedSemanticElement) {
        EditStatusUpdater.changeEnabilityForRelatedAndChildren(viewer, addedSemanticElement, true);
    }

    private static void changeEnabilityForRelatedAndChildren(IDiagramDialectGraphicalViewer viewer, EObject addedSemanticElement, boolean enability) {
        EditStatusUpdater.changeEnability(viewer, addedSemanticElement, enability);
        TreeIterator children = addedSemanticElement.eAllContents();
        while (children.hasNext()) {
            EditStatusUpdater.changeEnability(viewer, (EObject)children.next(), enability);
        }
    }

    private static void changeEnability(IDiagramDialectGraphicalViewer viewer, EObject semanticElement, boolean enability) {
        List<IGraphicalEditPart> concernedEditParts = viewer.findEditPartsForElement(semanticElement, IGraphicalEditPart.class);
        for (IGraphicalEditPart editPart : concernedEditParts) {
            if (editPart.isEditModeEnabled() == enability) continue;
            EditStatusUpdater.setEnability(editPart, enability);
        }
    }

    private static void setEnability(IGraphicalEditPart self, boolean enability) {
        ConnectionEditPart gmfConnection;
        if (!enability) {
            self.disableEditMode();
        } else {
            self.enableEditMode();
        }
        DecorationEditPolicy decorationEditPolicy = (DecorationEditPolicy)self.getEditPolicy((Object)"DecorationPolicy");
        if (decorationEditPolicy != null && self.isActive() && self.getRoot() != null) {
            decorationEditPolicy.refresh();
        }
        for (Object gefConnection : self.getSourceConnections()) {
            if (!(gefConnection instanceof ConnectionEditPart)) continue;
            gmfConnection = (ConnectionEditPart)gefConnection;
            EditStatusUpdater.setEnability((IGraphicalEditPart)gmfConnection, enability);
        }
        for (Object gefConnection : self.getTargetConnections()) {
            if (!(gefConnection instanceof ConnectionEditPart)) continue;
            gmfConnection = (ConnectionEditPart)gefConnection;
            EditStatusUpdater.setEnability((IGraphicalEditPart)gmfConnection, enability);
        }
    }

    private static boolean isADelete(Notification message) {
        boolean isADelete = false;
        Object f = message.getFeature();
        if (f instanceof EReference && !((EReference)f).isContainment()) {
            return isADelete;
        }
        Object oldValue = message.getOldValue();
        if (oldValue instanceof EObject) {
            isADelete = ((EObject)oldValue).eContainer() == null;
        }
        return isADelete;
    }
}

