/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.profile.core.data.ProfilerGlobalData;
import org.eclipse.php.profile.core.engine.ProfilerDB;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.ProfilerUiPlugin;
import org.eclipse.php.profile.ui.report.TreeViewer2HTML;
import org.eclipse.php.profile.ui.utils.ProfileUITools;
import org.eclipse.php.profile.ui.views.AbstractProfilerFunctionsView;
import org.eclipse.php.profile.ui.views.ProfilerInformationView;
import org.eclipse.ui.IViewPart;
import org.osgi.framework.Bundle;

public class HTMLReporter {
    private static final DecimalFormat fDecimalFormat = new DecimalFormat("#0.0#", new DecimalFormatSymbols(new Locale("en")));
    private static final String CSS_PATH = "resources/html_report.css";
    private static final String JAVASCRIPT_PATH = "resources/html_report.js";
    public static final String IMAGES_DIR = "report_images";
    private ProfilerDB fProfilerDB;
    private String[] fViews;
    private PrintWriter fWriter;

    public HTMLReporter(ProfilerDB profilerDB, String[] views, PrintWriter writer) {
        this.fProfilerDB = profilerDB;
        this.fViews = views;
        this.fWriter = writer;
    }

    private void readFile(String file) {
        try {
            BufferedReader is = new BufferedReader(new InputStreamReader(FileLocator.openStream((Bundle)ProfilerUiPlugin.getDefault().getBundle(), (IPath)new Path(file), (boolean)false)));
            String line = null;
            while ((line = is.readLine()) != null) {
                this.fWriter.println(line);
            }
            is.close();
        }
        catch (Exception e) {
            ProfilerUiPlugin.log(e);
        }
    }

    private void addCSS() {
        this.fWriter.println("<style type=\"text/css\">");
        this.readFile(CSS_PATH);
        this.fWriter.println("</style>");
    }

    private void addJavaScript() {
        this.fWriter.println("<script type=\"text/javascript\">");
        this.readFile(JAVASCRIPT_PATH);
        this.fWriter.println("</script>");
    }

    private void addHeader() {
        this.fWriter.println("<head>");
        this.fWriter.print("<title>");
        this.fWriter.print(NLS.bind((String)PHPProfileUIMessages.getString("HTMLReporter.8"), (Object)this.fProfilerDB.getGlobalData().getURI(), (Object)this.fProfilerDB.getProfileDate()));
        this.fWriter.print("</title>");
        this.addCSS();
        this.addJavaScript();
        this.fWriter.println("</head>");
    }

    private void generateViewReport(String viewId) {
        IViewPart view = ProfileUITools.findExistingView(viewId);
        if (view instanceof AbstractProfilerFunctionsView) {
            this.fWriter.print("<h2>");
            this.fWriter.print(view.getTitle());
            this.fWriter.println("</h2>");
            this.fWriter.println("<br>");
            TreeViewer2HTML.process(((AbstractProfilerFunctionsView)view).getViewer(), this.fWriter);
        }
    }

    private void printGlobalDataRow(String key, String value) {
        this.fWriter.print("<tr><td>");
        this.fWriter.print(key);
        this.fWriter.print("</td><td>");
        this.fWriter.print(value);
        this.fWriter.println("</td><tr>");
    }

    private void generateGlobalInfoReport() {
        this.fWriter.println("<table cellpadding=4 cellspacing=0>");
        this.fWriter.println("<colgroup><col id=\"col1\"/><col width=\"0*\" id=\"col2\"/></colgroup>");
        ProfilerGlobalData globalData = this.fProfilerDB.getGlobalData();
        this.printGlobalDataRow(PHPProfileUIMessages.getString("HTMLReporter.0"), globalData.getOriginalURL());
        this.printGlobalDataRow(PHPProfileUIMessages.getString("HTMLReporter.1"), ProfilerInformationView.calculateQueryMessage(globalData.getQuery()));
        this.printGlobalDataRow(PHPProfileUIMessages.getString("HTMLReporter.2"), globalData.getPath());
        this.printGlobalDataRow(PHPProfileUIMessages.getString("HTMLReporter.3"), fDecimalFormat.format(globalData.getGlobalTimeInMilli()));
        this.printGlobalDataRow(PHPProfileUIMessages.getString("HTMLReporter.4"), Integer.toString(globalData.getFileCount()));
        this.printGlobalDataRow(PHPProfileUIMessages.getString("HTMLReporter.5"), this.fProfilerDB.getProfileDate().toString());
        this.fWriter.print("</table><br>\n");
    }

    private void generateReport() {
        this.fWriter.println("<html>");
        this.addHeader();
        this.fWriter.println("<body>");
        this.fWriter.println("<center>");
        this.fWriter.print("<h1>");
        this.fWriter.print(PHPProfileUIMessages.getString("HTMLReporter.6"));
        this.fWriter.println("</h1><br>");
        this.generateGlobalInfoReport();
        int i = 0;
        while (i < this.fViews.length) {
            this.generateViewReport(this.fViews[i]);
            this.fWriter.println("<br>");
            ++i;
        }
        this.fWriter.println("</center>\n</body>\n</html>");
    }

    public static void generateReport(ProfilerDB profilerDB, String[] views, PrintWriter writer) {
        HTMLReporter reporter = new HTMLReporter(profilerDB, views, writer);
        reporter.generateReport();
    }

    public static void saveImages(String targetDirectory) throws IOException {
        File target = new File((String)(targetDirectory = (String)targetDirectory + File.separatorChar + IMAGES_DIR));
        if (!target.exists()) {
            URL imagesURL = FileLocator.find((Bundle)ProfilerUiPlugin.getDefault().getBundle(), (IPath)new Path("resources/report_images"), new HashMap());
            File imagesDir = new File(FileLocator.toFileURL((URL)imagesURL).getPath());
            try {
                new LocalFile(imagesDir).copy((IFileStore)new LocalFile(new File((String)targetDirectory)), 0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                ProfilerUiPlugin.log(e);
            }
        }
    }
}

