/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.daemon.communication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.debug.daemon.DaemonPlugin;
import org.eclipse.php.internal.debug.daemon.Logger;

public class DaemonsRegistry {
    private static Map<String, ICommunicationDaemon> daemons = null;
    protected static final String PROP_ID = "id";
    protected static final String PROP_OVERRIDES = "overrides";
    protected static final String PROP_CLASS = "class";
    public static final String EXTENSION_POINT_ID = DaemonPlugin.getDefault().getBundle().getSymbolicName() + ".debugCommunicationDaemon";
    private static DaemonsRegistry instance;

    protected static final Map<String, ICommunicationDaemon> getDaemonsMap() {
        if (daemons == null) {
            daemons = DaemonsRegistry.getDefault().readFromExtensionPoint();
        }
        return daemons;
    }

    public static final ICommunicationDaemon getDaemon(String id) {
        return DaemonsRegistry.getDaemonsMap().get(id);
    }

    public static final List<ICommunicationDaemon> getDaemons() {
        return new ArrayList<ICommunicationDaemon>(DaemonsRegistry.getDaemonsMap().values());
    }

    protected static DaemonsRegistry getDefault() {
        if (instance == null) {
            instance = new DaemonsRegistry();
        }
        return instance;
    }

    protected Map<String, ICommunicationDaemon> readFromExtensionPoint() {
        IConfigurationElement[] configurationElements;
        ArrayList<Entry> entries = new ArrayList<Entry>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String id = element.getAttribute(PROP_ID);
            String overridenProviderId = element.getAttribute(PROP_OVERRIDES);
            entries.add(new Entry(element, id, overridenProviderId));
            ++n2;
        }
        return this.fetchDaemons(entries);
    }

    protected Object createInstance(IConfigurationElement element, String propertyName, Class instanceClass) throws CoreException {
        Object object = element.createExecutableExtension(propertyName);
        if (!instanceClass.isAssignableFrom(object.getClass())) {
            String message = String.format("Invalid typecast for %s", element.getAttribute(propertyName));
            Status status = new Status(4, DaemonPlugin.getDefault().getBundle().getSymbolicName(), message);
            throw new CoreException((IStatus)status);
        }
        return object;
    }

    private Map<String, ICommunicationDaemon> fetchDaemons(List<Entry> entries) {
        HashMap<String, ICommunicationDaemon> daemons = new HashMap<String, ICommunicationDaemon>();
        ArrayList<Entry> topHierarchyEntries = new ArrayList<Entry>();
        for (Entry entryToCheck : entries) {
            boolean isTopHierarchy = true;
            for (Entry entry : entries) {
                if (!entryToCheck.id.equals(entry.overridenDaemonId)) continue;
                isTopHierarchy = false;
                break;
            }
            if (!isTopHierarchy) continue;
            topHierarchyEntries.add(entryToCheck);
        }
        for (Entry entry : topHierarchyEntries) {
            ICommunicationDaemon daemon;
            try {
                daemon = (ICommunicationDaemon)this.createInstance(entry.element, PROP_CLASS, ICommunicationDaemon.class);
            }
            catch (CoreException e) {
                Logger.logException("Could not instantiate communication daemon from extension point data.", e);
                continue;
            }
            daemons.put(entry.id, daemon);
        }
        return daemons;
    }

    private class Entry {
        IConfigurationElement element;
        String id;
        String overridenDaemonId;

        public Entry(IConfigurationElement element, String id, String overridenDaemonId) {
            this.element = element;
            this.id = id;
            this.overridenDaemonId = overridenDaemonId;
        }
    }
}

