/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ecore;

import java.util.List;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.library.AbstractOperation;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class EObjectOperation
extends AbstractOperation {
    protected final @NonNull Operation operation;
    protected final @NonNull EOperation eFeature;
    protected final @NonNull ExpressionInOCL specification;

    public EObjectOperation(@NonNull Operation operation, @NonNull EOperation eFeature, @NonNull ExpressionInOCL specification) {
        this.operation = operation;
        this.eFeature = eFeature;
        this.specification = specification;
    }

    @Override
    public @Nullable Object basicEvaluate(@NonNull Executor executor, @NonNull TypedElement caller, @Nullable Object @NonNull [] boxedSourceAndArgumentValues) {
        if (this.specification.getOwnedBody() == null) {
            try {
                EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)executor.getEnvironmentFactory();
                environmentFactory.parseSpecification(this.specification);
            }
            catch (ParserException e) {
                throw new InvalidValueException(e, "parse failure", executor.getEvaluationEnvironment(), boxedSourceAndArgumentValues[0], caller);
            }
        }
        ExpressionInOCL query = this.specification;
        EvaluationEnvironment nestedEvaluationEnvironment = ((Executor.ExecutorExtension)executor).pushEvaluationEnvironment((NamedElement)query, caller);
        nestedEvaluationEnvironment.add(ClassUtil.nonNullModel(query.getOwnedContext()), boxedSourceAndArgumentValues[0]);
        List<Variable> parameterVariables = query.getOwnedParameters();
        int iMax = Math.min(parameterVariables.size(), boxedSourceAndArgumentValues.length - 1);
        int i = 0;
        while (i < iMax) {
            nestedEvaluationEnvironment.add(ClassUtil.nonNullModel(parameterVariables.get(i)), boxedSourceAndArgumentValues[i + 1]);
            ++i;
        }
        try {
            Object object = executor.evaluate(ClassUtil.nonNullPivot(query.getOwnedBody()));
            return object;
        }
        finally {
            executor.popEvaluationEnvironment();
        }
    }

    @Override
    public @Nullable Object dispatch(@NonNull Executor executor, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
        assert (!PivotUtil.getReferredOperation(callExp).isIsValidating());
        List<@NonNull OCLExpression> arguments = ClassUtil.nullFree(callExp.getOwnedArguments());
        @Nullable Object[] sourceAndArgumentValues = new Object[1 + arguments.size()];
        int argumentIndex = 0;
        sourceAndArgumentValues[argumentIndex++] = sourceValue;
        for (OCLExpression argument : arguments) {
            sourceAndArgumentValues[argumentIndex++] = executor.evaluate(argument);
        }
        return this.evaluate(executor, callExp, sourceAndArgumentValues);
    }
}

