/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.m2m.qvt.oml.blackbox.java.Module;

public abstract class ModuleHandle {
    private final String className;
    private final String simpleName;

    public ModuleHandle(String className, String moduleName) {
        if (className == null || moduleName == null) {
            throw new IllegalArgumentException();
        }
        this.className = className;
        this.simpleName = moduleName;
    }

    public String getModuleName() {
        return this.simpleName;
    }

    public String getJavaClassName() {
        return this.className;
    }

    public List<String> getUsedPackages() {
        try {
            Module annotation = this.getModuleJavaClass().getAnnotation(Module.class);
            return annotation == null ? Collections.emptyList() : Arrays.asList(annotation.packageURIs());
        }
        catch (ClassNotFoundException e) {
            return Collections.emptyList();
        }
    }

    public Class<?> getModuleJavaClass() throws ClassNotFoundException {
        return Class.forName(this.className);
    }

    public String toString() {
        return String.valueOf(this.simpleName) + ", javaClass: " + this.className;
    }
}

