/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.preferences;

import java.util.Locale;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.internal.rpm.ui.editor.preferences.Messages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class MainPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Combo combo;
    private int defaultItem;

    public MainPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    private FieldEditor changelogEntryFormatFieldEditor(Composite parent) {
        return new RadioGroupFieldEditor("changelogEntryFormat", Messages.MainPreferencePage_2, 1, (String[][])new String[][]{{Messages.MainPreferencePage_3, "1"}, {Messages.MainPreferencePage_4, "2"}, {Messages.MainPreferencePage_5, "3"}}, parent, true);
    }

    private void createLocalesCombo(Composite parent) {
        this.combo = new Combo(parent, 13);
        int selectedItem = 0;
        String lastLocale = this.getPreferenceStore().getString("changelogLocal");
        String[] countries = Locale.getISOCountries();
        for (int i = 0; i < countries.length; ++i) {
            Locale currentLocale = Locale.of(countries[i]);
            this.combo.add(countries[i] + " - " + currentLocale.getDisplayLanguage());
            if (countries[i].equals(lastLocale)) {
                selectedItem = i;
            }
            if (!countries[i].equals("US")) continue;
            this.defaultItem = i;
        }
        this.combo.select(selectedItem);
        this.combo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Combo combo = (Combo)e.getSource();
            this.getPreferenceStore().setValue("changelogLocal", combo.getText().split("-")[0].trim());
        }));
    }

    public void createFieldEditors() {
        GridData data = new GridData();
        data.horizontalSpan = 2;
        Composite parent = this.getFieldEditorParent();
        Link link = new Link(parent, 0);
        link.setText(Messages.MainPreferencePage_0);
        link.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)e.text, null, null)));
        this.addField(this.changelogEntryFormatFieldEditor(parent));
        Label labelLocal = new Label(parent, 0);
        labelLocal.setText(Messages.MainPreferencePage_1);
        labelLocal.setLayoutData((Object)data);
        this.createLocalesCombo(parent);
        this.addField((FieldEditor)new BooleanFieldEditor("SpacesForTabs", Messages.MainPreferencePage_6, parent));
        Composite numEditorComp = new Composite(parent, 0);
        IntegerFieldEditor numEditor = new IntegerFieldEditor("NbrOfSpacesForTab", Messages.MainPreferencePage_7, numEditorComp, 1);
        this.addField((FieldEditor)numEditor);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        this.combo.select(this.defaultItem);
        this.getPreferenceStore().setValue("changelogLocal", "US");
        this.getPreferenceStore().setValue("changelogEntryFormat", "1");
    }
}

