/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib_1_0.ComponentTagDefn;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib_1_0.ConverterTagDefn;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib_1_0.FaceletLibraryClassTagLib;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib_1_0.FaceletTaglibDefn;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib_1_0.FaceletTaglibFactory;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib_1_0.FaceletXMLDefnTaglib;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib_1_0.HandlerTagDefn;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib_1_0.SourceTagDefn;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib_1_0.TagDefn;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib_1_0.ValidatorTagDefn;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TagModelParser {
    private static final String FACELET_TAGLIB_DTD_PATH = "/dtd/facelet-taglib_1_0.dtd";
    private static final String ELEMENT_NAME_VALIDATOR_ID = "validator-id";
    private static final String ELEMENT_NAME_CONVERTER_ID = "converter-id";
    private static final String ELEMENT_NAME_RENDERER_TYPE = "renderer-type";
    private static final String ELEMENT_NAME_COMPONENT_TYPE = "component-type";
    private static final String ELEMENT_NAME_VALIDATOR = "validator";
    private static final String ELEMENT_NAME_CONVERTER = "converter";
    private static final String ELEMENT_NAME_COMPONENT = "component";
    private static final String ELEMENT_NAME_HANDLER_CLASS = "handler-class";
    private static final String ELEMENT_NAME_SOURCE = "source";
    private static final String ELEMENT_NAME_TAG_NAME = "tag-name";
    private static final String ELEMENT_NAME_TAG = "tag";
    private static final String ELEMENT_NAME_NAMESPACE = "namespace";
    private static final String ELEMENT_NAME_LIBRARY_CLASS = "library-class";
    private static final String ELEMENT_NAME_FACELET_TAGLIB = "facelet-taglib";
    private static final String URI_FACELET_TAGLIB_1_0_DTD = "facelet-taglib_1_0.dtd";
    private static final String PUBLIC_DTD_FACELET_TAGLIB_1_0_DTD = "-//Sun Microsystems, Inc.//DTD Facelet Taglib 1.0//EN";

    public static FaceletTaglibDefn loadFromInputStream(InputStream is, String dtdSourcePath) throws IOException, ParserConfigurationException, SAXException {
        byte[] buffer = TagModelParser.getBufferForEntry(is);
        InputStream dtdSource = TagModelParser.getDefaultDTDSource(dtdSourcePath != null ? dtdSourcePath : FACELET_TAGLIB_DTD_PATH);
        FaceletTaglibDefn taglib = TagModelParser.loadFromBuffer(buffer, dtdSource);
        return taglib;
    }

    public static FaceletTaglibDefn loadFromBuffer(byte[] buffer, InputStream defaultDtdStream) throws IOException, ParserConfigurationException, SAXException {
        InputSource inputSource = new InputSource(new ByteArrayInputStream(buffer));
        Document doc = TagModelParser.getDefaultTaglibDocument(inputSource, new InputSource(defaultDtdStream));
        FaceletTaglibDefn tagLib = TagModelParser.processDocument(doc);
        return tagLib;
    }

    protected static InputStream getDefaultDTDSource(String path) throws IOException {
        URL url = FaceletCorePlugin.getDefault().getBundle().getEntry(path);
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    protected static byte[] getBufferForEntry(InputStream is) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        int bytesRead = 0;
        try {
            while ((bytesRead = is.read(buffer)) != -1) {
                stream.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            FaceletCorePlugin.log("Error loading buffer", e);
            return null;
        }
        return stream.toByteArray();
    }

    public static Document getDefaultTaglibDocument(InputSource taglibFile, final InputSource defaultDTDSource) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        DefaultHandler handler = new DefaultHandler(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
                if (TagModelParser.PUBLIC_DTD_FACELET_TAGLIB_1_0_DTD.equals(publicId) || systemId != null && systemId.endsWith(TagModelParser.URI_FACELET_TAGLIB_1_0_DTD)) {
                    return defaultDTDSource;
                }
                return super.resolveEntity(publicId, systemId);
            }
        };
        builder.setEntityResolver(handler);
        return builder.parse(taglibFile);
    }

    public static FaceletTaglibDefn processDocument(Document doc) {
        Node curNode = null;
        int i = 0;
        while (i < doc.getChildNodes().getLength()) {
            curNode = doc.getChildNodes().item(i);
            if (curNode.getNodeType() == 1 && ELEMENT_NAME_FACELET_TAGLIB.equals(curNode.getNodeName())) break;
            ++i;
        }
        if (curNode == null) {
            throw new IllegalArgumentException("Couldn't find facelet-taglib node");
        }
        i = 0;
        while (i < curNode.getChildNodes().getLength()) {
            Node node = curNode.getChildNodes().item(i);
            if (node.getNodeType() == 1) {
                if (node.getTextContent() != null && ELEMENT_NAME_LIBRARY_CLASS.equals(node.getNodeName())) {
                    FaceletLibraryClassTagLib faceletLibraryClassTagLib = FaceletTaglibFactory.eINSTANCE.createFaceletLibraryClassTagLib();
                    faceletLibraryClassTagLib.setLibraryClass(node.getTextContent().trim());
                    return faceletLibraryClassTagLib;
                }
                return TagModelParser.processFaceletTaglibWithTags(curNode);
            }
            ++i;
        }
        return null;
    }

    private static FaceletXMLDefnTaglib processFaceletTaglibWithTags(Node node) {
        String namespace = null;
        ArrayList<Node> tagNodes = new ArrayList<Node>();
        int i = 0;
        while (i < node.getChildNodes().getLength()) {
            Node childNode = node.getChildNodes().item(i);
            if (childNode.getNodeType() == 1) {
                if (ELEMENT_NAME_NAMESPACE.equals(childNode.getNodeName())) {
                    namespace = childNode.getTextContent();
                } else if (ELEMENT_NAME_TAG.equals(childNode.getNodeName())) {
                    tagNodes.add(childNode);
                }
            }
            ++i;
        }
        if (namespace != null) {
            FaceletXMLDefnTaglib xmlDefnTaglib = FaceletTaglibFactory.eINSTANCE.createFaceletXMLDefnTaglib();
            xmlDefnTaglib.setNamespace(namespace);
            for (Node tagNode : tagNodes) {
                TagDefn tag = TagModelParser.createTagFromNode(namespace, tagNode);
                if (tag == null) continue;
                xmlDefnTaglib.getTags().add((Object)tag);
            }
            return xmlDefnTaglib;
        }
        return null;
    }

    private static TagDefn createTagFromNode(String namespace, Node tagNode) {
        Map<String, Node> children = TagModelParser.indexChildren(tagNode);
        Node node = children.get(ELEMENT_NAME_TAG_NAME);
        if (node != null) {
            String name = TagModelParser.safeGetTextContext(node);
            if (name == null) {
                return null;
            }
            node = children.get(ELEMENT_NAME_HANDLER_CLASS);
            if (node != null) {
                HandlerTagDefn handlerTag = FaceletTaglibFactory.eINSTANCE.createHandlerTagDefn();
                handlerTag.setHandlerClass(TagModelParser.safeGetTextContext(node));
                handlerTag.setName(name);
                return handlerTag;
            }
            node = children.get(ELEMENT_NAME_SOURCE);
            if (node != null) {
                SourceTagDefn sourceTag = FaceletTaglibFactory.eINSTANCE.createSourceTagDefn();
                sourceTag.setSource(TagModelParser.safeGetTextContext(node));
                sourceTag.setName(name);
                return sourceTag;
            }
            node = children.get(ELEMENT_NAME_COMPONENT);
            if (node != null) {
                return TagModelParser.createTagWithComponentType(namespace, name, node);
            }
            node = children.get(ELEMENT_NAME_CONVERTER);
            if (node != null) {
                return TagModelParser.createTagWithConverter(namespace, name, node);
            }
            node = children.get(ELEMENT_NAME_VALIDATOR);
            if (node != null) {
                return TagModelParser.createValidatorTag(namespace, name, node);
            }
        }
        return null;
    }

    private static ComponentTagDefn createTagWithComponentType(String uri, String tagName, Node paramNode) {
        Map<String, Node> componentChildren = TagModelParser.indexChildren(paramNode);
        Node node = componentChildren.get(ELEMENT_NAME_COMPONENT_TYPE);
        if (node != null) {
            String componentType = TagModelParser.safeGetTextContext(node);
            String rendererType = null;
            String handlerClass = null;
            node = componentChildren.get(ELEMENT_NAME_RENDERER_TYPE);
            if (node != null) {
                rendererType = TagModelParser.safeGetTextContext(node);
            }
            if ((node = componentChildren.get(ELEMENT_NAME_HANDLER_CLASS)) != null) {
                handlerClass = TagModelParser.safeGetTextContext(node);
            }
            ComponentTagDefn componentTag = FaceletTaglibFactory.eINSTANCE.createComponentTagDefn();
            componentTag.setName(tagName);
            componentTag.setComponentType(componentType);
            componentTag.setHandlerClass(handlerClass);
            componentTag.setRendererType(rendererType);
            return componentTag;
        }
        return null;
    }

    private static ConverterTagDefn createTagWithConverter(String uri, String tagName, Node paramNode) {
        Map<String, Node> converterChildren = TagModelParser.indexChildren(paramNode);
        Node node = converterChildren.get(ELEMENT_NAME_CONVERTER_ID);
        if (node != null) {
            String converterId = TagModelParser.safeGetTextContext(node);
            String handlerClass = null;
            node = converterChildren.get(ELEMENT_NAME_HANDLER_CLASS);
            if (node != null) {
                handlerClass = TagModelParser.safeGetTextContext(node);
            }
            ConverterTagDefn converterTag = FaceletTaglibFactory.eINSTANCE.createConverterTagDefn();
            converterTag.setName(tagName);
            converterTag.setConverterId(converterId);
            converterTag.setHandlerClass(handlerClass);
            return converterTag;
        }
        return null;
    }

    private static ValidatorTagDefn createValidatorTag(String uri, String tagName, Node paramNode) {
        Map<String, Node> converterChildren = TagModelParser.indexChildren(paramNode);
        Node node = converterChildren.get(ELEMENT_NAME_VALIDATOR_ID);
        if (node != null) {
            String validatorId = TagModelParser.safeGetTextContext(node);
            String handlerClass = null;
            node = converterChildren.get(ELEMENT_NAME_HANDLER_CLASS);
            if (node != null) {
                handlerClass = TagModelParser.safeGetTextContext(node);
            }
            ValidatorTagDefn validatorTag = FaceletTaglibFactory.eINSTANCE.createValidatorTagDefn();
            validatorTag.setName(tagName);
            validatorTag.setHandlerClass(handlerClass);
            validatorTag.setValidatorId(validatorId);
            return validatorTag;
        }
        return null;
    }

    private static Map<String, Node> indexChildren(Node node) {
        HashMap<String, Node> children = new HashMap<String, Node>();
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1) {
                children.put(childNode.getNodeName(), childNode);
            }
            ++i;
        }
        return children;
    }

    private static String safeGetTextContext(Node node) {
        String textContent = node.getTextContent();
        if (textContent == null) {
            return null;
        }
        if ("".equals(textContent = textContent.trim())) {
            return null;
        }
        return textContent;
    }
}

