/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jpt.common.utility.internal.jdbc.ResultSetCommand;
import org.eclipse.jpt.common.utility.internal.jdbc.ResultSetCommandAdapter;
import org.eclipse.jpt.common.utility.internal.jdbc.ResultSetRowTransformer;
import org.eclipse.jpt.common.utility.internal.jdbc.ResultSetTools;

public class ConnectionTools {
    public static final ResultSetCommand CONSOLE_DUMP_COMMAND = new ConsoleDumpCommand();

    public static List<Map<String, Object>> execute(Connection connection, String sql) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute(sql);
            ArrayList<Map<String, Object>> arrayList = ResultSetTools.convertToMaps(statement.getResultSet());
            return arrayList;
        }
    }

    public static void execute(Connection connection, String sql, ResultSetCommand command) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute(sql);
            command.execute(statement.getResultSet());
        }
    }

    public static <E> List<E> execute(Connection connection, String sql, ResultSetRowTransformer<? extends E> transformer) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute(sql);
            ArrayList<? extends E> arrayList = ResultSetTools.convertToList(statement.getResultSet(), transformer);
            return arrayList;
        }
    }

    public static void dump(Connection connection, String sql) throws SQLException {
        ConnectionTools.execute(connection, sql, CONSOLE_DUMP_COMMAND);
    }

    public static void dumpOn(Connection connection, String sql, PrintWriter pw) throws SQLException {
        ConnectionTools.execute(connection, sql, new DumpCommand(pw));
    }

    public static class ConsoleDumpCommand
    extends ResultSetCommandAdapter {
        @Override
        public void execute(ResultSet resultSet) throws SQLException {
            ResultSetTools.dump(resultSet);
        }
    }

    public static class DumpCommand
    extends ResultSetCommandAdapter {
        private final PrintWriter printWriter;

        public DumpCommand(PrintWriter printWriter) {
            this.printWriter = printWriter;
        }

        @Override
        public void execute(ResultSet resultSet) throws SQLException {
            ResultSetTools.dumpOn(resultSet, this.printWriter);
        }
    }
}

