/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.commit;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;

public final class CDORevisionAvailabilityInfo
implements CDORevisionProvider {
    private final Map<CDOID, CDORevisionKey> availableRevisions = CDOIDUtil.createMap();
    private CDOBranchPoint branchPoint;
    private CDORevisionManager revisionManager;

    public CDORevisionAvailabilityInfo(CDOBranchPoint branchPoint, CDORevisionManager revisionManager) {
        this.branchPoint = branchPoint;
        this.revisionManager = revisionManager;
    }

    public CDORevisionAvailabilityInfo(CDOBranchPoint branchPoint) {
        this(branchPoint, null);
    }

    public CDOBranchPoint getBranchPoint() {
        return this.branchPoint;
    }

    public void setBranchPoint(CDOBranchPoint branchPoint) {
        this.branchPoint = branchPoint;
    }

    public Map<CDOID, CDORevisionKey> getAvailableRevisions() {
        return this.availableRevisions;
    }

    public void addRevision(CDORevisionKey key) {
        this.availableRevisions.put(key.getID(), key);
    }

    public void removeRevision(CDOID id) {
        this.availableRevisions.remove(id);
    }

    public boolean containsRevision(CDOID id) {
        return this.availableRevisions.containsKey(id);
    }

    @Override
    public CDORevision getRevision(CDOID id) {
        CDORevision revision = (CDORevision)this.availableRevisions.get(id);
        if (revision == null && this.revisionManager != null) {
            return this.revisionManager.getRevision(id, this.branchPoint, -1, 0, true);
        }
        return revision;
    }

    public String toString() {
        return MessageFormat.format("CDORevisionAvailabilityInfo[{0} -> {1} ]", this.branchPoint, this.availableRevisions.values());
    }
}

