/*******************************************************************************
 * Copyright (c) 2005, 2017 IBM Corporation and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 *******************************************************************************/
package org.eclipse.dltk.ast;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.dltk.utils.CorePrinter;

public class ASTListNode extends ASTNode {

	private final List<ASTNode> nodes;

	public ASTListNode(int start, int end, List<ASTNode> nodes) {
		super(start, end);
		this.nodes = nodes;
	}

	public ASTListNode(int start, int end) {
		super(start, end);
		this.nodes = new ArrayList<>();
	}

	public ASTListNode() {
		super(0, -1);
		this.nodes = new ArrayList<>();
	}

	public void addNode(ASTNode s) {
		if (s != null) {
			nodes.add(s);
		}
	}

	@Override
	public List<ASTNode> getChilds() {
		return nodes;
	}

	public void setChilds(List<ASTNode> l) {
		this.nodes.clear();
		this.nodes.addAll(l);
	}

	public int getKind() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public void traverse(ASTVisitor visitor) throws Exception {
		if (visitor.visit(this)) {
			if (nodes != null) {
				for (ASTNode s : nodes) {
					s.traverse(visitor);
				}
			}
			visitor.endvisit(this);
		}
	}

	@Override
	public void printNode(CorePrinter output) {
		if (this.nodes != null) {
			output.print('[');
			for (ASTNode s : nodes) {
				s.printNode(output);
			}
			output.print(']');
		}
	}

}
