/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.common.service;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.test.common.filter.Filters;
import org.osgi.test.common.service.ServiceAware;
import org.osgi.test.common.service.ServiceConfigurationKey;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceConfiguration<S>
implements AutoCloseable,
ServiceAware<S> {
    private final int cardinality;
    private final Filter filter;
    private final Class<S> serviceType;
    private final long timeout;
    private volatile ServiceTracker<S, S> tracker;

    public ServiceConfiguration(ServiceConfigurationKey<S> key) {
        this(key.serviceType, key.filter, key.filterArguments, key.cardinality, key.timeout);
    }

    public ServiceConfiguration(Class<S> serviceType, String format, String[] args, int cardinality, long timeout) {
        this.serviceType = Objects.requireNonNull(serviceType);
        Filter filter = null;
        format = String.format(Objects.requireNonNull(format), Objects.requireNonNull(args));
        filter = !format.isEmpty() ? ("org.osgi.test.common.annotation.InjectService$AnyService".equals(serviceType.getName()) ? Filters.format(format, new Object[0]) : Filters.format("(&(objectClass=%s)%s)", serviceType.getName(), format)) : Filters.format("(objectClass=%s)", serviceType.getName());
        this.filter = filter;
        if (cardinality < 0) {
            throw new IllegalArgumentException("cardinality must be zero or greater");
        }
        this.cardinality = cardinality;
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be zero or greater");
        }
        this.timeout = timeout;
    }

    public ServiceConfiguration<S> init(BundleContext bundleContext) {
        Objects.requireNonNull(bundleContext);
        CountDownLatch countDownLatch = new CountDownLatch(this.getCardinality());
        ServiceTracker tracker = new ServiceTracker(bundleContext, this.getFilter(), new InnerCustomizer<S>(bundleContext, countDownLatch, this.getCustomizer()));
        tracker.open();
        try {
            Instant endTime = Instant.now().plusMillis(this.getTimeout());
            if (!countDownLatch.await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                throw new AssertionError((Object)(this.getCardinality() - tracker.size() + "/" + this.getCardinality() + " services " + this.getFilter() + " didn't arrive within " + this.getTimeout() + "ms"));
            }
            while (tracker.size() < this.cardinality) {
                if (Instant.now().isAfter(endTime)) {
                    throw new AssertionError((Object)(this.getCardinality() - tracker.size() + "/" + this.getCardinality() + " services " + this.getFilter() + " didn't arrive within " + this.getTimeout() + "ms"));
                }
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        this.tracker = tracker;
        return this;
    }

    @Override
    public void close() {
        ServiceTracker<S, S> tracker = this.tracker;
        if (tracker != null) {
            tracker.close();
        }
    }

    public String toString() {
        return String.format("ServiceConfiguration [Class=\"%s\", filter=\"%s\", cardinality=%s, timeout=%s]", this.getServiceType(), this.getFilter(), this.getCardinality(), this.getTimeout());
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    public ServiceTrackerCustomizer<S, S> getCustomizer() {
        return null;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public S getService() {
        return (S)this.tracker.getService();
    }

    @Override
    public S getService(ServiceReference<S> reference) {
        return (S)this.tracker.getService(reference);
    }

    @Override
    public ServiceReference<S> getServiceReference() {
        return this.tracker.getServiceReference();
    }

    private <R> List<R> listOf(Function<ServiceReference<S>, R> mapper) {
        ServiceReference[] serviceReferences = this.tracker.getServiceReferences();
        if (serviceReferences == null) {
            return new ArrayList();
        }
        return Arrays.stream(serviceReferences).sorted().map(mapper).collect(Collectors.toList());
    }

    @Override
    public List<ServiceReference<S>> getServiceReferences() {
        return this.listOf(Function.identity());
    }

    @Override
    public List<S> getServices() {
        return this.listOf(this::getService);
    }

    @Override
    public Class<S> getServiceType() {
        return this.serviceType;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public int getTrackingCount() {
        return this.tracker.getTrackingCount();
    }

    @Override
    public SortedMap<ServiceReference<S>, S> getTracked() {
        return this.tracker.getTracked();
    }

    @Override
    public boolean isEmpty() {
        return this.tracker.isEmpty();
    }

    @Override
    public int size() {
        return this.tracker.size();
    }

    @Override
    public S waitForService(long timeout) throws InterruptedException {
        return (S)this.tracker.waitForService(timeout);
    }

    private static class InnerCustomizer<S>
    implements ServiceTrackerCustomizer<S, S> {
        private final BundleContext bundleContext;
        private final CountDownLatch countDownLatch;
        private final Optional<ServiceTrackerCustomizer<S, S>> delegate;

        InnerCustomizer(BundleContext bundleContext, CountDownLatch countDownLatch, ServiceTrackerCustomizer<S, S> delegate) {
            this.bundleContext = bundleContext;
            this.countDownLatch = countDownLatch;
            this.delegate = Optional.ofNullable(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public S addingService(ServiceReference<S> reference) {
            Object service = this.delegate.map(c -> c.addingService(reference)).orElseGet(() -> this.bundleContext.getService(reference));
            try {
                Object object = service;
                return (S)object;
            }
            finally {
                if (service != null) {
                    this.countDownLatch.countDown();
                }
            }
        }

        public void modifiedService(ServiceReference<S> reference, S service) {
            this.delegate.ifPresent(c -> c.modifiedService(reference, service));
        }

        public void removedService(ServiceReference<S> reference, S service) {
            this.delegate.map(c -> {
                c.removedService(reference, service);
                return true;
            }).orElseGet(() -> this.bundleContext.ungetService(reference));
        }
    }
}

